/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.effect;

import com.soytutta.mynethersdelight.common.registry.MNDEffects;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PungentEffect
extends MobEffect {
    public PungentEffect() {
        super(MobEffectCategory.BENEFICIAL, 0, (ParticleOptions)ParticleTypes.ASH);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        MobEffectInstance fireResistanceEffect = entity.getEffect(MobEffects.FIRE_RESISTANCE);
        MobEffectInstance BPungentEffect = entity.getEffect(MNDEffects.BPUNGENT);
        MobEffectInstance GPungentEffect = entity.getEffect(MNDEffects.GPUNGENT);
        if (entity.fireImmune() || fireResistanceEffect != null) {
            this.switchEffect(entity, BPungentEffect, (MobEffect)MNDEffects.GPUNGENT.value());
        } else {
            this.switchEffect(entity, GPungentEffect, (MobEffect)MNDEffects.BPUNGENT.value());
        }
        if (this.isInFireCondition(entity) || entity.isInLava() || entity.isOnFire()) {
            float minHealth;
            float f = amplifier >= 2 ? 2.0f : (minHealth = amplifier == 1 ? entity.getMaxHealth() / 2.0f : entity.getMaxHealth() - entity.getMaxHealth() / 4.0f);
            if (entity.getHealth() > minHealth) {
                entity.hurt(entity.damageSources().magic(), 1.0f);
            }
            if (this.isInFireCondition(entity)) {
                if (entity.getHealth() > minHealth) {
                    entity.setRemainingFireTicks(3);
                }
            } else if (entity.isOnFire()) {
                entity.setRemainingFireTicks(0);
                entity.clearFire();
            }
        }
        return true;
    }

    private void switchEffect(LivingEntity entity, MobEffectInstance currentEffect, MobEffect newEffect) {
        if (currentEffect != null) {
            int duration = currentEffect.getDuration();
            int level = currentEffect.getAmplifier();
            entity.removeEffect(currentEffect.getEffect());
            Holder effectHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)newEffect);
            entity.addEffect(new MobEffectInstance(effectHolder, duration, level));
        }
    }

    private boolean isInFireCondition(LivingEntity entity) {
        Level world = entity.level();
        BlockPos entityPos = entity.blockPosition();
        boolean isOnFlame = false;
        int areaSize = 1;
        for (int x = -areaSize; x <= areaSize; ++x) {
            for (int y = -areaSize; y <= areaSize; ++y) {
                for (int z = -areaSize; z <= areaSize; ++z) {
                    BlockPos pos = entityPos.offset(x, y, z);
                    BlockState blockState = world.getBlockState(pos);
                    if (!blockState.is(MNDTags.LETIOS_FLAMES) || blockState.hasProperty((Property)BlockStateProperties.LIT) && (!blockState.hasProperty((Property)BlockStateProperties.LIT) || !((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue())) continue;
                    isOnFlame = true;
                    break;
                }
                if (isOnFlame) break;
            }
            if (isOnFlame) break;
        }
        return isOnFlame;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int i = 25 >> amplifier;
        if (i > 0) {
            return duration % i == 0;
        }
        return true;
    }
}

