/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ItemAbilities;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.CommonTags;

public class TrophyBlock
extends Block
implements SimpleWaterloggedBlock {
    public static IntegerProperty ROTTING = IntegerProperty.create((String)"rotting", (int)0, (int)2);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape EAST_AABB;
    protected static final VoxelShape WEST_AABB;
    protected static final VoxelShape SOUTH_AABB;
    protected static final VoxelShape NORTH_AABB;

    public TrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)ROTTING, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext hit) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            default -> EAST_AABB;
        };
    }

    public int getMaxRottingStage() {
        return 2;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        int maxRotting;
        if (worldIn.isClientSide || state.getBlock() != MNDBlocks.HOGLIN_TROPHY.get()) {
            return;
        }
        if (worldIn.getBiome(pos).is(BiomeTags.IS_NETHER) || worldIn.dimensionType().ultraWarm()) {
            return;
        }
        int currentRotting = (Integer)state.getValue((Property)ROTTING);
        if (currentRotting >= (maxRotting = this.getMaxRottingStage())) {
            return;
        }
        int nextRotting = Math.min(currentRotting + 1, maxRotting);
        worldIn.setBlock(pos, (BlockState)state.setValue((Property)ROTTING, (Comparable)Integer.valueOf(nextRotting)), 3);
        if (nextRotting == maxRotting) {
            this.convertToZoglin(worldIn, pos, random);
        } else if (nextRotting == maxRotting - 1) {
            worldIn.playSound(null, pos, SoundEvents.HOGLIN_HURT, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void convertToZoglin(ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockState currentState = worldIn.getBlockState(pos);
        worldIn.playSound(null, pos, SoundEvents.HOGLIN_CONVERTED_TO_ZOMBIFIED, SoundSource.BLOCKS, 1.0f, 1.0f);
        Direction facing = (Direction)currentState.getValue((Property)FACING);
        worldIn.setBlock(pos, (BlockState)MNDBlocks.ZOGLIN_TROPHY.get().defaultBlockState().setValue((Property)FACING, (Comparable)facing), 3);
        int color = 5578058;
        int alpha = 255;
        int argbColor = FastColor.ARGB32.color((int)alpha, (int)color);
        ColorParticleOption particleData = ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)argbColor);
        for (int i = 0; i < 10; ++i) {
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() + random.nextDouble();
            double d2 = (double)pos.getZ() + random.nextDouble();
            worldIn.sendParticles((ParticleOptions)particleData, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Block block = state.getBlock();
        ItemStack heldItem = player.getItemInHand(hand);
        SimpleParticleType secondParticle = null;
        SoundEvent secondSoundEvent = null;
        boolean useSecondEffects = false;
        if (block == MNDBlocks.HOGLIN_TROPHY.get() && heldItem.is(MNDTags.HOGLIN_WAXED)) {
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.WAXED_HOGLIN_TROPHY.get(), SoundEvents.HONEYCOMB_WAX_ON, (ParticleOptions)ParticleTypes.WAX_ON, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            return ItemInteractionResult.SUCCESS;
        }
        if (block == MNDBlocks.WAXED_HOGLIN_TROPHY.get() && heldItem.canPerformAction(ItemAbilities.AXE_WAX_OFF)) {
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.HOGLIN_TROPHY.get(), SoundEvents.HONEYCOMB_WAX_ON, (ParticleOptions)ParticleTypes.WAX_OFF, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            return ItemInteractionResult.SUCCESS;
        }
        if (block == MNDBlocks.ZOGLIN_TROPHY.get() && heldItem.is(MNDTags.HOGLIN_CURE)) {
            secondParticle = ParticleTypes.ENCHANT;
            secondSoundEvent = SoundEvents.ENCHANTMENT_TABLE_USE;
            useSecondEffects = true;
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.HOGLIN_TROPHY.get(), SoundEvents.ZOMBIE_VILLAGER_CURE, (ParticleOptions)ParticleTypes.CLOUD, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            return ItemInteractionResult.SUCCESS;
        }
        if (block == MNDBlocks.HOGLIN_TROPHY.get() && heldItem.is(CommonTags.TOOLS_KNIFE)) {
            secondParticle = ParticleTypes.CLOUD;
            secondSoundEvent = SoundEvents.HOGLIN_HURT;
            useSecondEffects = true;
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.SKOGLIN_TROPHY.get(), (SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), (ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            int j = 1 + level.random.nextInt(2);
            TrophyBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.LEATHER, j));
            return ItemInteractionResult.SUCCESS;
        }
        if (block == MNDBlocks.ZOGLIN_TROPHY.get() && heldItem.is(CommonTags.TOOLS_KNIFE)) {
            secondParticle = ParticleTypes.CLOUD;
            secondSoundEvent = SoundEvents.ZOGLIN_HURT;
            useSecondEffects = true;
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.SKOGLIN_TROPHY.get(), (SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), (ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            int j = 1 + level.random.nextInt(2);
            TrophyBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.ROTTEN_FLESH, j));
            return ItemInteractionResult.SUCCESS;
        }
        if (block == MNDBlocks.SKOGLIN_TROPHY.get() && heldItem.is(MNDItems.HOGLIN_HIDE.get())) {
            secondParticle = ParticleTypes.CLOUD;
            secondSoundEvent = SoundEvents.HOGLIN_AMBIENT;
            useSecondEffects = true;
            this.processTrophyInteraction(level, pos, player, hand, MNDBlocks.HOGLIN_TROPHY.get(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (ParticleOptions)secondParticle, secondSoundEvent, useSecondEffects);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void processTrophyInteraction(Level level, BlockPos pos, Player player, InteractionHand hand, Block trophyBlock, SoundEvent soundEvent, ParticleOptions particle, ParticleOptions secondParticle, SoundEvent secondSoundEvent, boolean useSecondEffects) {
        if (level.isClientSide()) {
            return;
        }
        level.playSound(null, pos, soundEvent, SoundSource.BLOCKS, 0.8f, 0.8f);
        level.setBlockAndUpdate(pos, (BlockState)trophyBlock.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)level.getBlockState(pos).getValue((Property)FACING))));
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 6; ++i) {
                double d0 = (double)pos.getX() + level.getRandom().nextDouble();
                double d1 = (double)pos.getY() + level.getRandom().nextDouble();
                double d2 = (double)pos.getZ() + level.getRandom().nextDouble();
                serverLevel.sendParticles(particle, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                if (!useSecondEffects) continue;
                serverLevel.sendParticles(secondParticle, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                level.playSound(null, pos, secondSoundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private boolean canAttachTo(BlockGetter level, BlockPos pos, Direction facing) {
        return level.getBlockState(pos).isFaceSturdy(level, pos, facing);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return this.canAttachTo((BlockGetter)level, pos.relative(direction.getOpposite()), direction);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = this.defaultBlockState();
        Level levelReader = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        for (Direction direction : context.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(blockState = (BlockState)blockState.setValue((Property)FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)levelReader, blockPos)) continue;
            return (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (!level.dimensionType().ultraWarm() && state.getBlock() == MNDBlocks.HOGLIN_TROPHY.get()) {
            int i = 0;
            while ((double)i < 0.5) {
                double offsetX = random.nextGaussian() * 0.2;
                double offsetY = random.nextGaussian() * 0.2;
                double offsetZ = random.nextGaussian() * 0.2;
                double x = (double)pos.getX() + random.nextDouble();
                double y = (double)pos.getY() + random.nextDouble();
                double z = (double)pos.getZ() + random.nextDouble();
                level.addParticle((ParticleOptions)ParticleTypes.ENCHANTED_HIT, x, y, z, offsetX, offsetY, offsetZ);
                ++i;
            }
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    public BlockState rotate(BlockState state, Rotation facing) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)facing.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror facing) {
        return state.rotate(facing.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, ROTTING});
        super.createBlockStateDefinition(builder);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    static {
        NORTH_AABB = Stream.of(Block.box((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)3.0, (double)16.0), Block.box((double)0.0, (double)3.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)1.0, (double)4.0, (double)13.0, (double)15.0, (double)13.0, (double)15.0), Block.box((double)2.0, (double)8.0, (double)9.0, (double)14.0, (double)12.0, (double)13.0), Block.box((double)2.0, (double)6.0, (double)7.0, (double)14.0, (double)10.0, (double)11.0), Block.box((double)2.0, (double)4.0, (double)5.0, (double)14.0, (double)8.0, (double)9.0), Block.box((double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)6.0, (double)7.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_AABB = Stream.of(Block.box((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)3.0, (double)15.0), Block.box((double)0.0, (double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)1.0, (double)4.0, (double)1.0, (double)3.0, (double)13.0, (double)15.0), Block.box((double)3.0, (double)8.0, (double)2.0, (double)7.0, (double)12.0, (double)14.0), Block.box((double)5.0, (double)6.0, (double)2.0, (double)9.0, (double)10.0, (double)14.0), Block.box((double)7.0, (double)4.0, (double)2.0, (double)11.0, (double)8.0, (double)14.0), Block.box((double)9.0, (double)2.0, (double)2.0, (double)13.0, (double)6.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_AABB = Stream.of(Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)1.0), Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0), Block.box((double)2.0, (double)8.0, (double)3.0, (double)14.0, (double)12.0, (double)7.0), Block.box((double)2.0, (double)6.0, (double)5.0, (double)14.0, (double)10.0, (double)9.0), Block.box((double)2.0, (double)4.0, (double)7.0, (double)14.0, (double)8.0, (double)11.0), Block.box((double)2.0, (double)2.0, (double)9.0, (double)14.0, (double)6.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_AABB = Stream.of(Block.box((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0, (double)15.0), Block.box((double)15.0, (double)3.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)13.0, (double)4.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.box((double)9.0, (double)8.0, (double)2.0, (double)13.0, (double)12.0, (double)14.0), Block.box((double)7.0, (double)6.0, (double)2.0, (double)11.0, (double)10.0, (double)14.0), Block.box((double)5.0, (double)4.0, (double)2.0, (double)9.0, (double)8.0, (double)14.0), Block.box((double)3.0, (double)2.0, (double)2.0, (double)7.0, (double)6.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    }
}

