/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.FeastBlock;

public class GhastaWithCreamBlock
extends FeastBlock {
    protected static final VoxelShape PLATE_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    protected static final VoxelShape ROAST_SHAPE = Shapes.joinUnoptimized((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), (BooleanOp)BooleanOp.OR);

    public GhastaWithCreamBlock(BlockBehaviour.Properties properties, Supplier<Item> servingItem, boolean hasLeftovers) {
        super(properties, servingItem, hasLeftovers);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)SERVINGS) == 0 ? PLATE_SHAPE : ROAST_SHAPE;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        int servings;
        if (!worldIn.isClientSide && (servings = ((Integer)state.getValue((Property)SERVINGS)).intValue()) < 4 && servings >= 2 && random.nextInt(5) == 0) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 2);
            worldIn.playSound(null, pos, SoundEvents.GHAST_AMBIENT, SoundSource.BLOCKS, 0.25f, 0.25f);
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }
}

