/*
 * Decompiled with CFR 0.152.
 */
package com.troller2705.createcolored.datagen;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.troller2705.createcolored.content.block.ColoredFluidPipeBlock;
import com.troller2705.createcolored.content.block.ColoredFluidTankBlock;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.Pointing;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class ColoredBlockStateGen {
    public static <P extends ColoredFluidTankBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> coloredTank(DyeColor color) {
        return (ctx, provider) -> {
            String colorName = color.getName();
            String coloredPath = "block/colored_fluid_tank/" + ctx.getName() + "/";
            String path = "block/fluid_tank/";
            provider.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> ConfiguredModel.builder().modelFile(ColoredBlockStateGen.getModel(ctx, provider, state, color)).build());
        };
    }

    private static <P extends ColoredFluidTankBlock> ModelFile getModel(DataGenContext<Block, P> ctx, RegistrateBlockstateProvider provider, BlockState state, DyeColor color) {
        Boolean top = (Boolean)state.getValue((Property)ColoredFluidTankBlock.TOP);
        Boolean bottom = (Boolean)state.getValue((Property)ColoredFluidTankBlock.BOTTOM);
        FluidTankBlock.Shape shape = (FluidTankBlock.Shape)state.getValue((Property)ColoredFluidTankBlock.SHAPE);
        String colorName = color.getName();
        String shapeName = "middle";
        if (top.booleanValue() && bottom.booleanValue()) {
            shapeName = "single";
        } else if (top.booleanValue()) {
            shapeName = "top";
        } else if (bottom.booleanValue()) {
            shapeName = "bottom";
        }
        String modelName = shapeName + (String)(shape == FluidTankBlock.Shape.PLAIN ? "" : "_" + shape.getSerializedName());
        return provider.models().getExistingFile(provider.modLoc("block/" + ctx.getName() + "/" + colorName + "_fluid_tank/block_" + modelName));
    }

    public static <P extends ColoredFluidPipeBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> coloredPipe(DyeColor color) {
        return (c, p) -> {
            String outputModel;
            String sourceModel;
            String colorName = color.getName();
            String coloredPath = "block/colored_fluid_pipe/" + c.getName();
            String path = "block/fluid_pipe";
            String LU = "lu";
            String RU = "ru";
            String LD = "ld";
            String RD = "rd";
            String LR = "lr";
            String UD = "ud";
            String U = "u";
            String D = "d";
            String L = "l";
            String R = "r";
            ImmutableList orientations = ImmutableList.of((Object)LU, (Object)RU, (Object)LD, (Object)RD, (Object)LR, (Object)UD, (Object)U, (Object)D, (Object)L, (Object)R);
            HashMap<Pair<String, Direction.Axis>, ModelFile> coreModels = new HashMap<Pair<String, Direction.Axis>, ModelFile>();
            for (Direction.Axis axis : Iterate.axes) {
                for (String orientation : orientations) {
                    Pair key = Pair.of((Object)orientation, (Object)axis);
                    sourceModel = path + "/" + orientation + "_" + axis.getName();
                    String coloredModel = coloredPath + "/" + orientation + "_" + axis.getName();
                    coreModels.put((Pair<String, Direction.Axis>)key, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(coloredModel, Create.asResource((String)sourceModel))).texture("0", p.modLoc("block/pipes_connected/" + colorName))).texture("particle", p.modLoc("block/pipes_connected/" + colorName)));
                }
            }
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
            for (Direction.Axis axis : Iterate.axes) {
                ColoredBlockStateGen.putPart(coreModels, builder, axis, LU, true, false, true, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, RU, true, false, false, true);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, LD, false, true, true, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, RD, false, true, false, true);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, UD, true, true, false, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, U, true, false, false, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, D, false, true, false, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, LR, false, false, true, true);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, L, false, false, true, false);
                ColoredBlockStateGen.putPart(coreModels, builder, axis, R, false, false, false, true);
            }
            String casingSource = path + "/casing";
            String casingOutput = coloredPath + "/casing";
            ((BlockModelBuilder)p.models().withExistingParent(casingOutput, Create.asResource((String)casingSource))).texture("0", "block/pipes/" + colorName);
            for (Direction d : Iterate.directions) {
                sourceModel = path + "/connection/" + d.getName();
                outputModel = coloredPath + "/connection/" + d.getName();
                ((BlockModelBuilder)p.models().withExistingParent(outputModel, Create.asResource((String)sourceModel))).texture("0", "block/pipes/" + colorName);
            }
            for (Direction d : Iterate.directions) {
                sourceModel = path + "/drain/" + d.getName();
                outputModel = coloredPath + "/drain/" + d.getName();
                ((BlockModelBuilder)p.models().withExistingParent(outputModel, Create.asResource((String)sourceModel))).texture("0", "block/pipes/" + colorName);
            }
            for (Direction d : Iterate.directions) {
                sourceModel = path + "/rim/" + d.getName();
                outputModel = coloredPath + "/rim/" + d.getName();
                ((BlockModelBuilder)p.models().withExistingParent(outputModel, Create.asResource((String)sourceModel))).texture("0", "block/pipes/" + colorName);
            }
            for (Direction d : Iterate.directions) {
                sourceModel = path + "/rim_connector/" + d.getName();
                outputModel = coloredPath + "/rim_connector/" + d.getName();
                ((BlockModelBuilder)p.models().withExistingParent(outputModel, Create.asResource((String)sourceModel))).texture("0", "block/pipes/" + colorName);
            }
        };
    }

    private static void putPart(Map<Pair<String, Direction.Axis>, ModelFile> coreModels, MultiPartBlockStateBuilder builder, Direction.Axis axis, String s, boolean up, boolean down, boolean left, boolean right) {
        Direction positiveAxis = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        Map propertyMap = FluidPipeBlock.PROPERTY_BY_DIRECTION;
        Direction upD = Pointing.UP.getCombinedDirection(positiveAxis);
        Direction leftD = Pointing.LEFT.getCombinedDirection(positiveAxis);
        Direction rightD = Pointing.RIGHT.getCombinedDirection(positiveAxis);
        Direction downD = Pointing.DOWN.getCombinedDirection(positiveAxis);
        if (axis == Direction.Axis.Y || axis == Direction.Axis.X) {
            leftD = leftD.getOpposite();
            rightD = rightD.getOpposite();
        }
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(coreModels.get(Pair.of((Object)s, (Object)axis))).addModel()).condition((Property)propertyMap.get(upD), (Comparable[])new Boolean[]{up}).condition((Property)propertyMap.get(leftD), (Comparable[])new Boolean[]{left}).condition((Property)propertyMap.get(rightD), (Comparable[])new Boolean[]{right}).condition((Property)propertyMap.get(downD), (Comparable[])new Boolean[]{down}).end();
    }

    public static <P extends EncasedPipeBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> encasedPipe(DyeColor color) {
        return (c, p) -> {
            String colorName = color.getName();
            ModelBuilder open = ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/encased_fluid_pipe/" + colorName + "_encased_fluid_pipe/block_open", Create.asResource((String)"block/encased_fluid_pipe/block_open"))).texture("0", "block/encased_pipe/" + colorName)).texture("particle", "block/encased_pipe/" + colorName);
            ModelFile.ExistingModelFile flat = p.models().getExistingFile(Create.asResource((String)"block/encased_fluid_pipe/block_flat"));
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
            for (boolean flatPass : Iterate.trueAndFalse) {
                for (Direction d : Iterate.directions) {
                    int verticalAngle = d == Direction.UP ? 90 : (d == Direction.DOWN ? -90 : 0);
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)(flatPass ? flat : open)).rotationX(verticalAngle).rotationY((int)(d.toYRot() + (float)(d.getAxis().isVertical() ? 90 : 0)) % 360).addModel()).condition((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(d), (Comparable[])new Boolean[]{!flatPass}).end();
                }
            }
        };
    }
}

