/*
 * Decompiled with CFR 0.152.
 */
package com.troller2705.createcolored.content.models;

import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.troller2705.createcolored.CreateColored;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class ColoredPartials {
    public static final Map<DyeColor, PartialModel> COLORED_FLUID_PIPE_CASINGS = new EnumMap<DyeColor, PartialModel>(DyeColor.class);
    public static final Map<FluidTransportBehaviour.AttachmentTypes.ComponentPartials, Map<DyeColor, Map<String, PartialModel>>> COLORED_PIPE_ATTACHMENTS = new EnumMap<FluidTransportBehaviour.AttachmentTypes.ComponentPartials, Map<DyeColor, Map<String, PartialModel>>>(FluidTransportBehaviour.AttachmentTypes.ComponentPartials.class);
    public static final Map<DyeColor, PartialModel> COLORED_BOILER_GAUGE = new EnumMap<DyeColor, PartialModel>(DyeColor.class);
    public static final Map<DyeColor, PartialModel> COLORED_BOILER_GAUGE_DIAL = new EnumMap<DyeColor, PartialModel>(DyeColor.class);

    private static PartialModel block(String path) {
        return PartialModel.of((ResourceLocation)CreateColored.asResource("block/" + path));
    }

    public static void initialize() {
    }

    static {
        for (DyeColor dyeColor : DyeColor.values()) {
            COLORED_FLUID_PIPE_CASINGS.put(dyeColor, ColoredPartials.block("colored_fluid_pipe/" + dyeColor.getName() + "_fluid_pipe/casing"));
            COLORED_BOILER_GAUGE.put(dyeColor, ColoredPartials.block("colored_gauges/" + dyeColor.getName() + "_gauge"));
            COLORED_BOILER_GAUGE_DIAL.put(dyeColor, ColoredPartials.block("colored_gauges/" + dyeColor.getName() + "_gauge_dial"));
        }
        for (DyeColor dyeColor : FluidTransportBehaviour.AttachmentTypes.ComponentPartials.values()) {
            EnumMap colorMap = new EnumMap(DyeColor.class);
            for (DyeColor color : DyeColor.values()) {
                HashMap<String, PartialModel> map = new HashMap<String, PartialModel>();
                for (Direction d : Iterate.directions) {
                    String asId = Lang.asId((String)dyeColor.name());
                    map.put(d.getName(), ColoredPartials.block("colored_fluid_pipe/" + color.getName() + "_fluid_pipe/" + asId + "/" + Lang.asId((String)d.getName())));
                }
                colorMap.put(color, map);
            }
            COLORED_PIPE_ATTACHMENTS.put((FluidTransportBehaviour.AttachmentTypes.ComponentPartials)dyeColor, colorMap);
        }
    }
}

