/*
 * Decompiled with CFR 0.152.
 */
package com.troller2705.createcolored.content.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankRenderer;
import com.troller2705.createcolored.content.block.IColoredBlock;
import com.troller2705.createcolored.content.models.ColoredPartials;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ColoredFluidTankRenderer
extends FluidTankRenderer {
    public ColoredFluidTankRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderAsBoiler(FluidTankBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.getBlockState();
        VertexConsumer vb = buffer.getBuffer(RenderType.cutout());
        ms.pushPose();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        msr.translate((double)((float)be.getWidth() / 2.0f), 0.5, (double)((float)be.getWidth() / 2.0f));
        float dialPivotY = 0.375f;
        float dialPivotZ = 0.5f;
        float progress = be.boiler.gauge.getValue(partialTicks);
        SuperByteBuffer boilerGauge = CachedBuffers.partial((PartialModel)AllPartialModels.BOILER_GAUGE, (BlockState)blockState);
        SuperByteBuffer boilerGaugeDial = CachedBuffers.partial((PartialModel)AllPartialModels.BOILER_GAUGE_DIAL, (BlockState)blockState);
        Block block = blockState.getBlock();
        if (block instanceof IColoredBlock) {
            IColoredBlock coloredBlock = (IColoredBlock)block;
            DyeColor color = coloredBlock.getColor();
            boilerGauge = CachedBuffers.partial((PartialModel)ColoredPartials.COLORED_BOILER_GAUGE.get(color), (BlockState)blockState);
            boilerGaugeDial = CachedBuffers.partial((PartialModel)ColoredPartials.COLORED_BOILER_GAUGE_DIAL.get(color), (BlockState)blockState);
        }
        for (Direction d : Iterate.horizontalDirections) {
            if (be.boiler.occludedDirections[d.get2DDataValue()]) continue;
            ms.pushPose();
            float yRot = -d.toYRot() - 90.0f;
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)boilerGauge.rotateYDegrees(yRot)).uncenter()).translate((float)be.getWidth() / 2.0f - 0.375f, 0.0f, 0.0f)).light(light).renderInto(ms, vb);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)boilerGaugeDial.rotateYDegrees(yRot)).uncenter()).translate((float)be.getWidth() / 2.0f - 0.375f, 0.0f, 0.0f)).translate(0.0f, dialPivotY, dialPivotZ)).rotateXDegrees(-145.0f * progress + 90.0f)).translate(0.0f, -dialPivotY, -dialPivotZ)).light(light).renderInto(ms, vb);
            ms.popPose();
        }
        ms.popPose();
    }
}

