/*
 * Decompiled with CFR 0.152.
 */
package com.troller2705.createcolored.content.blockEntities;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.troller2705.createcolored.ColoredConnectivityHandler;
import com.troller2705.createcolored.IConnectableBlockEntity;
import com.troller2705.createcolored.content.blockEntities.ColoredBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class ColoredFluidTankBlockEntity
extends FluidTankBlockEntity
implements IHaveGoggleInformation,
IConnectableBlockEntity {
    public static BlockEntityType<ColoredFluidTankBlockEntity> TYPE;

    public ColoredFluidTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ColoredConnectivityHandler.formMulti(this);
    }

    @Override
    public boolean canConnectWith(BlockPos otherPos, Level level) {
        BlockEntity be = level.getBlockEntity(otherPos);
        if (be instanceof ColoredFluidTankBlockEntity) {
            return be.getBlockState().getBlock().equals(this.getBlockState().getBlock());
        }
        return false;
    }

    @Override
    public Level getWorld() {
        return this.level;
    }

    @Override
    public BlockPos getPos() {
        return this.getBlockPos();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ColoredBlockEntities.COLORED_FLUID_TANK_ENTITY.get(), (be, context) -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            return be.fluidCapability;
        });
    }

    void refreshCapability() {
        this.fluidCapability = this.handlerForCapability();
        this.invalidateCapabilities();
    }

    private IFluidHandler handlerForCapability() {
        if (this.isController()) {
            return this.boiler.isActive() ? this.boiler.createHandler() : this.tankInventory;
        }
        return this.getControllerBE() != null ? ((ColoredFluidTankBlockEntity)this.getControllerBE()).handlerForCapability() : new FluidTank(0);
    }
}

