/*
 * Decompiled with CFR 0.152.
 */
package com.troller2705.createcolored.content.blockEntities;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.troller2705.createcolored.content.block.ColoredFluidPipeBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ColoredFluidPipeBlockEntity
extends FluidPipeBlockEntity {
    public ColoredFluidPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new StandardPipeFluidTransportBehaviour((SmartBlockEntity)this));
        behaviours.add((BlockEntityBehaviour)new BracketedBlockEntityBehaviour((SmartBlockEntity)this, this::canHaveBracket));
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
    }

    private boolean canHaveBracket(BlockState state) {
        return !(state.getBlock() instanceof EncasedPipeBlock);
    }

    static class StandardPipeFluidTransportBehaviour
    extends FluidTransportBehaviour {
        public StandardPipeFluidTransportBehaviour(SmartBlockEntity be) {
            super(be);
        }

        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return (ColoredFluidPipeBlock.isColoredPipe(state) || state.getBlock() instanceof EncasedPipeBlock) && (Boolean)state.getValue((Property)ColoredFluidPipeBlock.PROPERTY_BY_DIRECTION.get(direction)) != false;
        }

        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction direction) {
            FluidTransportBehaviour pipeBehaviour;
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            BlockPos offsetPos = pos.relative(direction);
            BlockState otherState = world.getBlockState(offsetPos);
            if (state.getBlock() instanceof EncasedPipeBlock && attachment != FluidTransportBehaviour.AttachmentTypes.DRAIN) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM && !ColoredFluidPipeBlock.isColoredPipe(otherState) && !AllBlocks.MECHANICAL_PUMP.has(otherState) && !AllBlocks.ENCASED_FLUID_PIPE.has(otherState) && (pipeBehaviour = (FluidTransportBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)offsetPos, (BehaviourType)FluidTransportBehaviour.TYPE)) != null && pipeBehaviour.canHaveFlowToward(otherState, direction.getOpposite())) {
                return FluidTransportBehaviour.AttachmentTypes.CONNECTION;
            }
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM && !ColoredFluidPipeBlock.shouldDrawRim(world, pos, state, direction)) {
                return FluidTransportBehaviour.AttachmentTypes.CONNECTION;
            }
            if (attachment == FluidTransportBehaviour.AttachmentTypes.NONE && ((Boolean)state.getValue((Property)ColoredFluidPipeBlock.PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) {
                return FluidTransportBehaviour.AttachmentTypes.CONNECTION;
            }
            return attachment;
        }
    }
}

