/*
 * Decompiled with CFR 0.152.
 */
package com.troller2705.createcolored.content.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.StraightPipeBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.troller2705.createcolored.content.block.ColoredBlocks;
import com.troller2705.createcolored.content.block.ColoredEncasedPipeBlock;
import com.troller2705.createcolored.content.block.ColoredFluidPipeBlock;
import com.troller2705.createcolored.content.block.IColoredBlock;
import com.troller2705.createcolored.content.blockEntities.ColoredBlockEntities;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ColoredGlassFluidPipeBlock
extends GlassFluidPipeBlock
implements IColoredBlock {
    protected final DyeColor color;

    public ColoredGlassFluidPipeBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    public boolean tryRemoveBracket(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Optional bracket = this.removeBracket((BlockGetter)world, pos, false);
        BlockState blockState = world.getBlockState(pos);
        if (bracket.isPresent()) {
            Player player = context.getPlayer();
            if (player != null && !world.isClientSide() && !player.isCreative()) {
                ItemStack stackToGive = (ItemStack)bracket.get();
                if (!player.getInventory().add(stackToGive)) {
                    player.drop(stackToGive, false);
                }
            }
            if (!world.isClientSide() && ColoredBlocks.DYED_PIPES.get(this.color).has(blockState)) {
                Direction.Axis preferred = FluidPropagator.getStraightPipeAxis((BlockState)blockState);
                Direction preferredDirection = preferred == null ? Direction.UP : Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)preferred);
                BlockState updated = ((ColoredFluidPipeBlock)ColoredBlocks.DYED_PIPES.get(this.color).get()).updateBlockState(blockState, preferredDirection, null, (BlockAndTintGetter)world, pos);
                if (updated != blockState) {
                    world.setBlockAndUpdate(pos, updated);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(hand);
        DyeColor color = ColoredGlassFluidPipeBlock.getColorFromStack(heldItem);
        if (color != null) {
            if (!world.isClientSide()) {
                world.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.1f - world.random.nextFloat() * 0.2f);
            }
            this.applyDye(state, world, pos, color);
            return InteractionResult.SUCCESS;
        }
        if (!AllBlocks.COPPER_CASING.isIn(player.getItemInHand(hand))) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockState newState = ((ColoredEncasedPipeBlock)ColoredBlocks.DYED_ENCASED_PIPES.get(this.color).get()).defaultBlockState();
        for (Direction d : Iterate.directionsInAxis((Direction.Axis)this.getAxis(state))) {
            newState = (BlockState)newState.setValue((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(d), (Comparable)Boolean.valueOf(true));
        }
        FluidTransportBehaviour.cacheFlows((LevelAccessor)world, (BlockPos)pos);
        world.setBlock(pos, newState, 3);
        FluidTransportBehaviour.loadFlows((LevelAccessor)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    private static DyeColor getColorFromStack(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            return dyeItem.getDyeColor();
        }
        return null;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (this.tryRemoveBracket(context)) {
            return InteractionResult.SUCCESS;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FluidTransportBehaviour.cacheFlows((LevelAccessor)world, (BlockPos)pos);
        BlockState newState = (BlockState)this.toColoredPipe((LevelAccessor)world, pos, state).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)));
        world.setBlock(pos, newState, 3);
        FluidTransportBehaviour.loadFlows((LevelAccessor)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public BlockState toColoredPipe(LevelAccessor world, BlockPos pos, BlockState state) {
        Direction side = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.getValue((Property)AXIS)));
        Map facingToPropertyMap = FluidPipeBlock.PROPERTY_BY_DIRECTION;
        return ((ColoredFluidPipeBlock)ColoredBlocks.DYED_PIPES.get(this.color).get()).updateBlockState((BlockState)((BlockState)ColoredBlocks.DYED_PIPES.get(this.color).getDefaultState().setValue((Property)facingToPropertyMap.get(side), (Comparable)Boolean.valueOf(true))).setValue((Property)facingToPropertyMap.get(side.getOpposite()), (Comparable)Boolean.valueOf(true)), side, null, (BlockAndTintGetter)world, pos);
    }

    public void applyDye(BlockState state, Level world, BlockPos pos, @Nullable DyeColor color) {
        BlockState newState = (color == null ? ColoredBlocks.DYED_GLASS_PIPES.get(DyeColor.WHITE) : ColoredBlocks.DYED_GLASS_PIPES.get(color)).getDefaultState();
        if (state != newState) {
            world.setBlock(pos, newState, 3);
        }
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        return ItemRequirement.of((BlockState)ColoredBlocks.DYED_PIPES.get(this.color).getDefaultState(), (BlockEntity)be);
    }

    public BlockEntityType<? extends StraightPipeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ColoredBlockEntities.COLORED_GLASS_FLUID_PIPE_ENTITY.get();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ColoredBlocks.DYED_PIPES.get(this.color).asStack();
    }
}

