/*
 * Decompiled with CFR 0.152.
 */
package com.troller2705.createcolored.content.block;

import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.troller2705.createcolored.ColoredConnectivityHandler;
import com.troller2705.createcolored.content.block.IColoredBlock;
import com.troller2705.createcolored.content.blockEntities.ColoredBlockEntities;
import com.troller2705.createcolored.content.blockEntities.ColoredFluidTankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.phys.BlockHitResult;

public class ColoredFluidTankBlock
extends FluidTankBlock
implements IColoredBlock {
    private final DyeColor color;

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        return InteractionResult.PASS;
    }

    public static ColoredFluidTankBlock regular(BlockBehaviour.Properties properties, DyeColor color) {
        return new ColoredFluidTankBlock(properties, color);
    }

    public ColoredFluidTankBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties, false);
        this.color = color;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
    }

    public static boolean isColoredTank(BlockState state) {
        return state.getBlock() instanceof ColoredFluidTankBlock;
    }

    public BlockEntityType<? extends FluidTankBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ColoredBlockEntities.COLORED_FLUID_TANK_ENTITY.get();
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (!(be instanceof ColoredFluidTankBlockEntity)) {
                return;
            }
            ColoredFluidTankBlockEntity tankBE = (ColoredFluidTankBlockEntity)be;
            world.removeBlockEntity(pos);
            ColoredConnectivityHandler.splitMulti(tankBE);
        }
    }
}

