/*
 * Decompiled with CFR 0.152.
 */
package com.troller2705.createcolored.content.block;

import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockRotation;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.troller2705.createcolored.content.block.ColoredBlocks;
import com.troller2705.createcolored.content.block.ColoredEncasedPipeBlock;
import com.troller2705.createcolored.content.block.ColoredFluidTankBlock;
import com.troller2705.createcolored.content.block.ColoredGlassFluidPipeBlock;
import com.troller2705.createcolored.content.block.IColoredBlock;
import com.troller2705.createcolored.content.blockEntities.ColoredBlockEntities;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ColoredFluidPipeBlock
extends FluidPipeBlock
implements IColoredBlock {
    protected final DyeColor color;

    public ColoredFluidPipeBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    public static BlockState updateConnections(BlockAndTintGetter world, BlockPos pos, BlockState state, @Nullable Direction ignored) {
        BlockState newState = state;
        for (Direction d : Iterate.directions) {
            if (d == ignored) continue;
            boolean shouldConnect = ColoredFluidPipeBlock.canConnectToColored(world, pos, state, d);
            newState = (BlockState)newState.setValue((Property)FluidPipeBlockRotation.FACING_TO_PROPERTY_MAP.get(d), (Comparable)Boolean.valueOf(shouldConnect));
        }
        return newState;
    }

    public static boolean canConnectToColored(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction direction) {
        FluidTransportBehaviour transport;
        Object current;
        BlockPos neighbourPos = pos.offset(direction.getNormal());
        BlockState neighbourState = world.getBlockState(neighbourPos);
        if (ColoredFluidTankBlock.isColoredTank(neighbourState)) {
            ColoredFluidPipeBlock block = (ColoredFluidPipeBlock)state.getBlock();
            ColoredFluidTankBlock other = (ColoredFluidTankBlock)neighbourState.getBlock();
            if (block.color != other.getColor()) {
                return false;
            }
        }
        if (FluidPropagator.hasFluidCapability((BlockGetter)world, (BlockPos)neighbourPos, (Direction)direction.getOpposite())) {
            return true;
        }
        if (VanillaFluidTargets.canProvideFluidWithoutCapability((BlockState)neighbourState)) {
            return true;
        }
        BracketedBlockEntityBehaviour bracket = (BracketedBlockEntityBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)neighbourPos, (BehaviourType)BracketedBlockEntityBehaviour.TYPE);
        if (ColoredFluidPipeBlock.isPipe((BlockState)neighbourState)) {
            if (ColoredFluidPipeBlock.isColoredPipe(neighbourState) && !ColoredFluidPipeBlock.sameColor(state, neighbourState)) {
                return false;
            }
            return bracket == null || !bracket.isBracketPresent() || FluidPropagator.getStraightPipeAxis((BlockState)neighbourState) == direction.getAxis();
        }
        Block block = neighbourState.getBlock();
        if (block instanceof ColoredGlassFluidPipeBlock) {
            ColoredGlassFluidPipeBlock glassPipe = (ColoredGlassFluidPipeBlock)block;
            current = (ColoredFluidPipeBlock)state.getBlock();
            if (!((ColoredFluidPipeBlock)current).getColor().equals((Object)glassPipe.getColor())) {
                return false;
            }
        }
        if ((current = neighbourState.getBlock()) instanceof ColoredEncasedPipeBlock) {
            ColoredEncasedPipeBlock encasedPipeBlock = (ColoredEncasedPipeBlock)current;
            current = (ColoredFluidPipeBlock)state.getBlock();
            if (!((ColoredFluidPipeBlock)current).getColor().equals((Object)encasedPipeBlock.getColor())) {
                return false;
            }
        }
        if ((transport = (FluidTransportBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)neighbourPos, (BehaviourType)FluidTransportBehaviour.TYPE)) == null) {
            return false;
        }
        return transport.canHaveFlowToward(neighbourState, direction.getOpposite());
    }

    public static BlockState addOppositeSide(BlockState state, Direction dir) {
        return (BlockState)((BlockState)state.setValue((Property)FluidPipeBlockRotation.FACING_TO_PROPERTY_MAP.get(dir), (Comparable)Boolean.valueOf(true))).setValue((Property)FluidPipeBlockRotation.FACING_TO_PROPERTY_MAP.get(dir.getOpposite()), (Comparable)Boolean.valueOf(true));
    }

    public static boolean sameColor(BlockState state, BlockState neighbour) {
        return state.getBlock().equals(neighbour.getBlock());
    }

    public static boolean isColoredPipe(BlockState state) {
        return state.getBlock() instanceof ColoredFluidPipeBlock;
    }

    public static boolean isColoredGlassPipe(BlockState state) {
        return state.getBlock() instanceof ColoredGlassFluidPipeBlock;
    }

    public static boolean shouldDrawCasing(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        if (!ColoredFluidPipeBlock.isColoredPipe(state)) {
            return false;
        }
        for (Direction.Axis axis : Iterate.axes) {
            int connections = 0;
            for (Direction direction : Iterate.directions) {
                if (direction.getAxis() == axis || !ColoredFluidPipeBlock.isOpenAt((BlockState)state, (Direction)direction)) continue;
                ++connections;
            }
            if (connections <= 2) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldDrawRim(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction direction) {
        BlockPos offsetPos = pos.offset(direction.getNormal());
        BlockState facingState = world.getBlockState(offsetPos);
        if (facingState.getBlock() instanceof EncasedPipeBlock) {
            return true;
        }
        if (!ColoredFluidPipeBlock.canConnectToColored(world, pos, state, direction)) {
            return true;
        }
        return !ColoredFluidPipeBlock.isColoredPipe(facingState);
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (this.tryRemoveBracket(context)) {
            return InteractionResult.SUCCESS;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        Direction.Axis axis = this.getAxis(state);
        if (axis == null) {
            Vec3 clickLocation = context.getClickLocation();
            double closest = 3.4028234663852886E38;
            Direction argClosest = Direction.UP;
            for (Direction direction : Iterate.directions) {
                Vec3 centerOf;
                double distance;
                if (clickedFace.getAxis() == direction.getAxis() || !((distance = (centerOf = Vec3.atCenterOf((Vec3i)pos.relative(direction))).distanceToSqr(clickLocation)) < closest)) continue;
                closest = distance;
                argClosest = direction;
            }
            axis = argClosest.getAxis();
        }
        if (clickedFace.getAxis() == axis) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide()) {
            this.withBlockEntityDo((BlockGetter)world, pos, fpte -> ((FluidTransportBehaviour)fpte.getBehaviour((BehaviourType)FluidTransportBehaviour.TYPE)).interfaces.values().stream().filter(pc -> pc != null && pc.hasFlow()).findAny().ifPresent($ -> AllAdvancements.GLASS_PIPE.awardTo(context.getPlayer())));
            FluidTransportBehaviour.cacheFlows((LevelAccessor)world, (BlockPos)pos);
            world.setBlockAndUpdate(pos, (BlockState)((BlockState)ColoredBlocks.DYED_GLASS_PIPES.get(this.color).getDefaultState().setValue((Property)GlassFluidPipeBlock.AXIS, (Comparable)axis)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED))));
            FluidTransportBehaviour.loadFlows((LevelAccessor)world, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    private Direction.Axis getAxis(BlockState state) {
        return FluidPropagator.getStraightPipeAxis((BlockState)state);
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.getItemInHand(hand);
        DyeColor color = ColoredFluidPipeBlock.getColorFromStack(heldItem);
        if (color != null) {
            if (!world.isClientSide()) {
                world.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.1f - world.random.nextFloat() * 0.2f);
            }
            this.applyDye(state, world, pos, color);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private static DyeColor getColorFromStack(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            return dyeItem.getDyeColor();
        }
        return null;
    }

    public void applyDye(BlockState state, Level world, BlockPos pos, @Nullable DyeColor color) {
        BlockState newState = (color == null ? ColoredBlocks.DYED_PIPES.get(DyeColor.WHITE) : ColoredBlocks.DYED_PIPES.get(color)).getDefaultState();
        if (state != (newState = this.updateBlockState(newState, Direction.UP, null, (BlockAndTintGetter)world, pos))) {
            world.setBlockAndUpdate(pos, newState);
        }
    }

    public BlockState updateBlockState(BlockState state, Direction preferredDirection, @Nullable Direction ignore, BlockAndTintGetter world, BlockPos pos) {
        BracketedBlockEntityBehaviour bracket = (BracketedBlockEntityBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, (BehaviourType)BracketedBlockEntityBehaviour.TYPE);
        if (bracket != null && bracket.isBracketPresent()) {
            return state;
        }
        BlockState prevState = state;
        int prevStateSides = (int)Arrays.stream(Iterate.directions).map(FluidPipeBlockRotation.FACING_TO_PROPERTY_MAP::get).filter(arg_0 -> ((BlockState)prevState).getValue(arg_0)).count();
        state = ColoredFluidPipeBlock.updateConnections(world, pos, state, ignore);
        Direction connectedDirection = null;
        for (Direction d : Iterate.directions) {
            if (!ColoredFluidPipeBlock.isOpenAt((BlockState)state, (Direction)d)) continue;
            if (connectedDirection != null) {
                return state;
            }
            connectedDirection = d;
        }
        if (connectedDirection != null) {
            return (BlockState)state.setValue((Property)FluidPipeBlockRotation.FACING_TO_PROPERTY_MAP.get(connectedDirection.getOpposite()), (Comparable)Boolean.valueOf(true));
        }
        if (prevStateSides == 2) {
            Direction foundDir = null;
            for (Direction d : Iterate.directions) {
                if (!((Boolean)prevState.getValue((Property)FluidPipeBlockRotation.FACING_TO_PROPERTY_MAP.get(d))).booleanValue()) continue;
                foundDir = d;
                break;
            }
            if (foundDir != null) {
                return ColoredFluidPipeBlock.addOppositeSide(state, foundDir);
            }
        }
        return ColoredFluidPipeBlock.addOppositeSide(state, preferredDirection);
    }

    public BlockEntityType<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ColoredBlockEntities.COLORED_FLUID_PIPE_ENTITY.get();
    }
}

