/*
 * Decompiled with CFR 0.152.
 */
package com.troller2705.createcolored.content.block;

import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import com.troller2705.createcolored.content.block.ColoredBlocks;
import com.troller2705.createcolored.content.block.ColoredFluidPipeBlock;
import com.troller2705.createcolored.content.block.IColoredBlock;
import com.troller2705.createcolored.content.blockEntities.ColoredBlockEntities;
import java.util.function.Supplier;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ColoredEncasedPipeBlock
extends EncasedPipeBlock
implements IColoredBlock {
    private final DyeColor color;

    public ColoredEncasedPipeBlock(BlockBehaviour.Properties properties, Supplier<Block> casing, DyeColor color) {
        super(properties, casing);
        this.color = color;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult result, BlockGetter level, BlockPos pos, Player player) {
        return ColoredBlocks.DYED_PIPES.get(this.color).asStack();
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        world.levelEvent(2001, pos, Block.getId((BlockState)state));
        BlockState equivalentPipe = ColoredEncasedPipeBlock.transferSixWayProperties((BlockState)state, (BlockState)((ColoredFluidPipeBlock)ColoredBlocks.DYED_PIPES.get(this.color).get()).defaultBlockState());
        Direction firstFound = Direction.UP;
        for (Direction d : Iterate.directions) {
            if (!((Boolean)state.getValue((Property)FACING_TO_PROPERTY_MAP.get(d))).booleanValue()) continue;
            firstFound = d;
            break;
        }
        FluidTransportBehaviour.cacheFlows((LevelAccessor)world, (BlockPos)pos);
        world.setBlock(pos, ((ColoredFluidPipeBlock)ColoredBlocks.DYED_PIPES.get(this.color).get()).updateBlockState(equivalentPipe, firstFound, null, (BlockAndTintGetter)world, pos), 3);
        FluidTransportBehaviour.loadFlows((LevelAccessor)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public BlockEntityType<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ColoredBlockEntities.COLORED_ENCASED_FLUID_PIPE.get();
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        return InteractionResult.PASS;
    }
}

