/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.packet.forge;

import com.cak.pattern_schematics.registry.PatternSchematicsDataComponents;
import com.cak.pattern_schematics.registry.PatternSchematicsRegistry;
import com.cak.pattern_schematics.registry.forge.PatternSchematicPackets;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.schematics.SchematicInstances;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecs;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;

public record PatternSchematicSyncPacket(int slot, boolean deployed, BlockPos anchor, Rotation rotation, Mirror mirror, Vec3i cloneScaleMin, Vec3i cloneScaleMax, Vec3i cloneOffset) implements ServerboundPacketPayload
{
    public static final StreamCodec<ByteBuf, PatternSchematicSyncPacket> STREAM_CODEC = new StreamCodec<ByteBuf, PatternSchematicSyncPacket>(){

        public void encode(ByteBuf out, PatternSchematicSyncPacket src) {
            out.writeInt(src.slot);
            out.writeBoolean(src.deployed);
            BlockPos.STREAM_CODEC.encode((Object)out, (Object)src.anchor);
            CatnipStreamCodecs.ROTATION.encode((Object)out, (Object)src.rotation);
            CatnipStreamCodecs.MIRROR.encode((Object)out, (Object)src.mirror);
            CatnipStreamCodecs.VEC3I.encode((Object)out, (Object)src.cloneScaleMin);
            CatnipStreamCodecs.VEC3I.encode((Object)out, (Object)src.cloneScaleMax);
            CatnipStreamCodecs.VEC3I.encode((Object)out, (Object)src.cloneOffset);
        }

        public PatternSchematicSyncPacket decode(ByteBuf buf) {
            return new PatternSchematicSyncPacket(buf.readInt(), buf.readBoolean(), (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf), (Rotation)CatnipStreamCodecs.ROTATION.decode((Object)buf), (Mirror)CatnipStreamCodecs.MIRROR.decode((Object)buf), (Vec3i)CatnipStreamCodecs.VEC3I.decode((Object)buf), (Vec3i)CatnipStreamCodecs.VEC3I.decode((Object)buf), (Vec3i)CatnipStreamCodecs.VEC3I.decode((Object)buf));
        }
    };

    public PatternSchematicSyncPacket(int slot, StructurePlaceSettings settings, BlockPos anchor, boolean deployed, Vec3i cloneScaleMin, Vec3i cloneScaleMax, Vec3i cloneOffset) {
        this(slot, deployed, anchor, settings.getRotation(), settings.getMirror(), cloneScaleMin, cloneScaleMax, cloneOffset);
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return PatternSchematicPackets.SYNC_PATTERN_SCHEMATIC;
    }

    public void handle(ServerPlayer player) {
        ItemStack stack = this.slot == -1 ? player.getMainHandItem() : player.getInventory().getItem(this.slot);
        if (!PatternSchematicsRegistry.PATTERN_SCHEMATIC.isIn(stack)) {
            return;
        }
        stack.set(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)this.deployed);
        stack.set(AllDataComponents.SCHEMATIC_ANCHOR, (Object)this.anchor);
        stack.set(AllDataComponents.SCHEMATIC_ROTATION, (Object)this.rotation);
        stack.set(AllDataComponents.SCHEMATIC_MIRROR, (Object)this.mirror);
        stack.set(PatternSchematicsDataComponents.SCHEMATIC_CLONE_OFFSET, (Object)this.cloneOffset);
        stack.set(PatternSchematicsDataComponents.SCHEMATIC_CLONE_SCALE_MIN, (Object)this.cloneScaleMin);
        stack.set(PatternSchematicsDataComponents.SCHEMATIC_CLONE_SCALE_MAX, (Object)this.cloneScaleMax);
        SchematicInstances.clearHash((ItemStack)stack);
    }
}

