/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation.mirror;

import com.cak.pattern_schematics.PatternSchematics;
import com.cak.pattern_schematics.foundation.CloneTool;
import com.cak.pattern_schematics.foundation.SingleIcon;
import com.simibubi.create.content.schematics.client.tools.DeployTool;
import com.simibubi.create.content.schematics.client.tools.FlipTool;
import com.simibubi.create.content.schematics.client.tools.ISchematicTool;
import com.simibubi.create.content.schematics.client.tools.MoveTool;
import com.simibubi.create.content.schematics.client.tools.MoveVerticalTool;
import com.simibubi.create.content.schematics.client.tools.PlaceTool;
import com.simibubi.create.content.schematics.client.tools.RotateTool;
import com.simibubi.create.content.schematics.client.tools.SchematicToolBase;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum PatternSchematicsToolType {
    DEPLOY((ISchematicTool)new DeployTool(), AllIcons.I_TOOL_DEPLOY),
    MOVE((ISchematicTool)new MoveTool(), AllIcons.I_TOOL_MOVE_XZ),
    MOVE_Y((ISchematicTool)new MoveVerticalTool(), AllIcons.I_TOOL_MOVE_Y),
    ROTATE((ISchematicTool)new RotateTool(), AllIcons.I_TOOL_ROTATE),
    FLIP((ISchematicTool)new FlipTool(), AllIcons.I_TOOL_MIRROR),
    PRINT((ISchematicTool)new PlaceTool(), AllIcons.I_CONFIRM),
    CLONE((ISchematicTool)new CloneTool(), new SingleIcon(0, 0, PatternSchematics.asResource("textures/gui/clone_tool.png")), true);

    final ISchematicTool tool;
    final AllIcons icon;
    final boolean patternModId;

    private PatternSchematicsToolType(ISchematicTool tool, AllIcons icon) {
        this(tool, icon, false);
    }

    private PatternSchematicsToolType(ISchematicTool tool, AllIcons icon, boolean patternModId) {
        this.tool = tool;
        this.icon = icon;
        this.patternModId = patternModId;
    }

    public ISchematicTool getTool() {
        return this.tool;
    }

    public MutableComponent getDisplayName() {
        return this.patternModId ? Component.translatable((String)("create_pattern_schematics.schematic.tool." + CreateLang.asId((String)this.name()))) : CreateLang.translateDirect((String)("schematic.tool." + CreateLang.asId((String)this.name())), (Object[])new Object[0]);
    }

    public AllIcons getIcon() {
        return this.icon;
    }

    public static List<PatternSchematicsToolType> getTools(boolean creative) {
        ArrayList<PatternSchematicsToolType> tools = new ArrayList<PatternSchematicsToolType>();
        Collections.addAll(tools, MOVE, MOVE_Y, DEPLOY, ROTATE, FLIP, CLONE);
        if (creative) {
            tools.add(PRINT);
        }
        return tools;
    }

    public static boolean isPatternSchematicTool(SchematicToolBase tool) {
        return Arrays.stream(PatternSchematicsToolType.values()).anyMatch(toolType -> toolType.getTool() == tool);
    }

    public List<Component> getDescription() {
        return this.patternModId ? PatternSchematicsToolType.translatedOptions("create_pattern_schematics.schematic.tool." + CreateLang.asId((String)this.name()) + ".description", "0", "1", "2", "3") : CreateLang.translatedOptions((String)("schematic.tool." + CreateLang.asId((String)this.name()) + ".description"), (String[])new String[]{"0", "1", "2", "3"});
    }

    public static List<Component> translatedOptions(String prefix, String ... keys) {
        ArrayList<Component> result = new ArrayList<Component>(keys.length);
        for (String key : keys) {
            result.add((Component)Component.translatable((String)((String)(prefix != null ? prefix + "." : "") + key)));
        }
        return result;
    }
}

