/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation;

import com.cak.pattern_schematics.foundation.mirror.PatternSchematicHandler;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.content.schematics.client.tools.SchematicToolBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class CloneTool
extends SchematicToolBase {
    public boolean handleRightClick() {
        return false;
    }

    public boolean handleMouseWheel(double delta) {
        Direction face;
        if (!this.schematicSelected && !AllKeys.shiftDown()) {
            return true;
        }
        SchematicHandler schematicHandler = this.schematicHandler;
        if (!(schematicHandler instanceof PatternSchematicHandler)) {
            throw new RuntimeException("Clone tool bound in a normal SchematicHandler!");
        }
        PatternSchematicHandler patternSchematicHandler = (PatternSchematicHandler)schematicHandler;
        LocalPlayer player = Minecraft.getInstance().player;
        Direction direction = face = !AllKeys.shiftDown() && player != null ? this.facingOfPlayer(player).getOpposite() : this.selectedFace;
        if (face == null) {
            return true;
        }
        boolean isPositive = face.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        Vec3i cloneScale = isPositive ? patternSchematicHandler.getCloneScaleMax() : patternSchematicHandler.getCloneScaleMin();
        cloneScale = cloneScale.relative(face, Mth.sign((double)delta));
        if (isPositive) {
            patternSchematicHandler.setCloneScaleMax(cloneScale);
        } else {
            patternSchematicHandler.setCloneScaleMin(cloneScale);
        }
        this.schematicHandler.markDirty();
        return true;
    }

    private Direction facingOfPlayer(LocalPlayer player) {
        Vec3 lookAngle = player.getLookAngle();
        return Direction.getNearest((double)lookAngle.x, (double)lookAngle.y, (double)lookAngle.z);
    }
}

