/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikn.end_respawn_anchor.data_attachment;

import com.github.mikn.end_respawn_anchor.EndRespawnAnchor;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.apache.logging.log4j.Logger;

public class RespawnData
implements INBTSerializable<CompoundTag> {
    private ResourceKey<Level> dimension;
    private BlockPos blockPos;
    private float respawnAngle;
    public static final String NBT_KEY_PLAYER_SPAWN_DIMENSION = "preSpawnDimension";
    public static final String NBT_KEY_PLAYER_SPAWN_POS_X = "preSpawnPosX";
    public static final String NBT_KEY_PLAYER_SPAWN_POS_Y = "preSpawnPosY";
    public static final String NBT_KEY_PLAYER_SPAWN_POS_Z = "preSpawnPosZ";
    public static final String NBT_KEY_PLAYER_SPAWN_ANGLE = "preSpawnAngle";

    public RespawnData(ResourceKey<Level> dimension, BlockPos blockPos, float respawnAngle) {
        this.dimension = dimension;
        this.blockPos = blockPos;
        this.respawnAngle = respawnAngle;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public float getRespawnAngle() {
        return this.respawnAngle;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putString(NBT_KEY_PLAYER_SPAWN_DIMENSION, this.dimension.location().toString());
        tag.putInt(NBT_KEY_PLAYER_SPAWN_POS_X, this.blockPos.getX());
        tag.putInt(NBT_KEY_PLAYER_SPAWN_POS_Y, this.blockPos.getY());
        tag.putInt(NBT_KEY_PLAYER_SPAWN_POS_Z, this.blockPos.getZ());
        tag.putFloat(NBT_KEY_PLAYER_SPAWN_ANGLE, this.respawnAngle);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        ResourceKey dimension = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(NBT_KEY_PLAYER_SPAWN_DIMENSION)).resultOrPartial(arg_0 -> ((Logger)EndRespawnAnchor.LOGGER).error(arg_0)).orElse(Level.OVERWORLD);
        int posX = tag.getInt(NBT_KEY_PLAYER_SPAWN_POS_X);
        int posY = tag.getInt(NBT_KEY_PLAYER_SPAWN_POS_Y);
        int posZ = tag.getInt(NBT_KEY_PLAYER_SPAWN_POS_Z);
        float angle = tag.getFloat(NBT_KEY_PLAYER_SPAWN_ANGLE);
        BlockPos blockPos = new BlockPos(posX, posY, posZ);
        this.dimension = dimension;
        this.blockPos = blockPos;
        this.respawnAngle = angle;
    }
}

