/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikn.end_respawn_anchor.block;

import com.github.mikn.end_respawn_anchor.config.EndRespawnAnchorConfig;
import com.github.mikn.end_respawn_anchor.data_attachment.RespawnData;
import com.github.mikn.end_respawn_anchor.init.DataAttachmentInit;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class EndRespawnAnchorBlock
extends RespawnAnchorBlock {
    public EndRespawnAnchorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (EndRespawnAnchorBlock.isRespawnFuel(stack) && EndRespawnAnchorBlock.canBeCharged((BlockState)state)) {
            EndRespawnAnchorBlock.charge((Entity)player, (Level)level, (BlockPos)pos, (BlockState)state);
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return hand == InteractionHand.MAIN_HAND && EndRespawnAnchorBlock.isRespawnFuel(player.getItemInHand(InteractionHand.OFF_HAND)) && EndRespawnAnchorBlock.canBeCharged((BlockState)state) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if ((Integer)state.getValue((Property)CHARGE) == 0) {
            return InteractionResult.PASS;
        }
        if (EndRespawnAnchorBlock.canSetSpawn(level)) {
            ServerPlayer serverPlayer;
            if (!(level.isClientSide || (serverPlayer = (ServerPlayer)player).getRespawnDimension() == level.dimension() && pos.equals((Object)serverPlayer.getRespawnPosition()))) {
                if (serverPlayer.getRespawnDimension() != Level.END) {
                    RespawnData data = new RespawnData((ResourceKey<Level>)serverPlayer.getRespawnDimension(), serverPlayer.getRespawnPosition(), serverPlayer.getRespawnAngle());
                    player.setData(DataAttachmentInit.RESPAWN_DATA, (Object)data);
                }
                serverPlayer.setRespawnPosition(level.dimension(), pos, 0.0f, false, true);
                level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_SET_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (!level.isClientSide) {
            super.explode(state, level, pos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public final void explode(BlockState state, Level level, BlockPos pos2) {
        if (((Boolean)EndRespawnAnchorConfig.isExplode.get()).booleanValue()) {
            super.explode(state, level, pos2);
        }
    }

    private static boolean isRespawnFuel(ItemStack stack) {
        return stack.is(Items.ENDER_EYE) || stack.is(Items.ENDER_PEARL);
    }

    public static boolean canSetSpawn(Level level) {
        return level.dimension().equals(Level.END);
    }
}

