/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikn.end_respawn_anchor.asm.mixin;

import com.github.mikn.end_respawn_anchor.block.EndRespawnAnchorBlock;
import com.github.mikn.end_respawn_anchor.config.EndRespawnAnchorConfig;
import com.github.mikn.end_respawn_anchor.data_attachment.RespawnData;
import com.github.mikn.end_respawn_anchor.init.DataAttachmentInit;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Debug(export=true)
@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin {
    @Inject(method={"findRespawnAndUseSpawnBlock(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;FZZ)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void checkIfEndRespawnAnchor(ServerLevel level, BlockPos blockPos, float angle, boolean forced, boolean keepInventory, CallbackInfoReturnable<Optional<ServerPlayer.RespawnPosAngle>> cir) {
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (block instanceof EndRespawnAnchorBlock && (forced || (Integer)blockState.getValue((Property)EndRespawnAnchorBlock.CHARGE) > 0) && EndRespawnAnchorBlock.canSetSpawn((Level)level)) {
            Optional optional = EndRespawnAnchorBlock.findStandUpPosition((EntityType)EntityType.PLAYER, (CollisionGetter)level, (BlockPos)blockPos);
            if (!forced && !keepInventory && optional.isPresent()) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)EndRespawnAnchorBlock.CHARGE, (Comparable)Integer.valueOf((Integer)blockState.getValue((Property)EndRespawnAnchorBlock.CHARGE) - 1)), 3);
            }
            cir.setReturnValue(optional.map(vec3 -> ServerPlayer.RespawnPosAngle.of((Vec3)vec3, (BlockPos)blockPos)));
        }
    }

    @ModifyArgs(method={"findRespawnPositionAndUseSpawnBlock(ZLnet/minecraft/world/level/portal/DimensionTransition$PostDimensionTransition;)Lnet/minecraft/world/level/portal/DimensionTransition;"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;findRespawnAndUseSpawnBlock(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;FZZ)Ljava/util/Optional;"))
    private void modifyArgs(Args args, boolean keepInventory, DimensionTransition.PostDimensionTransition postDimensionTransition) {
        ServerPlayer serverPlayer = (ServerPlayer)this;
        if (this.shouldOverrideSpawnData(serverPlayer) && serverPlayer.hasData(DataAttachmentInit.RESPAWN_DATA)) {
            RespawnData data = (RespawnData)serverPlayer.getData(DataAttachmentInit.RESPAWN_DATA);
            args.set(0, (Object)serverPlayer.getServer().getLevel(data.getDimension()));
            args.set(1, (Object)data.getBlockPos());
            args.set(2, (Object)Float.valueOf(data.getRespawnAngle()));
        }
    }

    @ModifyArgs(method={"findRespawnPositionAndUseSpawnBlock(ZLnet/minecraft/world/level/portal/DimensionTransition$PostDimensionTransition;)Lnet/minecraft/world/level/portal/DimensionTransition;"}, at=@At(value="INVOKE", target="net/minecraft/world/level/portal/DimensionTransition.<init> (Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;FFLnet/minecraft/world/level/portal/DimensionTransition$PostDimensionTransition;)V"))
    private void modifyReturnedServerLevel(Args args) {
        ServerPlayer serverPlayer = (ServerPlayer)this;
        if (this.shouldOverrideSpawnData(serverPlayer) && serverPlayer.hasData(DataAttachmentInit.RESPAWN_DATA)) {
            RespawnData data = (RespawnData)serverPlayer.getData(DataAttachmentInit.RESPAWN_DATA);
            args.set(0, (Object)serverPlayer.getServer().getLevel(data.getDimension()));
        }
    }

    @Unique
    private boolean shouldOverrideSpawnData(ServerPlayer serverPlayer) {
        return (Boolean)EndRespawnAnchorConfig.shouldChangeSpawnInfo.get() != false && this.isInsidePortal() && serverPlayer.level().dimension() == Level.END && serverPlayer.getRespawnDimension() == Level.END;
    }

    @Unique
    private boolean isInsidePortal() {
        return ((ServerPlayer)this).portalProcess != null;
    }
}

