/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikn.end_respawn_anchor;

import com.github.mikn.end_respawn_anchor.config.EndRespawnAnchorConfig;
import com.github.mikn.end_respawn_anchor.init.BlockInit;
import com.github.mikn.end_respawn_anchor.init.DataAttachmentInit;
import com.github.mikn.end_respawn_anchor.init.ItemInit;
import java.util.Optional;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

@Mod(value="end_respawn_anchor")
public class EndRespawnAnchor {
    public static final String MODID = "end_respawn_anchor";
    public static final Logger LOGGER = LogManager.getLogger((String)"EndRespawnAnchor/Main");

    public EndRespawnAnchor(@NonNull IEventBus modEventBus) {
        modEventBus.addListener(this::registerCreativeTabs);
        Optional optional = ModList.get().getModContainerById(MODID);
        optional.ifPresentOrElse(container -> container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EndRespawnAnchorConfig.SPEC, "end_respawn_anchor-common.toml"), () -> LOGGER.error("Could not fetch ModContainer."));
        BlockInit.BLOCKS.register(modEventBus);
        ItemInit.ITEMS.register(modEventBus);
        DataAttachmentInit.ATTACHMENT_TYPES.register(modEventBus);
    }

    @SubscribeEvent
    public void registerCreativeTabs(BuildCreativeModeTabContentsEvent evt) {
        if (evt.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            evt.accept(ItemInit.END_RESPAWN_ANCHOR);
        }
    }
}

