/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.online_emotes.utils;

import io.github.kosmx.emotes.main.config.ClientSerializer;
import io.github.kosmx.emotes.server.config.Serializer;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.Connection;
import org.jetbrains.annotations.Nullable;

public class EmotePacketWrapper {
    public final boolean supportsCompression = true;
    public final byte[] emotePacket;
    @Nullable
    public String playerName;
    @Nullable
    public UUID playerUUID;
    @Nullable
    public String serverAddress;

    public EmotePacketWrapper(byte[] emotePacket) {
        this.emotePacket = emotePacket;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            this.playerName = player.getScoreboardName();
            this.playerUUID = player.getUUID();
            Connection connection = player.connection.getConnection();
            if (!connection.isMemoryConnection()) {
                this.serverAddress = EmotePacketWrapper.getIP(connection.getRemoteAddress());
            }
        }
        if (Serializer.serializer == null) {
            new ClientSerializer().initializeSerializer();
        }
    }

    public TextWebSocketFrame toWebSocketFrame() {
        return new TextWebSocketFrame(Serializer.serializer.toJson((Object)this));
    }

    private static String getIP(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            return inetSocketAddress.getAddress().getHostAddress();
        }
        return address.toString();
    }
}

