/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.base;

import com.finchy.pipeorgans.block.base.BaseBlockEntity;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.finchy.pipeorgans.init.AllShapes;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BaseBlock
extends Block
implements IBE<BaseBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WALL = WhistleBlock.WALL;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public BaseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WALL, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.getValue((Property)WALL) == false ? AllShapes.BASE_FLOOR : AllShapes.getBlockBase((Direction)pState.getValue((Property)FACING));
    }

    public Class<BaseBlockEntity> getBlockEntityClass() {
        return BaseBlockEntity.class;
    }

    public BlockEntityType<? extends BaseBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntities.BASE_BLOCK_ENTITY.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WALL, POWERED});
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return FluidTankBlock.isTank((BlockState)pLevel.getBlockState(pPos.relative(BaseBlock.getAttachedDirection(pState))));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state;
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Direction face = context.getClickedFace();
        boolean wall = true;
        if (face.getAxis() == Direction.Axis.Y) {
            face = context.getHorizontalDirection().getOpposite();
            wall = false;
        }
        if (!this.canSurvive(state = (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)face.getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(clickedPos)))).setValue((Property)WALL, (Comparable)Boolean.valueOf(wall)), (LevelReader)level, clickedPos)) {
            return null;
        }
        return state;
    }

    public static Direction getAttachedDirection(BlockState state) {
        return (Boolean)state.getValue((Property)WALL) != false ? (Direction)state.getValue((Property)FACING) : Direction.DOWN;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.isClientSide) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.getValue((Property)POWERED);
        if (previouslyPowered != worldIn.hasNeighborSignal(pos)) {
            worldIn.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return BaseBlock.getAttachedDirection(pState) == pFacing && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : pState;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.relative(BaseBlock.getAttachedDirection(pState)));
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.relative(BaseBlock.getAttachedDirection(pState)));
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return originalState;
    }
}

