/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.rocks.block;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.tuple.Pair;
import tv.mapper.embellishcraft.core.util.RockType;
import tv.mapper.mapperbase.api.block.CustomBlock;
import tv.mapper.mapperbase.api.block.CustomButtonBlock;
import tv.mapper.mapperbase.api.block.CustomPressurePlateBlock;
import tv.mapper.mapperbase.api.block.CustomSlabBlock;
import tv.mapper.mapperbase.api.block.CustomStairBlock;
import tv.mapper.mapperbase.api.block.CustomWallBlock;
import tv.mapper.mapperbase.api.block.tools.ToolTypes;

public class InitRockBlocks {
    public static final DeferredRegister.Blocks ROCK_BLOCK_REGISTRY = DeferredRegister.createBlocks((String)"embellishcraft");
    public static final Map<RockType, DeferredBlock<CustomBlock>> ROCK_BLOCKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName(), () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops().requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomStairBlock>> ROCK_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_stairs", () -> new CustomStairBlock(((CustomBlock)ROCK_BLOCKS.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomSlabBlock>> ROCK_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomWallBlock>> ROCK_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomPressurePlateBlock>> ROCK_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomButtonBlock>> ROCK_BUTTONS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_button", () -> new CustomButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomBlock>> ROCK_COBBLESTONES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomStairBlock>> ROCK_COBBLESTONE_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_stairs", () -> new CustomStairBlock(((CustomBlock)ROCK_COBBLESTONES.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomSlabBlock>> ROCK_COBBLESTONE_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomWallBlock>> ROCK_COBBLESTONE_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomPressurePlateBlock>> ROCK_COBBLESTONE_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomBlock>> ROCK_COBBLESTONE_BRICKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomStairBlock>> ROCK_COBBLESTONE_BRICKS_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_bricks_stairs", () -> new CustomStairBlock(((CustomBlock)ROCK_COBBLESTONES.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomSlabBlock>> ROCK_COBBLESTONE_BRICKS_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomWallBlock>> ROCK_COBBLESTONE_BRICKS_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomPressurePlateBlock>> ROCK_COBBLESTONE_BRICKS_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_cobblestone_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomBlock>> SMOOTH_ROCK_BLOCKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("smooth_" + type.getName(), () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomStairBlock>> SMOOTH_ROCK_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("smooth_" + type.getName() + "_stairs", () -> new CustomStairBlock(((CustomBlock)SMOOTH_ROCK_BLOCKS.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomSlabBlock>> SMOOTH_ROCK_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("smooth_" + type.getName() + "_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomWallBlock>> SMOOTH_ROCK_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("smooth_" + type.getName() + "_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomPressurePlateBlock>> SMOOTH_ROCK_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("smooth_" + type.getName() + "_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomBlock>> POLISHED_ROCK_BLOCKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("polished_" + type.getName(), () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomStairBlock>> POLISHED_ROCK_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("polished_" + type.getName() + "_stairs", () -> new CustomStairBlock(((CustomBlock)POLISHED_ROCK_BLOCKS.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomSlabBlock>> POLISHED_ROCK_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("polished_" + type.getName() + "_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomWallBlock>> POLISHED_ROCK_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("polished_" + type.getName() + "_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomPressurePlateBlock>> POLISHED_ROCK_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register("polished_" + type.getName() + "_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomBlock>> ROCK_PAVINGS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomStairBlock>> ROCK_PAVING_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stairs", () -> new CustomStairBlock(((CustomBlock)ROCK_PAVINGS.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomSlabBlock>> ROCK_PAVING_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomWallBlock>> ROCK_PAVING_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomPressurePlateBlock>> ROCK_PAVING_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomBlock>> ROCK_TILES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_tiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomStairBlock>> ROCK_TILES_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_tiles_stairs", () -> new CustomStairBlock(((CustomBlock)ROCK_TILES.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomSlabBlock>> ROCK_TILES_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomWallBlock>> ROCK_TILES_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomPressurePlateBlock>> ROCK_TILES_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_tiles_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomBlock>> ROCK_BRICKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomStairBlock>> ROCK_BRICKS_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_bricks_stairs", () -> new CustomStairBlock(((CustomBlock)ROCK_BRICKS.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomSlabBlock>> ROCK_BRICKS_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomWallBlock>> ROCK_BRICKS_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomPressurePlateBlock>> ROCK_BRICKS_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomBlock>> ROCK_LARGE_BRICKS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomStairBlock>> ROCK_LARGE_BRICKS_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_large_bricks_stairs", () -> new CustomStairBlock(((CustomBlock)ROCK_LARGE_BRICKS.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomSlabBlock>> ROCK_LARGE_BRICKS_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomWallBlock>> ROCK_LARGE_BRICKS_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomPressurePlateBlock>> ROCK_LARGE_BRICKS_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomBlock>> ROCK_PAVING_STONES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomStairBlock>> ROCK_PAVING_STONES_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stones_stairs", () -> new CustomStairBlock(((CustomBlock)ROCK_PAVING_STONES.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomSlabBlock>> ROCK_PAVING_STONES_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomWallBlock>> ROCK_PAVING_STONES_WALLS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomPressurePlateBlock>> ROCK_PAVING_STONES_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomBlock>> ROCK_ORNAMENTS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_ornament", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomPressurePlateBlock>> ROCK_ORNAMENT_PRESSURE_PLATES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_ornament_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomBlock>> ROCK_ROOFTILES = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomStairBlock>> ROCK_ROOFTILES_STAIRS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_rooftiles_stairs", () -> new CustomStairBlock(((CustomBlock)ROCK_BLOCKS.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<RockType, DeferredBlock<CustomSlabBlock>> ROCK_ROOFTILES_SLABS = Arrays.stream(RockType.values()).map(type -> Pair.of((Object)type, (Object)ROCK_BLOCK_REGISTRY.register(type.getName() + "_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(type.getColor()).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final DeferredBlock<CustomBlock> PAVING_STONES = ROCK_BLOCK_REGISTRY.register("paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("paving_stones_stairs", () -> new CustomStairBlock(Blocks.STONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> SMOOTH_ANDESITE = ROCK_BLOCK_REGISTRY.register("smooth_andesite", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> SMOOTH_ANDESITE_STAIRS = ROCK_BLOCK_REGISTRY.register("smooth_andesite_stairs", () -> new CustomStairBlock(((CustomBlock)SMOOTH_ANDESITE.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> SMOOTH_ANDESITE_SLAB = ROCK_BLOCK_REGISTRY.register("smooth_andesite_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> SMOOTH_ANDESITE_WALL = ROCK_BLOCK_REGISTRY.register("smooth_andesite_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> SMOOTH_ANDESITE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("smooth_andesite_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomButtonBlock> ANDESITE_BUTTON = ROCK_BLOCK_REGISTRY.register("andesite_button", () -> new CustomButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> ANDESITE_PAVING = ROCK_BLOCK_REGISTRY.register("andesite_paving", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> ANDESITE_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_paving_stairs", () -> new CustomStairBlock(Blocks.ANDESITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> ANDESITE_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> ANDESITE_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("andesite_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> ANDESITE_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_paving_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> ANDESITE_TILES = ROCK_BLOCK_REGISTRY.register("andesite_tiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> ANDESITE_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_tiles_stairs", () -> new CustomStairBlock(Blocks.ANDESITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> ANDESITE_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> ANDESITE_TILES_WALL = ROCK_BLOCK_REGISTRY.register("andesite_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> ANDESITE_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_tiles_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> ANDESITE_BRICKS = ROCK_BLOCK_REGISTRY.register("andesite_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> ANDESITE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_bricks_stairs", () -> new CustomStairBlock(Blocks.ANDESITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> ANDESITE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> ANDESITE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("andesite_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> ANDESITE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> ANDESITE_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("andesite_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> ANDESITE_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_large_bricks_stairs", () -> new CustomStairBlock(Blocks.ANDESITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> ANDESITE_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> ANDESITE_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("andesite_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> ANDESITE_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> ANDESITE_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("andesite_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> ANDESITE_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_paving_stones_stairs", () -> new CustomStairBlock(Blocks.ANDESITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> ANDESITE_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> ANDESITE_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("andesite_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> ANDESITE_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> ANDESITE_ORNAMENT = ROCK_BLOCK_REGISTRY.register("andesite_ornament", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> ANDESITE_ORNAMENT_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("andesite_ornament_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> ANDESITE_ROOFTILES = ROCK_BLOCK_REGISTRY.register("andesite_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> ANDESITE_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("andesite_rooftiles_stairs", () -> new CustomStairBlock(Blocks.ANDESITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> ANDESITE_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("andesite_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> SMOOTH_DIORITE = ROCK_BLOCK_REGISTRY.register("smooth_diorite", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> SMOOTH_DIORITE_STAIRS = ROCK_BLOCK_REGISTRY.register("smooth_diorite_stairs", () -> new CustomStairBlock(((CustomBlock)SMOOTH_DIORITE.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> SMOOTH_DIORITE_SLAB = ROCK_BLOCK_REGISTRY.register("smooth_diorite_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> SMOOTH_DIORITE_WALL = ROCK_BLOCK_REGISTRY.register("smooth_diorite_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> SMOOTH_DIORITE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("smooth_diorite_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomButtonBlock> DIORITE_BUTTON = ROCK_BLOCK_REGISTRY.register("diorite_button", () -> new CustomButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> DIORITE_PAVING = ROCK_BLOCK_REGISTRY.register("diorite_paving", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> DIORITE_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_paving_stairs", () -> new CustomStairBlock(Blocks.DIORITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> DIORITE_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> DIORITE_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("diorite_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> DIORITE_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_paving_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> DIORITE_TILES = ROCK_BLOCK_REGISTRY.register("diorite_tiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> DIORITE_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_tiles_stairs", () -> new CustomStairBlock(Blocks.DIORITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> DIORITE_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> DIORITE_TILES_WALL = ROCK_BLOCK_REGISTRY.register("diorite_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> DIORITE_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_tiles_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> DIORITE_BRICKS = ROCK_BLOCK_REGISTRY.register("diorite_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> DIORITE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_bricks_stairs", () -> new CustomStairBlock(Blocks.DIORITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> DIORITE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> DIORITE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("diorite_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> DIORITE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> DIORITE_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("diorite_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> DIORITE_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_large_bricks_stairs", () -> new CustomStairBlock(Blocks.DIORITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> DIORITE_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> DIORITE_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("diorite_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> DIORITE_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> DIORITE_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("diorite_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> DIORITE_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_paving_stones_stairs", () -> new CustomStairBlock(Blocks.DIORITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> DIORITE_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> DIORITE_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("diorite_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> DIORITE_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> DIORITE_ORNAMENT = ROCK_BLOCK_REGISTRY.register("diorite_ornament", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> DIORITE_ORNAMENT_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("diorite_ornament_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.QUARTZ).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> DIORITE_ROOFTILES = ROCK_BLOCK_REGISTRY.register("diorite_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> DIORITE_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("diorite_rooftiles_stairs", () -> new CustomStairBlock(Blocks.DIORITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> DIORITE_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("diorite_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> SMOOTH_GRANITE = ROCK_BLOCK_REGISTRY.register("smooth_granite", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> SMOOTH_GRANITE_STAIRS = ROCK_BLOCK_REGISTRY.register("smooth_granite_stairs", () -> new CustomStairBlock(((CustomBlock)SMOOTH_GRANITE.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> SMOOTH_GRANITE_SLAB = ROCK_BLOCK_REGISTRY.register("smooth_granite_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> SMOOTH_GRANITE_WALL = ROCK_BLOCK_REGISTRY.register("smooth_granite_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> SMOOTH_GRANITE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("smooth_granite_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomButtonBlock> GRANITE_BUTTON = ROCK_BLOCK_REGISTRY.register("granite_button", () -> new CustomButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> GRANITE_PAVING = ROCK_BLOCK_REGISTRY.register("granite_paving", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> GRANITE_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_paving_stairs", () -> new CustomStairBlock(Blocks.GRANITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> GRANITE_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("granite_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> GRANITE_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("granite_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> GRANITE_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_paving_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> GRANITE_TILES = ROCK_BLOCK_REGISTRY.register("granite_tiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> GRANITE_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_tiles_stairs", () -> new CustomStairBlock(Blocks.GRANITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> GRANITE_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("granite_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> GRANITE_TILES_WALL = ROCK_BLOCK_REGISTRY.register("granite_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> GRANITE_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_tiles_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> GRANITE_BRICKS = ROCK_BLOCK_REGISTRY.register("granite_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> GRANITE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_bricks_stairs", () -> new CustomStairBlock(Blocks.GRANITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> GRANITE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("granite_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> GRANITE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("granite_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> GRANITE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> GRANITE_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("granite_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> GRANITE_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_large_bricks_stairs", () -> new CustomStairBlock(Blocks.GRANITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> GRANITE_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("granite_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> GRANITE_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("granite_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> GRANITE_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> GRANITE_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("granite_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> GRANITE_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_paving_stones_stairs", () -> new CustomStairBlock(Blocks.GRANITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> GRANITE_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("granite_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> GRANITE_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("granite_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> GRANITE_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> GRANITE_ORNAMENT = ROCK_BLOCK_REGISTRY.register("granite_ornament", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> GRANITE_ORNAMENT_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("granite_ornament_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.DIRT).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> GRANITE_ROOFTILES = ROCK_BLOCK_REGISTRY.register("granite_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> GRANITE_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("granite_rooftiles_stairs", () -> new CustomStairBlock(Blocks.GRANITE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> GRANITE_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("granite_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomButtonBlock> SANDSTONE_BUTTON = ROCK_BLOCK_REGISTRY.register("sandstone_button", () -> new CustomButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> SMOOTH_SANDSTONE_WALL = ROCK_BLOCK_REGISTRY.register("smooth_sandstone_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> SMOOTH_SANDSTONE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("smooth_sandstone_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> POLISHED_SANDSTONE = ROCK_BLOCK_REGISTRY.register("polished_sandstone", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> POLISHED_SANDSTONE_STAIRS = ROCK_BLOCK_REGISTRY.register("polished_sandstone_stairs", () -> new CustomStairBlock(Blocks.SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> POLISHED_SANDSTONE_SLAB = ROCK_BLOCK_REGISTRY.register("polished_sandstone_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> POLISHED_SANDSTONE_WALL = ROCK_BLOCK_REGISTRY.register("polished_sandstone_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> POLISHED_SANDSTONE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("polished_sandstone_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> SANDSTONE_PAVING = ROCK_BLOCK_REGISTRY.register("sandstone_paving", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> SANDSTONE_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stairs", () -> new CustomStairBlock(Blocks.SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> SANDSTONE_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> SANDSTONE_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("sandstone_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> SANDSTONE_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("sandstone_paving_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> SANDSTONE_TILES = ROCK_BLOCK_REGISTRY.register("sandstone_tiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> SANDSTONE_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_tiles_stairs", () -> new CustomStairBlock(Blocks.SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> SANDSTONE_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> SANDSTONE_TILES_WALL = ROCK_BLOCK_REGISTRY.register("sandstone_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> SANDSTONE_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("sandstone_tiles_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> SANDSTONE_BRICKS = ROCK_BLOCK_REGISTRY.register("sandstone_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> SANDSTONE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_bricks_stairs", () -> new CustomStairBlock(Blocks.SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> SANDSTONE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> SANDSTONE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("sandstone_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> SANDSTONE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("sandstone_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> SANDSTONE_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("sandstone_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> SANDSTONE_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_large_bricks_stairs", () -> new CustomStairBlock(Blocks.SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> SANDSTONE_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> SANDSTONE_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("sandstone_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> SANDSTONE_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("sandstone_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> SANDSTONE_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> SANDSTONE_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stones_stairs", () -> new CustomStairBlock(Blocks.SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> SANDSTONE_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> SANDSTONE_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> SANDSTONE_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("sandstone_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.SAND).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> SANDSTONE_ROOFTILES = ROCK_BLOCK_REGISTRY.register("sandstone_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> SANDSTONE_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("sandstone_rooftiles_stairs", () -> new CustomStairBlock(Blocks.SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> SANDSTONE_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("sandstone_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomButtonBlock> RED_SANDSTONE_BUTTON = ROCK_BLOCK_REGISTRY.register("red_sandstone_button", () -> new CustomButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> SMOOTH_RED_SANDSTONE_WALL = ROCK_BLOCK_REGISTRY.register("smooth_red_sandstone_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> SMOOTH_RED_SANDSTONE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("smooth_red_sandstone_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> POLISHED_RED_SANDSTONE = ROCK_BLOCK_REGISTRY.register("polished_red_sandstone", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> POLISHED_RED_SANDSTONE_STAIRS = ROCK_BLOCK_REGISTRY.register("polished_red_sandstone_stairs", () -> new CustomStairBlock(Blocks.RED_SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> POLISHED_RED_SANDSTONE_SLAB = ROCK_BLOCK_REGISTRY.register("polished_red_sandstone_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> POLISHED_RED_SANDSTONE_WALL = ROCK_BLOCK_REGISTRY.register("polished_red_sandstone_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> POLISHED_RED_SANDSTONE_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("polished_red_sandstone_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> RED_SANDSTONE_PAVING = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> RED_SANDSTONE_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stairs", () -> new CustomStairBlock(Blocks.RED_SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> RED_SANDSTONE_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> RED_SANDSTONE_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> RED_SANDSTONE_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> RED_SANDSTONE_TILES = ROCK_BLOCK_REGISTRY.register("red_sandstone_tiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> RED_SANDSTONE_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_tiles_stairs", () -> new CustomStairBlock(Blocks.RED_SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> RED_SANDSTONE_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> RED_SANDSTONE_TILES_WALL = ROCK_BLOCK_REGISTRY.register("red_sandstone_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> RED_SANDSTONE_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("red_sandstone_tiles_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> RED_SANDSTONE_BRICKS = ROCK_BLOCK_REGISTRY.register("red_sandstone_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> RED_SANDSTONE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_bricks_stairs", () -> new CustomStairBlock(Blocks.RED_SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> RED_SANDSTONE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> RED_SANDSTONE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("red_sandstone_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> RED_SANDSTONE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("red_sandstone_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> RED_SANDSTONE_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("red_sandstone_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> RED_SANDSTONE_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_large_bricks_stairs", () -> new CustomStairBlock(Blocks.RED_SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> RED_SANDSTONE_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> RED_SANDSTONE_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("red_sandstone_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> RED_SANDSTONE_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("red_sandstone_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> RED_SANDSTONE_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> RED_SANDSTONE_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stones_stairs", () -> new CustomStairBlock(Blocks.RED_SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> RED_SANDSTONE_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> RED_SANDSTONE_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> RED_SANDSTONE_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("red_sandstone_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> RED_SANDSTONE_ROOFTILES = ROCK_BLOCK_REGISTRY.register("red_sandstone_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> RED_SANDSTONE_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("red_sandstone_rooftiles_stairs", () -> new CustomStairBlock(Blocks.RED_SANDSTONE.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> RED_SANDSTONE_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("red_sandstone_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> TERRACOTTA_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_stairs", () -> new CustomStairBlock(Blocks.TERRACOTTA.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> TERRACOTTA_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> TERRACOTTA_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> TERRACOTTA_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomButtonBlock> TERRACOTTA_BUTTON = ROCK_BLOCK_REGISTRY.register("terracotta_button", () -> new CustomButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> POLISHED_TERRACOTTA = ROCK_BLOCK_REGISTRY.register("polished_terracotta", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> POLISHED_TERRACOTTA_STAIRS = ROCK_BLOCK_REGISTRY.register("polished_terracotta_stairs", () -> new CustomStairBlock(((CustomBlock)POLISHED_TERRACOTTA.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> POLISHED_TERRACOTTA_SLAB = ROCK_BLOCK_REGISTRY.register("polished_terracotta_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> POLISHED_TERRACOTTA_WALL = ROCK_BLOCK_REGISTRY.register("polished_terracotta_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> POLISHED_TERRACOTTA_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("polished_terracotta_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> TERRACOTTA_PAVING = ROCK_BLOCK_REGISTRY.register("terracotta_paving", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> TERRACOTTA_PAVING_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stairs", () -> new CustomStairBlock(((CustomBlock)TERRACOTTA_PAVING.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> TERRACOTTA_PAVING_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_paving_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> TERRACOTTA_PAVING_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_paving_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> TERRACOTTA_PAVING_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_paving_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> TERRACOTTA_TILES = ROCK_BLOCK_REGISTRY.register("terracotta_tiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> TERRACOTTA_TILES_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_tiles_stairs", () -> new CustomStairBlock(((CustomBlock)TERRACOTTA_TILES.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> TERRACOTTA_TILES_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_tiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> TERRACOTTA_TILES_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_tiles_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> TERRACOTTA_TILES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_tiles_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> TERRACOTTA_BRICKS = ROCK_BLOCK_REGISTRY.register("terracotta_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> TERRACOTTA_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_bricks_stairs", () -> new CustomStairBlock(((CustomBlock)TERRACOTTA_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> TERRACOTTA_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> TERRACOTTA_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> TERRACOTTA_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> TERRACOTTA_LARGE_BRICKS = ROCK_BLOCK_REGISTRY.register("terracotta_large_bricks", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> TERRACOTTA_LARGE_BRICKS_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_large_bricks_stairs", () -> new CustomStairBlock(((CustomBlock)TERRACOTTA_LARGE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> TERRACOTTA_LARGE_BRICKS_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_large_bricks_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> TERRACOTTA_LARGE_BRICKS_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_large_bricks_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> TERRACOTTA_LARGE_BRICKS_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_large_bricks_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> TERRACOTTA_PAVING_STONES = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stones", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> TERRACOTTA_PAVING_STONES_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stones_stairs", () -> new CustomStairBlock(((CustomBlock)TERRACOTTA_PAVING_STONES.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> TERRACOTTA_PAVING_STONES_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stones_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> TERRACOTTA_PAVING_STONES_WALL = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stones_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> TERRACOTTA_PAVING_STONES_PRESSURE_PLATE = ROCK_BLOCK_REGISTRY.register("terracotta_paving_stones_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.COLOR_ORANGE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> TERRACOTTA_ROOFTILES = ROCK_BLOCK_REGISTRY.register("terracotta_rooftiles", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> TERRACOTTA_ROOFTILES_STAIRS = ROCK_BLOCK_REGISTRY.register("terracotta_rooftiles_stairs", () -> new CustomStairBlock(Blocks.TERRACOTTA.defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> TERRACOTTA_ROOFTILES_SLAB = ROCK_BLOCK_REGISTRY.register("terracotta_rooftiles_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).strength(1.5f, 6.0f), ToolTypes.PICKAXE));
}

