/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.lights.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.mapper.mapperbase.api.block.CustomBlock;
import tv.mapper.mapperbase.api.block.tools.ToolTiers;
import tv.mapper.mapperbase.api.block.tools.ToolTypes;

public class LampBlock
extends CustomBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public boolean isManual = false;
    private static final VoxelShape BASE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)3.0, (double)10.0);
    private static final VoxelShape ROD = Block.box((double)7.0, (double)3.0, (double)7.0, (double)9.0, (double)4.0, (double)9.0);
    private static final VoxelShape LAMP1 = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape LAMP2 = Block.box((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private static final VoxelShape LAMP3 = Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
    private static final VoxelShape LAMP = Shapes.or((VoxelShape)BASE, (VoxelShape)Shapes.or((VoxelShape)ROD, (VoxelShape)Shapes.or((VoxelShape)LAMP1, (VoxelShape)Shapes.or((VoxelShape)LAMP2, (VoxelShape)LAMP3))));
    private static final VoxelShape LAMP_COL = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0);

    public LampBlock(BlockBehaviour.Properties properties, ToolTypes tool, boolean isManual) {
        super(properties, tool);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.isManual = isManual;
    }

    public LampBlock(BlockBehaviour.Properties properties, ToolTypes tool, ToolTiers tier, boolean isManual) {
        super(properties, tool, tier);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.isManual = isManual;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return LAMP;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return LAMP_COL;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return LampBlock.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult result) {
        if (!world.isClientSide && this.isManual) {
            BlockState blockstate = this.setLit(state, world, pos);
            float f = (Boolean)blockstate.getValue((Property)LIT) != false ? 1.5f : 0.7f;
            world.playSound((Player)null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 0.3f, f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState setLit(BlockState state, Level world, BlockPos pos) {
        state = (BlockState)state.cycle((Property)LIT);
        world.setBlock(pos, state, 3);
        return state;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        FluidState FluidState2 = context.getLevel().getFluidState(blockpos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN && !this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT) != false ? super.getLightEmission(state, world, pos) : 0;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.isClientSide && !this.isManual && ((Boolean)state.getValue((Property)LIT)).booleanValue() != worldIn.hasNeighborSignal(pos)) {
            worldIn.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

