/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.industrial.event;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import tv.mapper.embellishcraft.industrial.block.InitIndustrialBlocks;
import tv.mapper.mapperbase.item.MB_Items;

@EventBusSubscriber(modid="embellishcraft")
public class RivetEventHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Block block = world.getBlockState(pos).getBlock();
        Block newBlock = Blocks.AIR;
        if (player.getMainHandItem().getItem() == MB_Items.RIVET.get()) {
            if (block == InitIndustrialBlocks.IRON_BEAM.get()) {
                newBlock = (Block)InitIndustrialBlocks.BOLTED_IRON_BEAM.get();
            } else if (block == InitIndustrialBlocks.STEEL_BEAM.get()) {
                newBlock = (Block)InitIndustrialBlocks.BOLTED_STEEL_BEAM.get();
            }
            if (newBlock != Blocks.AIR) {
                BlockState state = world.getBlockState(pos);
                Direction.Axis AXIS = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
                ItemStack stack = ItemStack.EMPTY;
                if (player.getMainHandItem().getItem() == MB_Items.RIVET.get()) {
                    stack = player.getMainHandItem();
                }
                world.setBlockAndUpdate(pos, (BlockState)newBlock.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)AXIS));
                if (!world.isClientSide) {
                    world.playSound(null, pos, SoundEvents.ZOMBIE_ATTACK_IRON_DOOR, SoundSource.BLOCKS, 0.25f, 2.0f);
                }
                if (!player.isCreative()) {
                    stack.setCount(stack.getCount() - 1);
                }
            }
        } else if (player.getMainHandItem().getItem() == MB_Items.FLATTER_HAMMER.get() || player.getMainHandItem().getItem() == MB_Items.REINFORCED_FLATTER_HAMMER.get()) {
            if (block == InitIndustrialBlocks.BOLTED_IRON_BEAM.get()) {
                newBlock = (Block)InitIndustrialBlocks.IRON_BEAM.get();
            } else if (block == InitIndustrialBlocks.BOLTED_STEEL_BEAM.get()) {
                newBlock = (Block)InitIndustrialBlocks.STEEL_BEAM.get();
            }
            if (newBlock != Blocks.AIR) {
                BlockState state = world.getBlockState(pos);
                Direction.Axis AXIS = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
                ItemStack stack = ItemStack.EMPTY;
                if (player.getMainHandItem().getItem() == MB_Items.FLATTER_HAMMER.get() || player.getMainHandItem().getItem() == MB_Items.REINFORCED_FLATTER_HAMMER.get()) {
                    stack = player.getMainHandItem();
                }
                world.setBlockAndUpdate(pos, (BlockState)newBlock.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)AXIS));
                if (!world.isClientSide) {
                    world.playSound(null, pos, SoundEvents.LANTERN_HIT, SoundSource.BLOCKS, 1.0f, 0.25f);
                }
                if (!player.isCreative()) {
                    ItemStack drop = new ItemStack((ItemLike)MB_Items.RIVET.get());
                    Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)drop);
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            }
        }
    }
}

