/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.industrial.block;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.tuple.Pair;
import tv.mapper.embellishcraft.building.block.SuspendedStairBlock;
import tv.mapper.mapperbase.api.block.AllRotationBlock;
import tv.mapper.mapperbase.api.block.CustomBlock;
import tv.mapper.mapperbase.api.block.CustomDoorBlock;
import tv.mapper.mapperbase.api.block.CustomFenceBlock;
import tv.mapper.mapperbase.api.block.CustomFenceGateBlock;
import tv.mapper.mapperbase.api.block.CustomLadderBlock;
import tv.mapper.mapperbase.api.block.CustomPressurePlateBlock;
import tv.mapper.mapperbase.api.block.CustomRotatedPillarBlock;
import tv.mapper.mapperbase.api.block.CustomSlabBlock;
import tv.mapper.mapperbase.api.block.CustomStairBlock;
import tv.mapper.mapperbase.api.block.CustomWallBlock;
import tv.mapper.mapperbase.api.block.tools.ToolTypes;

public class InitIndustrialBlocks {
    public static final DeferredRegister.Blocks INDUSTRIAL_BLOCK_REGISTRY = DeferredRegister.createBlocks((String)"embellishcraft");
    public static final Map<DyeColor, DeferredBlock<CustomBlock>> CORRUGATED_METAL_PLATE_BLOCKS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)INDUSTRIAL_BLOCK_REGISTRY.register(type.getName() + "_corrugated_metal_plate", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(type.getMapColor()).strength(1.5f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<DyeColor, DeferredBlock<CustomStairBlock>> CORRUGATED_METAL_PLATE_STAIRS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)INDUSTRIAL_BLOCK_REGISTRY.register(type.getName() + "_corrugated_metal_plate_stairs", () -> new CustomStairBlock(((CustomBlock)CORRUGATED_METAL_PLATE_BLOCKS.get(type).get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.COLOR_BLACK).strength(1.5f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<DyeColor, DeferredBlock<CustomSlabBlock>> CORRUGATED_METAL_PLATE_SLABS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)INDUSTRIAL_BLOCK_REGISTRY.register(type.getName() + "_corrugated_metal_plate_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(type.getMapColor()).strength(1.5f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<DyeColor, DeferredBlock<CustomWallBlock>> CORRUGATED_METAL_PLATE_WALLS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)INDUSTRIAL_BLOCK_REGISTRY.register(type.getName() + "_corrugated_metal_plate_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(type.getMapColor()).strength(1.5f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<DyeColor, DeferredBlock<CustomPressurePlateBlock>> CORRUGATED_METAL_PLATE_PRESSURE_PLATES = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)INDUSTRIAL_BLOCK_REGISTRY.register(type.getName() + "_corrugated_metal_plate_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(type.getMapColor()).strength(1.5f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<DyeColor, DeferredBlock<CustomFenceBlock>> CORRUGATED_METAL_PLATE_FENCES = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)INDUSTRIAL_BLOCK_REGISTRY.register(type.getName() + "_corrugated_metal_plate_fence", () -> new CustomFenceBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(type.getMapColor()).strength(1.5f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops(), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<DyeColor, DeferredBlock<CustomFenceGateBlock>> CORRUGATED_METAL_PLATE_FENCE_GATES = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)INDUSTRIAL_BLOCK_REGISTRY.register(type.getName() + "_corrugated_metal_plate_fence_gate", () -> new CustomFenceGateBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(type.getMapColor()).strength(1.5f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops(), SoundEvents.IRON_TRAPDOOR_OPEN, SoundEvents.IRON_TRAPDOOR_CLOSE, ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final DeferredBlock<CustomBlock> DARK_METAL_FLOOR = INDUSTRIAL_BLOCK_REGISTRY.register("dark_metal_floor", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.PODZOL).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> DARK_METAL_FLOOR_STAIRS = INDUSTRIAL_BLOCK_REGISTRY.register("dark_metal_floor_stairs", () -> new CustomStairBlock(((CustomBlock)DARK_METAL_FLOOR.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.PODZOL).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> DARK_METAL_FLOOR_SLAB = INDUSTRIAL_BLOCK_REGISTRY.register("dark_metal_floor_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.PODZOL).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> DARK_METAL_FLOOR_WALL = INDUSTRIAL_BLOCK_REGISTRY.register("dark_metal_floor_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.PODZOL).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> DARK_METAL_FLOOR_PRESSURE_PLATE = INDUSTRIAL_BLOCK_REGISTRY.register("dark_metal_floor_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.PODZOL).noCollission().strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> LIGHT_METAL_FLOOR = INDUSTRIAL_BLOCK_REGISTRY.register("light_metal_floor", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.CLAY).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> LIGHT_METAL_FLOOR_STAIRS = INDUSTRIAL_BLOCK_REGISTRY.register("light_metal_floor_stairs", () -> new CustomStairBlock(((CustomBlock)LIGHT_METAL_FLOOR.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.CLAY).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> LIGHT_METAL_FLOOR_SLAB = INDUSTRIAL_BLOCK_REGISTRY.register("light_metal_floor_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.CLAY).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> LIGHT_METAL_FLOOR_WALL = INDUSTRIAL_BLOCK_REGISTRY.register("light_metal_floor_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.CLAY).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> LIGHT_METAL_FLOOR_PRESSURE_PLATE = INDUSTRIAL_BLOCK_REGISTRY.register("light_metal_floor_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.CLAY).noCollission().strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> RUSTY_PLATE = INDUSTRIAL_BLOCK_REGISTRY.register("rusty_plate", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.TERRACOTTA_ORANGE).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomStairBlock> RUSTY_PLATE_STAIRS = INDUSTRIAL_BLOCK_REGISTRY.register("rusty_plate_stairs", () -> new CustomStairBlock(((CustomBlock)RUSTY_PLATE.get()).defaultBlockState(), BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.TERRACOTTA_ORANGE).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomSlabBlock> RUSTY_PLATE_SLAB = INDUSTRIAL_BLOCK_REGISTRY.register("rusty_plate_slab", () -> new CustomSlabBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.TERRACOTTA_ORANGE).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomWallBlock> RUSTY_PLATE_WALL = INDUSTRIAL_BLOCK_REGISTRY.register("rusty_plate_wall", () -> new CustomWallBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.TERRACOTTA_ORANGE).strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomPressurePlateBlock> RUSTY_PLATE_PRESSURE_PLATE = INDUSTRIAL_BLOCK_REGISTRY.register("rusty_plate_pressure_plate", () -> new CustomPressurePlateBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.TERRACOTTA_ORANGE).noCollission().strength(1.5f, 6.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomRotatedPillarBlock> IRON_BEAM = INDUSTRIAL_BLOCK_REGISTRY.register("iron_beam", () -> new CustomRotatedPillarBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomRotatedPillarBlock> BOLTED_IRON_BEAM = INDUSTRIAL_BLOCK_REGISTRY.register("bolted_iron_beam", () -> new CustomRotatedPillarBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> IRON_BEAM_JUNCTION = INDUSTRIAL_BLOCK_REGISTRY.register("iron_beam_junction", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomRotatedPillarBlock> STEEL_BEAM = INDUSTRIAL_BLOCK_REGISTRY.register("steel_beam", () -> new CustomRotatedPillarBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomRotatedPillarBlock> BOLTED_STEEL_BEAM = INDUSTRIAL_BLOCK_REGISTRY.register("bolted_steel_beam", () -> new CustomRotatedPillarBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> STEEL_BEAM_JUNCTION = INDUSTRIAL_BLOCK_REGISTRY.register("steel_beam_junction", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> AIR_DUCT = INDUSTRIAL_BLOCK_REGISTRY.register("air_duct", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<AllRotationBlock> VENT_AIR_DUCT = INDUSTRIAL_BLOCK_REGISTRY.register("vent_air_duct", () -> new AllRotationBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<AllRotationBlock> GRID_AIR_DUCT = INDUSTRIAL_BLOCK_REGISTRY.register("grid_air_duct", () -> new AllRotationBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> BULKHEAD = INDUSTRIAL_BLOCK_REGISTRY.register("bulkhead", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.STONE).strength(0.8f).sound(SoundType.METAL).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomBlock> BULKHEAD_TOP = INDUSTRIAL_BLOCK_REGISTRY.register("bulkhead_top", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.STONE).strength(0.8f).sound(SoundType.METAL).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomLadderBlock> STEEL_WALL_LADDER = INDUSTRIAL_BLOCK_REGISTRY.register("steel_wall_ladder", () -> new CustomLadderBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).noOcclusion(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomLadderBlock> RUSTY_WALL_LADDER = INDUSTRIAL_BLOCK_REGISTRY.register("rusty_wall_ladder", () -> new CustomLadderBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).noOcclusion(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomLadderBlock> STEEL_RUNGS = INDUSTRIAL_BLOCK_REGISTRY.register("steel_rungs", () -> new CustomLadderBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).noOcclusion(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomLadderBlock> RUSTY_RUNGS = INDUSTRIAL_BLOCK_REGISTRY.register("rusty_rungs", () -> new CustomLadderBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.LANTERN).noOcclusion(), ToolTypes.PICKAXE));
    public static final DeferredBlock<SuspendedStairBlock> STEEL_SUSPENDED_STAIRS = INDUSTRIAL_BLOCK_REGISTRY.register("steel_suspended_stairs", () -> new SuspendedStairBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(3.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE, false));
    public static final DeferredBlock<SuspendedStairBlock> RUSTY_SUSPENDED_STAIRS = INDUSTRIAL_BLOCK_REGISTRY.register("rusty_suspended_stairs", () -> new SuspendedStairBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(3.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE, false));
    public static final DeferredBlock<SuspendedStairBlock> STEEL_LARGE_SUSPENDED_STAIRS = INDUSTRIAL_BLOCK_REGISTRY.register("steel_large_suspended_stairs", () -> new SuspendedStairBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(3.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE, true));
    public static final DeferredBlock<SuspendedStairBlock> RUSTY_LARGE_SUSPENDED_STAIRS = INDUSTRIAL_BLOCK_REGISTRY.register("rusty_large_suspended_stairs", () -> new SuspendedStairBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(3.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE, true));
    public static final DeferredBlock<CustomDoorBlock> STEEL_DOOR = INDUSTRIAL_BLOCK_REGISTRY.register("steel_door", () -> new CustomDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(3.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomDoorBlock> STURDY_STEEL_DOOR = INDUSTRIAL_BLOCK_REGISTRY.register("sturdy_steel_door", () -> new CustomDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(5.0f, 1200.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomDoorBlock> WARNING_STEEL_DOOR = INDUSTRIAL_BLOCK_REGISTRY.register("warning_steel_door", () -> new CustomDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(3.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomDoorBlock> WHITE_STEEL_DOOR = INDUSTRIAL_BLOCK_REGISTRY.register("white_steel_door", () -> new CustomDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(3.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomDoorBlock> STURDY_WHITE_STEEL_DOOR = INDUSTRIAL_BLOCK_REGISTRY.register("sturdy_white_steel_door", () -> new CustomDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(5.0f, 1200.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomDoorBlock> WARNING_WHITE_STEEL_DOOR = INDUSTRIAL_BLOCK_REGISTRY.register("warning_white_steel_door", () -> new CustomDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(3.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomDoorBlock> RUSTY_DOOR = INDUSTRIAL_BLOCK_REGISTRY.register("rusty_door", () -> new CustomDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(3.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomDoorBlock> STURDY_RUSTY_DOOR = INDUSTRIAL_BLOCK_REGISTRY.register("sturdy_rusty_door", () -> new CustomDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(5.0f, 1200.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
    public static final DeferredBlock<CustomDoorBlock> WARNING_RUSTY_DOOR = INDUSTRIAL_BLOCK_REGISTRY.register("warning_rusty_door", () -> new CustomDoorBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(3.0f).sound(SoundType.LANTERN).requiresCorrectToolForDrops(), ToolTypes.PICKAXE));
}

