/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.furniture.data;

import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import tv.mapper.embellishcraft.core.data.ECBlockStates;
import tv.mapper.embellishcraft.core.util.McWoods;
import tv.mapper.embellishcraft.furniture.block.CouchBlock;
import tv.mapper.embellishcraft.furniture.block.InitFurnitureBlocks;
import tv.mapper.embellishcraft.furniture.block.PlateBlock;
import tv.mapper.embellishcraft.furniture.block.TableBlock;

public class FurnitureBlockStates
extends ECBlockStates {
    public FurnitureBlockStates(PackOutput output, String modid, ExistingFileHelper exFileHelper, String name) {
        super(output, modid, exFileHelper, name);
    }

    @Override
    protected void registerStatesAndModels() {
        int j;
        for (j = 0; j < McWoods.values().length; ++j) {
            this.horizontalBlock((Block)InitFurnitureBlocks.CHAIR_BLOCKS.get((Object)McWoods.byId(j)).get(), (ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/" + McWoods.byId(j).getSerializedName() + "_chair"), 0);
            this.horizontalBlock((Block)InitFurnitureBlocks.TERRACE_CHAIR_BLOCKS.get((Object)McWoods.byId(j)).get(), (ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/" + McWoods.byId(j).getSerializedName() + "_terrace_chair"), 0);
            this.tableBlock((Block)InitFurnitureBlocks.TABLE_BLOCKS.get((Object)McWoods.byId(j)).get());
            this.tableBlock((Block)InitFurnitureBlocks.STURDY_TABLE_BLOCKS.get((Object)McWoods.byId(j)).get());
            this.simpleBlock((Block)InitFurnitureBlocks.TERRACE_TABLE_BLOCKS.get((Object)McWoods.byId(j)).get());
            this.simpleBlock((Block)InitFurnitureBlocks.WOODEN_CRATE_BLOCKS.get((Object)McWoods.byId(j)).get());
        }
        this.simpleBlock((Block)InitFurnitureBlocks.STEEL_TERRACE_TABLE.get());
        this.horizontalBlock((Block)InitFurnitureBlocks.STEEL_TERRACE_CHAIR.get(), (ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/steel_terrace_chair"), 0);
        for (j = 0; j < DyeColor.values().length; ++j) {
            this.couchBlock((CouchBlock)((Object)InitFurnitureBlocks.COUCH_BLOCKS.get(DyeColor.byId((int)j)).get()), 90);
            this.horizontalBlock((Block)InitFurnitureBlocks.PILLOW_BLOCKS.get(DyeColor.byId((int)j)).get(), (ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/" + DyeColor.byId((int)j).getSerializedName() + "_pillow"), 0);
        }
        this.plateBlock((Block)InitFurnitureBlocks.PLATE.get());
    }

    private void plateBlock(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (int i = 1; i < 9; ++i) {
            builder.partialState().with((Property)PlateBlock.PLATES, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/plate_" + i)).addModel();
        }
    }

    private void tableBlock(Block block) {
        String name = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)).getPath();
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/" + name + "_top")).addModel()).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/" + name + "_foot")).uvLock(true).addModel()).condition((Property)TableBlock.TABLE_NORTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/" + name + "_foot")).rotationY(90).uvLock(true).addModel()).condition((Property)TableBlock.TABLE_EAST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/" + name + "_foot")).rotationY(180).uvLock(true).addModel()).condition((Property)TableBlock.TABLE_SOUTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/" + name + "_foot")).rotationY(270).uvLock(true).addModel()).condition((Property)TableBlock.TABLE_WEST, (Comparable[])new Boolean[]{true}).end();
    }

    private void couchBlock(CouchBlock block, int offset) {
        String name = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)).getPath();
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/" + name + "_left")).rotationY((int)(dir.toYRot() + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition((Property)CouchBlock.LEFT_END, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/" + name + "_right")).rotationY((int)(dir.toYRot() + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition((Property)CouchBlock.RIGHT_END, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/" + name)).rotationY((int)(dir.toYRot() + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition(CouchBlock.SHAPE, (Comparable[])new StairsShape[]{StairsShape.STRAIGHT}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/outer_" + name)).rotationY((int)(dir.toYRot() + 270.0f + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition(CouchBlock.SHAPE, (Comparable[])new StairsShape[]{StairsShape.OUTER_LEFT}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/inner_" + name)).rotationY((int)(dir.toYRot() + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition(CouchBlock.SHAPE, (Comparable[])new StairsShape[]{StairsShape.INNER_LEFT}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/outer_" + name)).rotationY((int)(dir.toYRot() + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition(CouchBlock.SHAPE, (Comparable[])new StairsShape[]{StairsShape.OUTER_RIGHT}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile("embellishcraft:block/inner_" + name)).rotationY((int)(dir.toYRot() + 90.0f + (float)offset) % 360).uvLock(true).addModel()).condition((Property)CouchBlock.FACING, (Comparable[])new Direction[]{dir}).condition(CouchBlock.SHAPE, (Comparable[])new StairsShape[]{StairsShape.INNER_RIGHT}).end();
        }
    }
}

