/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.mapper.mapperbase.api.block.CustomBlock;
import tv.mapper.mapperbase.api.block.tools.ToolTiers;
import tv.mapper.mapperbase.api.block.tools.ToolTypes;

public class TableBlock
extends CustomBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty TABLE_NORTH = BooleanProperty.create((String)"table_north");
    public static final BooleanProperty TABLE_SOUTH = BooleanProperty.create((String)"table_south");
    public static final BooleanProperty TABLE_EAST = BooleanProperty.create((String)"table_east");
    public static final BooleanProperty TABLE_WEST = BooleanProperty.create((String)"table_west");
    public static final BooleanProperty HAS_FOOT = BooleanProperty.create((String)"has_foot");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape plate = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape leg_north = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0);
    protected static final VoxelShape leg_east = Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0);
    protected static final VoxelShape leg_west = Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0);
    protected static final VoxelShape leg_south = Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0);

    public TableBlock(BlockBehaviour.Properties properties, ToolTypes tool) {
        super(properties, tool);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TABLE_NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)TABLE_SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)TABLE_EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)TABLE_WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)HAS_FOOT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public TableBlock(BlockBehaviour.Properties properties, ToolTypes tool, ToolTiers tier) {
        super(properties, tool, tier);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TABLE_NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)TABLE_SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)TABLE_EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)TABLE_WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)HAS_FOOT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TABLE_NORTH, TABLE_SOUTH, TABLE_EAST, TABLE_WEST, HAS_FOOT, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape = plate;
        if (((Boolean)state.getValue((Property)TABLE_NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)leg_north);
        }
        if (((Boolean)state.getValue((Property)TABLE_SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)leg_south);
        }
        if (((Boolean)state.getValue((Property)TABLE_EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)leg_east);
        }
        if (((Boolean)state.getValue((Property)TABLE_WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)leg_west);
        }
        return shape;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level iblockreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockPos blockpos1 = blockpos.north();
        BlockPos blockpos2 = blockpos.east();
        BlockPos blockpos3 = blockpos.south();
        BlockPos blockpos4 = blockpos.west();
        BlockState state_north = iblockreader.getBlockState(blockpos1);
        BlockState state_east = iblockreader.getBlockState(blockpos2);
        BlockState state_south = iblockreader.getBlockState(blockpos3);
        BlockState state_west = iblockreader.getBlockState(blockpos4);
        boolean north = false;
        boolean south = false;
        boolean east = false;
        boolean west = false;
        boolean has_foot = false;
        if (TableBlock.isFaceFull((VoxelShape)iblockreader.getBlockState(blockpos.below()).getShape((BlockGetter)iblockreader, blockpos.below()), (Direction)Direction.UP)) {
            if (state_west.getBlock() != this) {
                west = true;
                north = true;
            }
            if (state_north.getBlock() != this) {
                north = true;
                east = true;
            }
            if (state_east.getBlock() != this) {
                east = true;
                south = true;
            }
            if (state_south.getBlock() != this) {
                south = true;
                west = true;
            }
            if (north || south || east || west) {
                has_foot = true;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)TABLE_NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)TABLE_SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)TABLE_EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)TABLE_WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)HAS_FOOT, (Comparable)Boolean.valueOf(has_foot))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        LevelAccessor iblockreader = worldIn;
        BlockPos blockpos1 = currentPos.north();
        BlockPos blockpos2 = currentPos.east();
        BlockPos blockpos3 = currentPos.south();
        BlockPos blockpos4 = currentPos.west();
        BlockState state_north = iblockreader.getBlockState(blockpos1);
        BlockState state_east = iblockreader.getBlockState(blockpos2);
        BlockState state_south = iblockreader.getBlockState(blockpos3);
        BlockState state_west = iblockreader.getBlockState(blockpos4);
        boolean north = true;
        boolean south = true;
        boolean east = true;
        boolean west = true;
        boolean has_foot = false;
        if (state_west.getBlock() == this) {
            west = false;
            north = false;
        }
        if (state_north.getBlock() == this) {
            north = false;
            east = false;
        }
        if (state_east.getBlock() == this) {
            east = false;
            south = false;
        }
        if (state_south.getBlock() == this) {
            south = false;
            west = false;
        }
        if (north || south || east || west) {
            has_foot = true;
        }
        if (!TableBlock.isFaceFull((VoxelShape)iblockreader.getBlockState(currentPos.below()).getShape((BlockGetter)iblockreader, currentPos.below()), (Direction)Direction.UP)) {
            north = false;
            south = false;
            east = false;
            west = false;
            has_foot = false;
        }
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TABLE_NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)TABLE_SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)TABLE_EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)TABLE_WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)HAS_FOOT, (Comparable)Boolean.valueOf(has_foot))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)stateIn.getValue((Property)WATERLOGGED)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

