/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.mapper.embellishcraft.furniture.block.InitFurnitureBlocks;
import tv.mapper.embellishcraft.furniture.item.InitFurnitureItems;
import tv.mapper.mapperbase.api.block.CustomBlock;
import tv.mapper.mapperbase.api.block.tools.ToolTiers;
import tv.mapper.mapperbase.api.block.tools.ToolTypes;

public class PlateBlock
extends CustomBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty PLATES = IntegerProperty.create((String)"plates", (int)1, (int)8);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    VoxelShape plate_1 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    VoxelShape plate_2 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    VoxelShape plate_3 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    VoxelShape plate_4 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    VoxelShape plate_5 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    VoxelShape plate_6 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    VoxelShape plate_7 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    VoxelShape plate_8 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public PlateBlock(BlockBehaviour.Properties properties, ToolTypes tool) {
        super(properties, tool);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PLATES, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public PlateBlock(BlockBehaviour.Properties properties, ToolTypes tool, ToolTiers tier) {
        super(properties, tool, tier);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PLATES, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Integer)state.getValue((Property)PLATES)) {
            case 1: {
                return this.plate_1;
            }
            case 2: {
                return this.plate_2;
            }
            case 3: {
                return this.plate_3;
            }
            case 4: {
                return this.plate_4;
            }
            case 5: {
                return this.plate_5;
            }
            case 6: {
                return this.plate_6;
            }
            case 7: {
                return this.plate_7;
            }
            case 8: {
                return this.plate_8;
            }
        }
        return this.plate_1;
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.isShiftKeyDown() && (Integer)state.getValue((Property)PLATES) < 8) {
            ItemStack stack = ItemStack.EMPTY;
            if (player.getMainHandItem().getItem() == InitFurnitureItems.PLATE_ITEM.get()) {
                stack = player.getMainHandItem();
            } else if (player.getOffhandItem().getItem() == InitFurnitureItems.PLATE_ITEM.get()) {
                stack = player.getOffhandItem();
            }
            if (stack.getItem() == InitFurnitureItems.PLATE_ITEM.get()) {
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PLATES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PLATES) + 1)));
                if (!worldIn.isClientSide) {
                    worldIn.playSound(null, pos, SoundEvents.GLASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (!player.isCreative()) {
                    stack.setCount(stack.getCount() - 1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (player.isShiftKeyDown() && (Integer)state.getValue((Property)PLATES) > 0) {
            if ((Integer)state.getValue((Property)PLATES) == 1) {
                worldIn.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            } else {
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PLATES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PLATES) - 1)));
            }
            if (!worldIn.isClientSide) {
                worldIn.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!player.isCreative()) {
                ItemStack drop = new ItemStack((ItemLike)InitFurnitureBlocks.PLATE.get());
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)drop);
            }
        }
        return InteractionResult.FAIL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PLATES, WATERLOGGED});
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = worldIn.getBlockState(blockpos);
        if (blockstate.getBlock() instanceof PlateBlock && (Integer)blockstate.getValue((Property)PLATES) == 8) {
            return true;
        }
        return PlateBlock.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN && !this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

