/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.furniture.block;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.tuple.Pair;
import tv.mapper.embellishcraft.core.util.McWoods;
import tv.mapper.embellishcraft.furniture.block.ChairBlock;
import tv.mapper.embellishcraft.furniture.block.CouchBlock;
import tv.mapper.embellishcraft.furniture.block.PillowBlock;
import tv.mapper.embellishcraft.furniture.block.PlateBlock;
import tv.mapper.embellishcraft.furniture.block.SturdyTableBlock;
import tv.mapper.embellishcraft.furniture.block.TableBlock;
import tv.mapper.embellishcraft.furniture.block.TerraceChairBlock;
import tv.mapper.embellishcraft.furniture.block.TerraceTableBlock;
import tv.mapper.mapperbase.api.block.CustomBlock;
import tv.mapper.mapperbase.api.block.tools.ToolTypes;

public class InitFurnitureBlocks {
    public static final DeferredRegister.Blocks FURNITURE_BLOCK_REGISTRY = DeferredRegister.createBlocks((String)"embellishcraft");
    public static final Map<McWoods, DeferredBlock<ChairBlock>> CHAIR_BLOCKS = Arrays.stream(McWoods.values()).map(type -> Pair.of((Object)type, (Object)FURNITURE_BLOCK_REGISTRY.register(type.getSerializedName() + "_chair", () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).mapColor(MapColor.WOOD).strength(0.75f, 0.5f).sound(SoundType.WOOD), ToolTypes.AXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<McWoods, DeferredBlock<TerraceChairBlock>> TERRACE_CHAIR_BLOCKS = Arrays.stream(McWoods.values()).map(type -> Pair.of((Object)type, (Object)FURNITURE_BLOCK_REGISTRY.register(type.getSerializedName() + "_terrace_chair", () -> new TerraceChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).mapColor(MapColor.WOOD).strength(0.75f, 0.5f).sound(SoundType.WOOD), ToolTypes.AXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<McWoods, DeferredBlock<TableBlock>> TABLE_BLOCKS = Arrays.stream(McWoods.values()).map(type -> Pair.of((Object)type, (Object)FURNITURE_BLOCK_REGISTRY.register(type.getSerializedName() + "_table", () -> new TableBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).mapColor(MapColor.WOOD).strength(0.75f, 0.5f).sound(SoundType.WOOD), ToolTypes.AXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<McWoods, DeferredBlock<SturdyTableBlock>> STURDY_TABLE_BLOCKS = Arrays.stream(McWoods.values()).map(type -> Pair.of((Object)type, (Object)FURNITURE_BLOCK_REGISTRY.register(type.getSerializedName() + "_sturdy_table", () -> new SturdyTableBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).mapColor(MapColor.WOOD).strength(0.75f, 0.5f).sound(SoundType.WOOD), ToolTypes.AXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<McWoods, DeferredBlock<TerraceTableBlock>> TERRACE_TABLE_BLOCKS = Arrays.stream(McWoods.values()).map(type -> Pair.of((Object)type, (Object)FURNITURE_BLOCK_REGISTRY.register(type.getSerializedName() + "_terrace_table", () -> new TerraceTableBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).mapColor(MapColor.WOOD).strength(0.75f, 0.5f).sound(SoundType.WOOD), ToolTypes.AXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final DeferredBlock<TerraceTableBlock> STEEL_TERRACE_TABLE = FURNITURE_BLOCK_REGISTRY.register("steel_terrace_table", () -> new TerraceTableBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.75f, 0.5f).sound(SoundType.LANTERN), ToolTypes.PICKAXE));
    public static final DeferredBlock<TerraceChairBlock> STEEL_TERRACE_CHAIR = FURNITURE_BLOCK_REGISTRY.register("steel_terrace_chair", () -> new TerraceChairBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(MapColor.METAL).strength(0.75f, 0.5f).sound(SoundType.LANTERN), ToolTypes.PICKAXE));
    public static final Map<DyeColor, DeferredBlock<CouchBlock>> COUCH_BLOCKS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)FURNITURE_BLOCK_REGISTRY.register(type.getSerializedName() + "_couch", () -> new CouchBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).mapColor(type.getMapColor()).strength(1.5f, 6.0f).sound(SoundType.WOOL), ToolTypes.AXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final DeferredBlock<PlateBlock> PLATE = FURNITURE_BLOCK_REGISTRY.register("plate", () -> new PlateBlock(BlockBehaviour.Properties.of().sound(SoundType.GLASS).mapColor(MapColor.QUARTZ).strength(0.25f).sound(SoundType.GLASS), ToolTypes.NONE));
    public static final Map<DyeColor, DeferredBlock<PillowBlock>> PILLOW_BLOCKS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)FURNITURE_BLOCK_REGISTRY.register(type.getSerializedName() + "_pillow", () -> new PillowBlock((DyeColor)type, BlockBehaviour.Properties.of().sound(SoundType.WOOL).mapColor(type.getMapColor()).strength(0.25f).sound(SoundType.WOOL))))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static final Map<McWoods, DeferredBlock<CustomBlock>> WOODEN_CRATE_BLOCKS = Arrays.stream(McWoods.values()).map(type -> Pair.of((Object)type, (Object)FURNITURE_BLOCK_REGISTRY.register(type.getSerializedName() + "_wooden_crate", () -> new CustomBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).mapColor(MapColor.WOOD).strength(0.5f).sound(SoundType.WOOD), ToolTypes.AXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));

    public static void postInit() {
    }
}

