/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.furniture.block;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.mapper.embellishcraft.furniture.block.SittableBlock;
import tv.mapper.mapperbase.api.block.tools.ToolTiers;
import tv.mapper.mapperbase.api.block.tools.ToolTypes;

public class CouchBlock
extends SittableBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    public static final BooleanProperty LEFT_END = BooleanProperty.create((String)"left_end");
    public static final BooleanProperty RIGHT_END = BooleanProperty.create((String)"right_end");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SLAB_BOTTOM = Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SWU_CORNER = Block.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SEU_CORNER = Block.box((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = CouchBlock.makeShapes(SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> CouchBlock.combineShapes(p_199780_5_, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = Shapes.or((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    public CouchBlock(BlockBehaviour.Properties properties, ToolTypes tool) {
        super(properties, tool);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)LEFT_END, (Comparable)Boolean.valueOf(true))).setValue((Property)RIGHT_END, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public CouchBlock(BlockBehaviour.Properties properties, ToolTypes tool, ToolTiers tier) {
        super(properties, tool, tier);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)LEFT_END, (Comparable)Boolean.valueOf(true))).setValue((Property)RIGHT_END, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SLAB_BOTTOM_SHAPES[SHAPE_BY_STATE[this.getCouchShape(state)]];
    }

    private int getCouchShape(BlockState state) {
        return ((StairsShape)state.getValue(SHAPE)).ordinal() * 4 + ((Direction)state.getValue((Property)FACING)).get2DDataValue();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.isEmptyBlock(pos.below());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level iblockreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        FluidState ifluidstate = context.getLevel().getFluidState(blockpos);
        boolean leftend = true;
        boolean rightend = true;
        Direction facing = context.getHorizontalDirection();
        StairsShape shape = CouchBlock.getShapeProperty((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing), (BlockGetter)context.getLevel(), blockpos);
        if (shape == StairsShape.STRAIGHT) {
            BlockState leftstate;
            BlockState rightstate = switch (facing) {
                case Direction.NORTH -> {
                    leftstate = iblockreader.getBlockState(blockpos.west());
                    yield iblockreader.getBlockState(blockpos.east());
                }
                case Direction.SOUTH -> {
                    leftstate = iblockreader.getBlockState(blockpos.east());
                    yield iblockreader.getBlockState(blockpos.west());
                }
                case Direction.EAST -> {
                    leftstate = iblockreader.getBlockState(blockpos.north());
                    yield iblockreader.getBlockState(blockpos.south());
                }
                case Direction.WEST -> {
                    leftstate = iblockreader.getBlockState(blockpos.south());
                    yield iblockreader.getBlockState(blockpos.north());
                }
                default -> {
                    leftstate = iblockreader.getBlockState(blockpos.west());
                    yield iblockreader.getBlockState(blockpos.east());
                }
            };
            if (leftstate.getBlock() instanceof CouchBlock) {
                leftend = false;
            }
            if (rightstate.getBlock() instanceof CouchBlock) {
                rightend = false;
            }
        } else {
            leftend = false;
            rightend = false;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)shape)).setValue((Property)FACING, (Comparable)facing)).setValue((Property)LEFT_END, (Comparable)Boolean.valueOf(leftend))).setValue((Property)RIGHT_END, (Comparable)Boolean.valueOf(rightend))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState blockstate = worldIn.getBlockState(pos.relative(direction));
        if (CouchBlock.isCouchBlock(blockstate) && (direction1 = (Direction)blockstate.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && CouchBlock.isDifferentCouch(state, worldIn, pos, direction1.getOpposite())) {
            if (direction1 == direction.getCounterClockWise()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.getBlockState(pos.relative(direction.getOpposite()));
        if (CouchBlock.isCouchBlock(blockstate1) && (direction2 = (Direction)blockstate1.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && CouchBlock.isDifferentCouch(state, worldIn, pos, direction2)) {
            if (direction2 == direction.getCounterClockWise()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        boolean rightend;
        boolean leftend;
        StairsShape shape = (StairsShape)stateIn.getValue(SHAPE);
        Direction direction = (Direction)stateIn.getValue((Property)FACING);
        if (facing.getAxis().isHorizontal()) {
            shape = CouchBlock.getShapeProperty(stateIn, (BlockGetter)worldIn, currentPos);
        }
        if (shape == StairsShape.STRAIGHT) {
            BlockState leftstate;
            BlockState rightstate = switch (direction) {
                case Direction.NORTH -> {
                    leftstate = worldIn.getBlockState(currentPos.west());
                    yield worldIn.getBlockState(currentPos.east());
                }
                case Direction.SOUTH -> {
                    leftstate = worldIn.getBlockState(currentPos.east());
                    yield worldIn.getBlockState(currentPos.west());
                }
                case Direction.EAST -> {
                    leftstate = worldIn.getBlockState(currentPos.north());
                    yield worldIn.getBlockState(currentPos.south());
                }
                case Direction.WEST -> {
                    leftstate = worldIn.getBlockState(currentPos.south());
                    yield worldIn.getBlockState(currentPos.north());
                }
                default -> {
                    leftstate = worldIn.getBlockState(currentPos.west());
                    yield worldIn.getBlockState(currentPos.east());
                }
            };
            leftend = !(leftstate.getBlock() instanceof CouchBlock);
            rightend = !(rightstate.getBlock() instanceof CouchBlock);
        } else {
            leftend = false;
            rightend = false;
        }
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN && !this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return facing.getAxis().isHorizontal() ? (BlockState)((BlockState)((BlockState)stateIn.setValue(SHAPE, (Comparable)shape)).setValue((Property)LEFT_END, (Comparable)Boolean.valueOf(leftend))).setValue((Property)RIGHT_END, (Comparable)Boolean.valueOf(rightend)) : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static boolean isDifferentCouch(BlockState state, BlockGetter worldIn, BlockPos pos, Direction face) {
        BlockState blockstate = worldIn.getBlockState(pos.relative(face));
        return !CouchBlock.isCouchBlock(blockstate) || blockstate.getValue((Property)FACING) != state.getValue((Property)FACING);
    }

    public static boolean isCouchBlock(BlockState state) {
        return state.getBlock() instanceof CouchBlock;
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.getValue(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.rotate(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.rotate(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.mirror(state, mirrorIn);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SHAPE, LEFT_END, RIGHT_END, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }
}

