/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.mapper.embellishcraft.furniture.block.SittableBlock;
import tv.mapper.mapperbase.api.block.tools.ToolTiers;
import tv.mapper.mapperbase.api.block.tools.ToolTypes;

public class ChairBlock
extends SittableBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape SOUTH_LEFT_FRONT_LEG = Block.box((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)7.0, (double)13.0);
    private static final VoxelShape SOUTH_RIGHT_FRONT_LEG = Block.box((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)7.0, (double)13.0);
    private static final VoxelShape SOUTH_LEFT_BACK_LEG = Block.box((double)11.0, (double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)4.0);
    private static final VoxelShape SOUTH_RIGHT_BACK_LEG = Block.box((double)3.0, (double)0.0, (double)2.0, (double)5.0, (double)16.0, (double)4.0);
    private static final VoxelShape SOUTH_SIT = Block.box((double)3.0, (double)7.0, (double)4.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SOUTH_BACK = Block.box((double)5.0, (double)12.0, (double)3.0, (double)11.0, (double)14.0, (double)4.0);
    private static final VoxelShape SOUTH_CHAIR_AABB = Shapes.or((VoxelShape)SOUTH_LEFT_FRONT_LEG, (VoxelShape)Shapes.or((VoxelShape)SOUTH_RIGHT_FRONT_LEG, (VoxelShape)Shapes.or((VoxelShape)SOUTH_LEFT_BACK_LEG, (VoxelShape)Shapes.or((VoxelShape)SOUTH_SIT, (VoxelShape)Shapes.or((VoxelShape)SOUTH_BACK, (VoxelShape)SOUTH_RIGHT_BACK_LEG)))));
    private static final VoxelShape SOUTH_COL_BACK = Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)4.0);
    private static final VoxelShape SOUTH_COL_SIT = Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SOUTH_COL = Shapes.or((VoxelShape)SOUTH_COL_BACK, (VoxelShape)SOUTH_COL_SIT);
    private static final VoxelShape WEST_LEFT_FRONT_LEG = Block.box((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)7.0, (double)13.0);
    private static final VoxelShape WEST_RIGHT_FRONT_LEG = Block.box((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)7.0, (double)5.0);
    private static final VoxelShape WEST_LEFT_BACK_LEG = Block.box((double)12.0, (double)0.0, (double)11.0, (double)14.0, (double)16.0, (double)13.0);
    private static final VoxelShape WEST_RIGHT_BACK_LEG = Block.box((double)12.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0, (double)5.0);
    private static final VoxelShape WEST_SIT = Block.box((double)3.0, (double)7.0, (double)3.0, (double)12.0, (double)8.0, (double)13.0);
    private static final VoxelShape WEST_BACK = Block.box((double)12.0, (double)12.0, (double)5.0, (double)13.0, (double)14.0, (double)11.0);
    private static final VoxelShape WEST_CHAIR_AABB = Shapes.or((VoxelShape)WEST_LEFT_FRONT_LEG, (VoxelShape)Shapes.or((VoxelShape)WEST_RIGHT_FRONT_LEG, (VoxelShape)Shapes.or((VoxelShape)WEST_LEFT_BACK_LEG, (VoxelShape)Shapes.or((VoxelShape)WEST_SIT, (VoxelShape)Shapes.or((VoxelShape)WEST_BACK, (VoxelShape)WEST_RIGHT_BACK_LEG)))));
    private static final VoxelShape WEST_COL_BACK = Block.box((double)12.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0);
    private static final VoxelShape WEST_COL_SIT = Block.box((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)8.0, (double)13.0);
    private static final VoxelShape WEST_COL = Shapes.or((VoxelShape)WEST_COL_BACK, (VoxelShape)WEST_COL_SIT);
    private static final VoxelShape NORTH_LEFT_FRONT_LEG = Block.box((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)7.0, (double)5.0);
    private static final VoxelShape NORTH_RIGHT_FRONT_LEG = Block.box((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)5.0);
    private static final VoxelShape NORTH_LEFT_BACK_LEG = Block.box((double)3.0, (double)0.0, (double)12.0, (double)5.0, (double)16.0, (double)14.0);
    private static final VoxelShape NORTH_RIGHT_BACK_LEG = Block.box((double)11.0, (double)0.0, (double)12.0, (double)13.0, (double)16.0, (double)14.0);
    private static final VoxelShape NORTH_SIT = Block.box((double)3.0, (double)7.0, (double)3.0, (double)13.0, (double)8.0, (double)12.0);
    private static final VoxelShape NORTH_BACK = Block.box((double)5.0, (double)12.0, (double)12.0, (double)11.0, (double)14.0, (double)13.0);
    private static final VoxelShape NORTH_CHAIR_AABB = Shapes.or((VoxelShape)NORTH_LEFT_FRONT_LEG, (VoxelShape)Shapes.or((VoxelShape)NORTH_RIGHT_FRONT_LEG, (VoxelShape)Shapes.or((VoxelShape)NORTH_LEFT_BACK_LEG, (VoxelShape)Shapes.or((VoxelShape)NORTH_SIT, (VoxelShape)Shapes.or((VoxelShape)NORTH_BACK, (VoxelShape)NORTH_RIGHT_BACK_LEG)))));
    private static final VoxelShape NORTH_COL_BACK = Block.box((double)3.0, (double)0.0, (double)12.0, (double)13.0, (double)16.0, (double)14.0);
    private static final VoxelShape NORTH_COL_SIT = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)12.0);
    private static final VoxelShape NORTH_COL = Shapes.or((VoxelShape)NORTH_COL_BACK, (VoxelShape)NORTH_COL_SIT);
    private static final VoxelShape EAST_LEFT_FRONT_LEG = Block.box((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)5.0);
    private static final VoxelShape EAST_RIGHT_FRONT_LEG = Block.box((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)7.0, (double)13.0);
    private static final VoxelShape EAST_LEFT_BACK_LEG = Block.box((double)2.0, (double)0.0, (double)3.0, (double)4.0, (double)16.0, (double)5.0);
    private static final VoxelShape EAST_RIGHT_BACK_LEG = Block.box((double)2.0, (double)0.0, (double)11.0, (double)4.0, (double)16.0, (double)13.0);
    private static final VoxelShape EAST_SIT = Block.box((double)4.0, (double)7.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape EAST_BACK = Block.box((double)3.0, (double)12.0, (double)5.0, (double)4.0, (double)14.0, (double)11.0);
    private static final VoxelShape EAST_CHAIR_AABB = Shapes.or((VoxelShape)EAST_LEFT_FRONT_LEG, (VoxelShape)Shapes.or((VoxelShape)EAST_RIGHT_FRONT_LEG, (VoxelShape)Shapes.or((VoxelShape)EAST_LEFT_BACK_LEG, (VoxelShape)Shapes.or((VoxelShape)EAST_SIT, (VoxelShape)Shapes.or((VoxelShape)EAST_BACK, (VoxelShape)EAST_RIGHT_BACK_LEG)))));
    private static final VoxelShape EAST_COL_BACK = Block.box((double)2.0, (double)0.0, (double)3.0, (double)4.0, (double)16.0, (double)13.0);
    private static final VoxelShape EAST_COL_SIT = Block.box((double)4.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape EAST_COL = Shapes.or((VoxelShape)EAST_COL_BACK, (VoxelShape)EAST_COL_SIT);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public ChairBlock(BlockBehaviour.Properties properties, ToolTypes tool) {
        super(properties, tool);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ChairBlock(BlockBehaviour.Properties properties, ToolTypes tool, ToolTiers tier) {
        super(properties, tool, tier);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return NORTH_CHAIR_AABB;
            }
            case SOUTH: {
                return SOUTH_CHAIR_AABB;
            }
            case WEST: {
                return WEST_CHAIR_AABB;
            }
            case EAST: {
                return EAST_CHAIR_AABB;
            }
        }
        return SOUTH_CHAIR_AABB;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return NORTH_COL;
            }
            case SOUTH: {
                return SOUTH_COL;
            }
            case WEST: {
                return WEST_COL;
            }
            case EAST: {
                return EAST_COL;
            }
        }
        return SOUTH_COL;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.isEmptyBlock(pos.below());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN && !this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        FluidState ifluidstate = context.getLevel().getFluidState(blockpos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }
}

