/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.core.data.tags;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;
import tv.mapper.embellishcraft.building.block.InitBuildingBlocks;
import tv.mapper.embellishcraft.building.block.SuspendedStairBlock;
import tv.mapper.embellishcraft.core.data.tags.ECTags;
import tv.mapper.embellishcraft.core.util.RockType;
import tv.mapper.embellishcraft.furniture.block.ChairBlock;
import tv.mapper.embellishcraft.furniture.block.CouchBlock;
import tv.mapper.embellishcraft.furniture.block.InitFurnitureBlocks;
import tv.mapper.embellishcraft.furniture.block.TableBlock;
import tv.mapper.embellishcraft.furniture.block.TerraceChairBlock;
import tv.mapper.embellishcraft.furniture.block.TerraceTableBlock;
import tv.mapper.embellishcraft.industrial.block.InitIndustrialBlocks;
import tv.mapper.embellishcraft.lights.block.InitLightBlocks;
import tv.mapper.embellishcraft.rocks.block.InitRockBlocks;
import tv.mapper.mapperbase.api.block.CustomButtonBlock;
import tv.mapper.mapperbase.api.block.CustomLadderBlock;
import tv.mapper.mapperbase.api.data.tags.BaseBlockTagsProvider;

public class ECBlockTags
extends BaseBlockTagsProvider {
    public ECBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, modid, existingFileHelper);
    }

    public void addTags(HolderLookup.Provider pProvider) {
        for (DeferredHolder object : InitRockBlocks.ROCK_BLOCK_REGISTRY.getEntries()) {
            this.addTagsFromBlockType((Block)object.get());
            if (!(object.get() instanceof PressurePlateBlock)) continue;
            this.tag(BlockTags.STONE_PRESSURE_PLATES).add((Object)((Block)object.get()));
        }
        for (DeferredHolder object : InitIndustrialBlocks.INDUSTRIAL_BLOCK_REGISTRY.getEntries()) {
            this.addTagsFromBlockType((Block)object.get());
        }
        for (DeferredHolder object : InitBuildingBlocks.BUILDING_BLOCK_REGISTRY.getEntries()) {
            this.addTagsFromBlockType((Block)object.get());
        }
        for (DeferredHolder object : InitFurnitureBlocks.FURNITURE_BLOCK_REGISTRY.getEntries()) {
            this.addTagsFromBlockType((Block)object.get());
        }
        for (DeferredHolder object : InitLightBlocks.LIGHT_BLOCK_REGISTRY.getEntries()) {
            this.addTagsFromBlockType((Block)object.get());
        }
        this.registerToolTags((DeferredRegister)InitRockBlocks.ROCK_BLOCK_REGISTRY);
        this.registerToolTags((DeferredRegister)InitIndustrialBlocks.INDUSTRIAL_BLOCK_REGISTRY);
        this.registerToolTags((DeferredRegister)InitBuildingBlocks.BUILDING_BLOCK_REGISTRY);
        this.registerToolTags((DeferredRegister)InitFurnitureBlocks.FURNITURE_BLOCK_REGISTRY);
        this.registerToolTags((DeferredRegister)InitLightBlocks.LIGHT_BLOCK_REGISTRY);
        int j = 0;
        while ((long)j < Arrays.stream(RockType.values()).count()) {
            this.tag(Tags.Blocks.STONES).add((Object)((Block)InitRockBlocks.ROCK_BLOCKS.get((Object)RockType.byId(j)).get()));
            this.tag(BlockTags.BASE_STONE_OVERWORLD).add((Object)((Block)InitRockBlocks.ROCK_BLOCKS.get((Object)RockType.byId(j)).get()));
            this.tag(BlockTags.STONE_BUTTONS).add((Object)((Block)InitRockBlocks.ROCK_BUTTONS.get((Object)RockType.byId(j)).get()));
            this.tag(Tags.Blocks.COBBLESTONES).add((Object)((Block)InitRockBlocks.ROCK_COBBLESTONES.get((Object)RockType.byId(j)).get()));
            ++j;
        }
        this.tag(BlockTags.STONE_BUTTONS).add((Object[])new Block[]{(Block)InitRockBlocks.ANDESITE_BUTTON.get(), (Block)InitRockBlocks.GRANITE_BUTTON.get(), (Block)InitRockBlocks.DIORITE_BUTTON.get(), (Block)InitRockBlocks.SANDSTONE_BUTTON.get(), (Block)InitRockBlocks.RED_SANDSTONE_BUTTON.get(), (Block)InitRockBlocks.TERRACOTTA_BUTTON.get()});
        this.tag(Tags.Blocks.SANDSTONE_BLOCKS).add((Object[])new Block[]{(Block)InitRockBlocks.POLISHED_SANDSTONE.get(), (Block)InitRockBlocks.SANDSTONE_PAVING.get(), (Block)InitRockBlocks.SANDSTONE_TILES.get(), (Block)InitRockBlocks.SANDSTONE_BRICKS.get(), (Block)InitRockBlocks.SANDSTONE_LARGE_BRICKS.get(), (Block)InitRockBlocks.SANDSTONE_PAVING_STONES.get(), (Block)InitRockBlocks.SANDSTONE_ROOFTILES.get(), (Block)InitRockBlocks.POLISHED_RED_SANDSTONE.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING.get(), (Block)InitRockBlocks.RED_SANDSTONE_TILES.get(), (Block)InitRockBlocks.RED_SANDSTONE_BRICKS.get(), (Block)InitRockBlocks.RED_SANDSTONE_LARGE_BRICKS.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING_STONES.get(), (Block)InitRockBlocks.RED_SANDSTONE_ROOFTILES.get()});
        this.tag(Tags.Blocks.SANDSTONE_STAIRS).add((Object[])new Block[]{(Block)InitRockBlocks.POLISHED_SANDSTONE_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_PAVING_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_TILES_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_BRICKS_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_LARGE_BRICKS_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_PAVING_STONES_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_ROOFTILES_STAIRS.get(), (Block)InitRockBlocks.POLISHED_RED_SANDSTONE_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_TILES_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_BRICKS_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_LARGE_BRICKS_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING_STONES_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_ROOFTILES_STAIRS.get()});
        this.tag(Tags.Blocks.SANDSTONE_SLABS).add((Object[])new Block[]{(Block)InitRockBlocks.POLISHED_SANDSTONE_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_PAVING_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_TILES_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_BRICKS_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_LARGE_BRICKS_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_PAVING_STONES_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_ROOFTILES_SLAB.get(), (Block)InitRockBlocks.POLISHED_RED_SANDSTONE_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_TILES_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_BRICKS_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_LARGE_BRICKS_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING_STONES_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_ROOFTILES_SLAB.get()});
        this.tag(Tags.Blocks.SANDSTONE_UNCOLORED_BLOCKS).add((Object[])new Block[]{(Block)InitRockBlocks.POLISHED_SANDSTONE.get(), (Block)InitRockBlocks.SANDSTONE_PAVING.get(), (Block)InitRockBlocks.SANDSTONE_TILES.get(), (Block)InitRockBlocks.SANDSTONE_BRICKS.get(), (Block)InitRockBlocks.SANDSTONE_LARGE_BRICKS.get(), (Block)InitRockBlocks.SANDSTONE_PAVING_STONES.get(), (Block)InitRockBlocks.SANDSTONE_ROOFTILES.get()});
        this.tag(Tags.Blocks.SANDSTONE_UNCOLORED_STAIRS).add((Object[])new Block[]{(Block)InitRockBlocks.POLISHED_SANDSTONE_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_PAVING_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_TILES_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_BRICKS_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_LARGE_BRICKS_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_PAVING_STONES_STAIRS.get(), (Block)InitRockBlocks.SANDSTONE_ROOFTILES_STAIRS.get()});
        this.tag(Tags.Blocks.SANDSTONE_UNCOLORED_SLABS).add((Object[])new Block[]{(Block)InitRockBlocks.POLISHED_SANDSTONE_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_PAVING_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_TILES_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_BRICKS_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_LARGE_BRICKS_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_PAVING_STONES_SLAB.get(), (Block)InitRockBlocks.SANDSTONE_ROOFTILES_SLAB.get()});
        this.tag(Tags.Blocks.SANDSTONE_RED_BLOCKS).add((Object[])new Block[]{(Block)InitRockBlocks.POLISHED_RED_SANDSTONE.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING.get(), (Block)InitRockBlocks.RED_SANDSTONE_TILES.get(), (Block)InitRockBlocks.RED_SANDSTONE_BRICKS.get(), (Block)InitRockBlocks.RED_SANDSTONE_LARGE_BRICKS.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING_STONES.get(), (Block)InitRockBlocks.RED_SANDSTONE_ROOFTILES.get()});
        this.tag(Tags.Blocks.SANDSTONE_RED_STAIRS).add((Object[])new Block[]{(Block)InitRockBlocks.POLISHED_RED_SANDSTONE_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_TILES_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_BRICKS_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_LARGE_BRICKS_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING_STONES_STAIRS.get(), (Block)InitRockBlocks.RED_SANDSTONE_ROOFTILES_STAIRS.get()});
        this.tag(Tags.Blocks.SANDSTONE_RED_SLABS).add((Object[])new Block[]{(Block)InitRockBlocks.POLISHED_RED_SANDSTONE_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_TILES_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_BRICKS_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_LARGE_BRICKS_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_PAVING_STONES_SLAB.get(), (Block)InitRockBlocks.RED_SANDSTONE_ROOFTILES_SLAB.get()});
        this.tag(BlockTags.FENCES).addTag(Tags.Blocks.FENCES);
        this.tag(BlockTags.WOODEN_DOORS).addTag(ECTags.Blocks.WOODEN_DOORS);
        this.tag(ECTags.Blocks.DOORS).addTag(ECTags.Blocks.WOODEN_DOORS);
        this.tag(BlockTags.DOORS).addTag(ECTags.Blocks.DOORS);
        this.tag(BlockTags.FENCE_GATES).addTag(Tags.Blocks.FENCE_GATES);
    }

    protected void addTagsFromBlockType(Block block) {
        if (block instanceof WallBlock) {
            this.tag(BlockTags.WALLS).add((Object)block);
        } else if (block instanceof SlabBlock) {
            this.tag(BlockTags.SLABS).add((Object)block);
        } else if (block instanceof StairBlock) {
            this.tag(BlockTags.STAIRS).add((Object)block);
        } else if (block instanceof PressurePlateBlock) {
            this.tag(BlockTags.PRESSURE_PLATES).add((Object)block);
        } else if (block instanceof CustomButtonBlock) {
            this.tag(BlockTags.BUTTONS).add((Object)block);
        } else if (block instanceof FenceBlock) {
            this.tag(Tags.Blocks.FENCES).add((Object)block);
        } else if (block instanceof FenceGateBlock) {
            this.tag(Tags.Blocks.FENCE_GATES).add((Object)block);
        } else if (block instanceof CouchBlock) {
            this.tag(ECTags.Blocks.COUCHES).add((Object)block);
        } else if (block instanceof CustomLadderBlock) {
            this.tag(BlockTags.CLIMBABLE).add((Object)block);
        } else if (block instanceof ChairBlock || block instanceof TerraceChairBlock) {
            this.tag(ECTags.CommonBlocks.CHAIRS).add((Object)block);
        } else if (block instanceof TableBlock || block instanceof TerraceTableBlock) {
            this.tag(ECTags.CommonBlocks.TABLES).add((Object)block);
        } else if (block instanceof SuspendedStairBlock) {
            this.tag(ECTags.Blocks.SUSPENDED_STAIRS).add((Object)block);
        } else if (block instanceof DoorBlock) {
            if (block.defaultBlockState().getSoundType() == SoundType.WOOD) {
                this.tag(ECTags.Blocks.WOODEN_DOORS).add((Object)block);
            }
            this.tag(ECTags.Blocks.DOORS).add((Object)block);
        }
    }
}

