/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.core.data;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import tv.mapper.embellishcraft.building.block.InitBuildingBlocks;
import tv.mapper.embellishcraft.building.data.BuildingBlockModels;
import tv.mapper.embellishcraft.building.data.BuildingBlockStates;
import tv.mapper.embellishcraft.building.data.BuildingItemModels;
import tv.mapper.embellishcraft.building.data.BuildingLootTables;
import tv.mapper.embellishcraft.building.data.recipe.BuildingRecipes;
import tv.mapper.embellishcraft.building.data.recipe.BuildingStoneCutter;
import tv.mapper.embellishcraft.core.data.ECBlockModels;
import tv.mapper.embellishcraft.core.data.ECBlockStates;
import tv.mapper.embellishcraft.core.data.ECItemModels;
import tv.mapper.embellishcraft.core.data.ECLang;
import tv.mapper.embellishcraft.core.data.recipes.ECFurnaceFuels;
import tv.mapper.embellishcraft.core.data.recipes.ECRecipes;
import tv.mapper.embellishcraft.core.data.recipes.ECStonecutterRecipes;
import tv.mapper.embellishcraft.core.data.tags.ECBlockTags;
import tv.mapper.embellishcraft.core.data.tags.ECItemTags;
import tv.mapper.embellishcraft.furniture.block.InitFurnitureBlocks;
import tv.mapper.embellishcraft.furniture.data.FurnitureBlockModels;
import tv.mapper.embellishcraft.furniture.data.FurnitureBlockStates;
import tv.mapper.embellishcraft.furniture.data.FurnitureItemModels;
import tv.mapper.embellishcraft.furniture.data.FurnitureLootTables;
import tv.mapper.embellishcraft.furniture.data.FurnitureRecipes;
import tv.mapper.embellishcraft.industrial.block.InitIndustrialBlocks;
import tv.mapper.embellishcraft.industrial.data.IndustrialBlockModels;
import tv.mapper.embellishcraft.industrial.data.IndustrialBlockStates;
import tv.mapper.embellishcraft.industrial.data.IndustrialItemModels;
import tv.mapper.embellishcraft.industrial.data.IndustrialLootTables;
import tv.mapper.embellishcraft.industrial.data.IndustrialRecipes;
import tv.mapper.embellishcraft.lights.block.InitLightBlocks;
import tv.mapper.embellishcraft.lights.data.LightBlockModels;
import tv.mapper.embellishcraft.lights.data.LightBlockStates;
import tv.mapper.embellishcraft.lights.data.LightItemModels;
import tv.mapper.embellishcraft.lights.data.LightLootTables;
import tv.mapper.embellishcraft.lights.data.LightRecipes;
import tv.mapper.embellishcraft.rocks.block.InitRockBlocks;
import tv.mapper.embellishcraft.rocks.data.RockBlockModels;
import tv.mapper.embellishcraft.rocks.data.RockBlockStates;
import tv.mapper.embellishcraft.rocks.data.RockItemModels;
import tv.mapper.embellishcraft.rocks.data.RockLootTables;
import tv.mapper.embellishcraft.rocks.data.RockWorldgen;
import tv.mapper.embellishcraft.rocks.data.recipe.RockRecipes;
import tv.mapper.embellishcraft.rocks.data.recipe.RockStoneCutter;
import tv.mapper.mapperbase.api.data.loottable.BaseLootTableProvider;
import tv.mapper.mapperbase.api.data.loottable.BaseLootTables;

public class ECGenerators {
    public static void generate(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput pack = generator.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ECRecipes(pack, lookup, "EmbellishCraft Recipes"));
        generator.addProvider(event.includeServer(), (DataProvider)new BuildingRecipes(pack, lookup, "EmbellishCraft Building Recipes"));
        generator.addProvider(event.includeServer(), (DataProvider)new FurnitureRecipes(pack, lookup, "EmbellishCraft Furniture Recipes"));
        generator.addProvider(event.includeServer(), (DataProvider)new IndustrialRecipes(pack, lookup, "EmbellishCraft Industrial Recipes"));
        generator.addProvider(event.includeServer(), (DataProvider)new LightRecipes(pack, lookup, "EmbellishCraft Light Recipes"));
        generator.addProvider(event.includeServer(), (DataProvider)new RockRecipes(pack, lookup, "EmbellishCraft Rocks Recipes"));
        generator.addProvider(event.includeServer(), (DataProvider)new ECStonecutterRecipes(pack, lookup, "EmbellishCraft Stonecutter Recipes"));
        generator.addProvider(event.includeServer(), (DataProvider)new BuildingStoneCutter(pack, lookup, "EmbellishCraft Building Stonecutter Recipes"));
        generator.addProvider(event.includeServer(), (DataProvider)new RockStoneCutter(pack, lookup, "EmbellishCraft Rocks Stonecutter Recipes"));
        generator.addProvider(true, (DataProvider)new BaseLootTables(pack, List.of(new BaseLootTableProvider.SubProviderEntry(provider -> new BuildingLootTables((HolderLookup.Provider)provider, InitBuildingBlocks.BUILDING_BLOCK_REGISTRY), LootContextParamSets.BLOCK)), lookup, "EmbellishCraft Building Loot Tables", "embellishcraft"));
        generator.addProvider(true, (DataProvider)new BaseLootTables(pack, List.of(new BaseLootTableProvider.SubProviderEntry(provider -> new FurnitureLootTables((HolderLookup.Provider)provider, InitFurnitureBlocks.FURNITURE_BLOCK_REGISTRY), LootContextParamSets.BLOCK)), lookup, "EmbellishCraft Furniture Loot Tables", "embellishcraft"));
        generator.addProvider(true, (DataProvider)new BaseLootTables(pack, List.of(new BaseLootTableProvider.SubProviderEntry(provider -> new IndustrialLootTables((HolderLookup.Provider)provider, InitIndustrialBlocks.INDUSTRIAL_BLOCK_REGISTRY), LootContextParamSets.BLOCK)), lookup, "EmbellishCraft Industrial Loot Tables", "embellishcraft"));
        generator.addProvider(true, (DataProvider)new BaseLootTables(pack, List.of(new BaseLootTableProvider.SubProviderEntry(provider -> new LightLootTables((HolderLookup.Provider)provider, InitLightBlocks.LIGHT_BLOCK_REGISTRY), LootContextParamSets.BLOCK)), lookup, "EmbellishCraft Light Loot Tables", "embellishcraft"));
        generator.addProvider(true, (DataProvider)new BaseLootTables(pack, List.of(new BaseLootTableProvider.SubProviderEntry(provider -> new RockLootTables((HolderLookup.Provider)provider, InitRockBlocks.ROCK_BLOCK_REGISTRY), LootContextParamSets.BLOCK)), lookup, "EmbellishCraft Rocks Loot Tables", "embellishcraft"));
        generator.addProvider(event.includeClient(), (DataProvider)new ECBlockStates(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Blockstates"));
        generator.addProvider(event.includeClient(), (DataProvider)new BuildingBlockStates(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Building Blockstates"));
        generator.addProvider(event.includeClient(), (DataProvider)new FurnitureBlockStates(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Furniture Blockstates"));
        generator.addProvider(event.includeClient(), (DataProvider)new IndustrialBlockStates(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Industrial Blockstates"));
        generator.addProvider(event.includeClient(), (DataProvider)new LightBlockStates(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Light Blockstates"));
        generator.addProvider(event.includeClient(), (DataProvider)new RockBlockStates(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Rocks Blockstates"));
        generator.addProvider(event.includeClient(), (DataProvider)new ECBlockModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Block Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new BuildingBlockModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Building Block Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new FurnitureBlockModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Furniture Block Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new IndustrialBlockModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Industrial Block Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new LightBlockModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Light Block Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new RockBlockModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Rocks Block Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new ECItemModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Item Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new BuildingItemModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Building Item Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new FurnitureItemModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Furniture Item Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new IndustrialItemModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Industrial Item Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new LightItemModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Light Item Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new RockItemModels(pack, "embellishcraft", event.getExistingFileHelper(), "EmbellishCraft Rocks Item Models"));
        ECBlockTags blockTags = new ECBlockTags(pack, lookup, "embellishcraft", event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(true, (DataProvider)new ECItemTags(generator, event.getLookupProvider(), blockTags.contentsGetter(), event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new ECLang(pack, "embellishcraft", "en_us", "EmbellishCraft Lang US"));
        generator.addProvider(event.includeClient(), (DataProvider)new ECLang(pack, "embellishcraft", "fr_fr", "EmbellishCraft Lang FR"));
        RockWorldgen.initOres();
        generator.addProvider(event.includeServer(), (DataProvider)new RockWorldgen(pack, event.getLookupProvider(), "embellishcraft", "EmbellishCraft Rock Worldgen"));
        generator.addProvider(event.includeServer(), (DataProvider)new ECFurnaceFuels(pack, lookup));
    }
}

