/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.core.data;

import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import tv.mapper.mapperbase.api.data.BaseBlockStateProvider;

public class ECBlockStates
extends BaseBlockStateProvider {
    public ECBlockStates(PackOutput output, String modid, ExistingFileHelper exFileHelper, String name) {
        super(output, modid, exFileHelper, name);
    }

    protected void registerStatesAndModels() {
    }

    protected void registerBlockstateVariants(String name, String modid, Block block, SlabBlock slab, StairBlock stairs, WallBlock wall, PressurePlateBlock pressure, ButtonBlock button) {
        if (block != null) {
            this.simpleBlock(block);
        }
        if (slab != null) {
            this.slabBlock(slab, this.modLoc("block/" + name), this.modLoc("block/" + name));
        }
        if (stairs != null) {
            this.stairsBlock(stairs, this.modLoc("block/" + name));
        }
        if (wall != null) {
            this.wallBlock(wall, this.modLoc("block/" + name));
        }
        if (pressure != null) {
            this.pressurePlateBlock(pressure, this.modLoc("block/" + name));
        }
        if (button != null) {
            this.buttonBlock(button, ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/" + name)));
        }
    }

    protected void registerBlockstateVariantsWithSideSlab(String name, Block block, SlabBlock slab, StairBlock stairs, WallBlock wall, PressurePlateBlock pressure, ButtonBlock button) {
        if (block != null) {
            this.simpleBlock(block);
        }
        if (slab != null) {
            this.slabBlock(slab, this.modLoc("block/" + name), this.modLoc("block/" + name + "_side"), this.modLoc("block/" + name), this.modLoc("block/" + name));
        }
        if (stairs != null) {
            this.stairsBlock(stairs, this.modLoc("block/" + name));
        }
        if (wall != null) {
            this.wallBlock(wall, this.modLoc("block/" + name));
        }
        if (pressure != null) {
            this.pressurePlateBlock(pressure, this.modLoc("block/" + name));
        }
        if (button != null) {
            this.buttonBlock(button, this.modLoc("block/" + name));
        }
    }

    protected void orientableBlock(Block block, ModelFile model, int angleOffset) {
        this.orientableBlock(block, (BlockState $) -> model, angleOffset);
    }

    protected void orientableBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + angleOffset) % 360).build(), new Property[]{BlockStateProperties.WATERLOGGED});
    }
}

