/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.building.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.mapper.embellishcraft.furniture.block.SittableBlock;
import tv.mapper.embellishcraft.furniture.entity.InitFurnitureEntities;
import tv.mapper.mapperbase.api.block.tools.ToolTiers;
import tv.mapper.mapperbase.api.block.tools.ToolTypes;

public class SuspendedStairBlock
extends SittableBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private boolean isLarge = false;
    private static final VoxelShape BAR1_N = Block.box((double)6.0, (double)-1.0, (double)0.0, (double)10.0, (double)3.0, (double)4.0);
    private static final VoxelShape BAR2_N = Block.box((double)6.0, (double)3.0, (double)4.0, (double)10.0, (double)7.0, (double)8.0);
    private static final VoxelShape BAR3_N = Block.box((double)6.0, (double)7.0, (double)8.0, (double)10.0, (double)11.0, (double)12.0);
    private static final VoxelShape BAR4_N = Block.box((double)6.0, (double)11.0, (double)12.0, (double)10.0, (double)15.0, (double)16.0);
    private static final VoxelShape BAR_N = Shapes.or((VoxelShape)BAR1_N, (VoxelShape)Shapes.or((VoxelShape)BAR2_N, (VoxelShape)Shapes.or((VoxelShape)BAR3_N, (VoxelShape)BAR4_N)));
    private static final VoxelShape BAR1_W = Block.box((double)0.0, (double)-1.0, (double)6.0, (double)4.0, (double)3.0, (double)10.0);
    private static final VoxelShape BAR2_W = Block.box((double)4.0, (double)3.0, (double)6.0, (double)8.0, (double)7.0, (double)10.0);
    private static final VoxelShape BAR3_W = Block.box((double)8.0, (double)7.0, (double)6.0, (double)12.0, (double)11.0, (double)10.0);
    private static final VoxelShape BAR4_W = Block.box((double)12.0, (double)11.0, (double)6.0, (double)16.0, (double)15.0, (double)10.0);
    private static final VoxelShape BAR_W = Shapes.or((VoxelShape)BAR1_W, (VoxelShape)Shapes.or((VoxelShape)BAR2_W, (VoxelShape)Shapes.or((VoxelShape)BAR3_W, (VoxelShape)BAR4_W)));
    private static final VoxelShape BAR1_S = Block.box((double)6.0, (double)-1.0, (double)12.0, (double)10.0, (double)3.0, (double)16.0);
    private static final VoxelShape BAR2_S = Block.box((double)6.0, (double)3.0, (double)8.0, (double)10.0, (double)7.0, (double)12.0);
    private static final VoxelShape BAR3_S = Block.box((double)6.0, (double)7.0, (double)4.0, (double)10.0, (double)11.0, (double)8.0);
    private static final VoxelShape BAR4_S = Block.box((double)6.0, (double)11.0, (double)0.0, (double)10.0, (double)15.0, (double)4.0);
    private static final VoxelShape BAR_S = Shapes.or((VoxelShape)BAR1_S, (VoxelShape)Shapes.or((VoxelShape)BAR2_S, (VoxelShape)Shapes.or((VoxelShape)BAR3_S, (VoxelShape)BAR4_S)));
    private static final VoxelShape BAR1_E = Block.box((double)12.0, (double)-1.0, (double)6.0, (double)16.0, (double)3.0, (double)10.0);
    private static final VoxelShape BAR2_E = Block.box((double)8.0, (double)3.0, (double)6.0, (double)12.0, (double)7.0, (double)10.0);
    private static final VoxelShape BAR3_E = Block.box((double)4.0, (double)7.0, (double)6.0, (double)8.0, (double)11.0, (double)10.0);
    private static final VoxelShape BAR4_E = Block.box((double)0.0, (double)11.0, (double)6.0, (double)4.0, (double)15.0, (double)10.0);
    private static final VoxelShape BAR_E = Shapes.or((VoxelShape)BAR1_E, (VoxelShape)Shapes.or((VoxelShape)BAR2_E, (VoxelShape)Shapes.or((VoxelShape)BAR3_E, (VoxelShape)BAR4_E)));
    private static final VoxelShape STEP1_N = Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0);
    private static final VoxelShape STEP2_N = Block.box((double)0.0, (double)7.0, (double)4.0, (double)16.0, (double)8.0, (double)8.0);
    private static final VoxelShape STEP3_N = Block.box((double)0.0, (double)11.0, (double)8.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape STEP4_N = Block.box((double)0.0, (double)15.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape STEPS_N = Shapes.or((VoxelShape)STEP1_N, (VoxelShape)Shapes.or((VoxelShape)STEP2_N, (VoxelShape)Shapes.or((VoxelShape)STEP3_N, (VoxelShape)STEP4_N)));
    private static final VoxelShape STEP1_W = Block.box((double)0.0, (double)3.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0);
    private static final VoxelShape STEP2_W = Block.box((double)4.0, (double)7.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0);
    private static final VoxelShape STEP3_W = Block.box((double)8.0, (double)11.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape STEP4_W = Block.box((double)12.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape STEPS_W = Shapes.or((VoxelShape)STEP1_W, (VoxelShape)Shapes.or((VoxelShape)STEP2_W, (VoxelShape)Shapes.or((VoxelShape)STEP3_W, (VoxelShape)STEP4_W)));
    private static final VoxelShape STEP1_S = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    private static final VoxelShape STEP2_S = Block.box((double)0.0, (double)11.0, (double)4.0, (double)16.0, (double)12.0, (double)8.0);
    private static final VoxelShape STEP3_S = Block.box((double)0.0, (double)7.0, (double)8.0, (double)16.0, (double)8.0, (double)12.0);
    private static final VoxelShape STEP4_S = Block.box((double)0.0, (double)3.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape STEPS_S = Shapes.or((VoxelShape)STEP1_S, (VoxelShape)Shapes.or((VoxelShape)STEP2_S, (VoxelShape)Shapes.or((VoxelShape)STEP3_S, (VoxelShape)STEP4_S)));
    private static final VoxelShape STEP1_E = Block.box((double)0.0, (double)15.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    private static final VoxelShape STEP2_E = Block.box((double)4.0, (double)11.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0);
    private static final VoxelShape STEP3_E = Block.box((double)8.0, (double)7.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0);
    private static final VoxelShape STEP4_E = Block.box((double)12.0, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape STEPS_E = Shapes.or((VoxelShape)STEP1_E, (VoxelShape)Shapes.or((VoxelShape)STEP2_E, (VoxelShape)Shapes.or((VoxelShape)STEP3_E, (VoxelShape)STEP4_E)));
    private static final VoxelShape STEP1_LARGE_N = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    private static final VoxelShape STEP2_LARGE_N = Block.box((double)0.0, (double)14.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape LARGE_N = Shapes.or((VoxelShape)STEP1_LARGE_N, (VoxelShape)STEP2_LARGE_N);
    private static final VoxelShape STEP1_LARGE_W = Block.box((double)0.0, (double)6.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0);
    private static final VoxelShape STEP2_LARGE_W = Block.box((double)8.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape LARGE_W = Shapes.or((VoxelShape)STEP1_LARGE_W, (VoxelShape)STEP2_LARGE_W);
    private static final VoxelShape STEP1_LARGE_S = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape STEP2_LARGE_S = Block.box((double)0.0, (double)6.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape LARGE_S = Shapes.or((VoxelShape)STEP1_LARGE_S, (VoxelShape)STEP2_LARGE_S);
    private static final VoxelShape STEP1_LARGE_E = Block.box((double)8.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape STEP2_LARGE_E = Block.box((double)0.0, (double)14.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape LARGE_E = Shapes.or((VoxelShape)STEP1_LARGE_E, (VoxelShape)STEP2_LARGE_E);
    private static final VoxelShape STEP1_COL_N = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    private static final VoxelShape STEP2_COL_N = Block.box((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape COL_N = Shapes.or((VoxelShape)STEP1_COL_N, (VoxelShape)STEP2_COL_N);
    private static final VoxelShape STEP1_COL_W = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0);
    private static final VoxelShape STEP2_COL_W = Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape COL_W = Shapes.or((VoxelShape)STEP1_COL_W, (VoxelShape)STEP2_COL_W);
    private static final VoxelShape STEP1_COL_S = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape STEP2_COL_S = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape COL_S = Shapes.or((VoxelShape)STEP1_COL_S, (VoxelShape)STEP2_COL_S);
    private static final VoxelShape STEP1_COL_E = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape STEP2_COL_E = Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape COL_E = Shapes.or((VoxelShape)STEP1_COL_E, (VoxelShape)STEP2_COL_E);
    private static final VoxelShape SHAPE_N = Shapes.or((VoxelShape)STEPS_N, (VoxelShape)BAR_N);
    private static final VoxelShape SHAPE_W = Shapes.or((VoxelShape)STEPS_W, (VoxelShape)BAR_W);
    private static final VoxelShape SHAPE_S = Shapes.or((VoxelShape)STEPS_S, (VoxelShape)BAR_S);
    private static final VoxelShape SHAPE_E = Shapes.or((VoxelShape)STEPS_E, (VoxelShape)BAR_E);
    private static final VoxelShape SHAPE_LARGE_N = Shapes.or((VoxelShape)LARGE_N, (VoxelShape)BAR_N);
    private static final VoxelShape SHAPE_LARGE_W = Shapes.or((VoxelShape)LARGE_W, (VoxelShape)BAR_W);
    private static final VoxelShape SHAPE_LARGE_S = Shapes.or((VoxelShape)LARGE_S, (VoxelShape)BAR_S);
    private static final VoxelShape SHAPE_LARGE_E = Shapes.or((VoxelShape)LARGE_E, (VoxelShape)BAR_E);

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return !this.isLarge ? SHAPE_N : SHAPE_LARGE_N;
            }
            case SOUTH: {
                return !this.isLarge ? SHAPE_S : SHAPE_LARGE_S;
            }
            case WEST: {
                return !this.isLarge ? SHAPE_W : SHAPE_LARGE_W;
            }
            case EAST: {
                return !this.isLarge ? SHAPE_E : SHAPE_LARGE_E;
            }
        }
        return !this.isLarge ? SHAPE_N : SHAPE_LARGE_N;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return COL_N;
            }
            case SOUTH: {
                return COL_S;
            }
            case WEST: {
                return COL_W;
            }
            case EAST: {
                return COL_E;
            }
        }
        return COL_N;
    }

    public SuspendedStairBlock(BlockBehaviour.Properties properties, ToolTypes tool, boolean isLarge) {
        super(properties, tool);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.isLarge = isLarge;
    }

    public SuspendedStairBlock(BlockBehaviour.Properties properties, ToolTypes tool, ToolTiers tier, boolean isLarge) {
        super(properties, tool, tier);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.isLarge = isLarge;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        FluidState ifluidstate = context.getLevel().getFluidState(blockpos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isLagre() {
        return this.isLarge;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (!level.isClientSide && this.isLarge) {
            Entity sitEntity = null;
            List sitEntities = level.getEntities((EntityTypeTest)InitFurnitureEntities.SIT_ENTITY.get(), new AABB(pos), sit -> true);
            if (sitEntities.isEmpty()) {
                sitEntity = InitFurnitureEntities.SIT_ENTITY.get().spawn((ServerLevel)level, pos, MobSpawnType.TRIGGERED);
                player.startRiding(sitEntity);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

