/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.util;

import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import tv.mapper.mapperbase.config.MB_Config;

@EventBusSubscriber(modid="mapperbase")
public class TagViewer {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        if (!MB_Config.enableTagViewer) {
            return;
        }
        if (!Screen.hasControlDown()) {
            return;
        }
        List tooltips = event.getToolTip();
        ItemStack item = event.getItemStack();
        Iterator tagmap = BuiltInRegistries.ITEM.getTags().iterator();
        int count = 0;
        while (tagmap.hasNext()) {
            TagKey key = (TagKey)((Pair)tagmap.next()).getFirst();
            if (!item.is(key)) continue;
            tooltips.add(Component.literal((String)("Tag: " + String.valueOf(key.location()))).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withItalic(Boolean.valueOf(true))));
            ++count;
        }
        if (count <= 0) {
            tooltips.add(Component.literal((String)"No tag found").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withItalic(Boolean.valueOf(true))));
        } else {
            tooltips.add(Component.literal((String)("Total tags: " + count)).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withItalic(Boolean.valueOf(true))));
        }
    }
}

