/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.data;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import tv.mapper.mapperbase.api.data.loottable.BaseLootTableProvider;
import tv.mapper.mapperbase.api.data.loottable.BaseLootTables;
import tv.mapper.mapperbase.block.MB_Blocks;
import tv.mapper.mapperbase.data.BlockModelGenerator;
import tv.mapper.mapperbase.data.BlockStateGenerator;
import tv.mapper.mapperbase.data.ItemModelGenerator;
import tv.mapper.mapperbase.data.LangGenerator;
import tv.mapper.mapperbase.data.LootTableGenerator;
import tv.mapper.mapperbase.data.RecipeGenerator;
import tv.mapper.mapperbase.data.loot.GlobalLootModifiersGenerator;
import tv.mapper.mapperbase.data.tags.BlockTagGenerator;
import tv.mapper.mapperbase.data.tags.ItemTagGenerator;

public class MB_DataGenerators {
    public static void generate(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput pack = generator.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(pack, "mapperbase", event.getExistingFileHelper(), "Mapper Base Blockstates"));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockModelGenerator(pack, "mapperbase", event.getExistingFileHelper(), "Mapper Base Block Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(pack, "mapperbase", event.getExistingFileHelper(), "Mapper Basse Item Models"));
        generator.addProvider(event.includeClient(), (DataProvider)new LangGenerator(pack, "mapperbase", "en_us", "Mapper Base Lang US"));
        generator.addProvider(event.includeClient(), (DataProvider)new LangGenerator(pack, "mapperbase", "fr_fr", "Mapper Base Lang FR"));
        generator.addProvider(true, (DataProvider)new BaseLootTables(pack, List.of(new BaseLootTableProvider.SubProviderEntry(provider -> new LootTableGenerator((HolderLookup.Provider)provider, MB_Blocks.BLOCKS), LootContextParamSets.BLOCK)), lookup, "Mapper Base Loot Tables", "mapperbase"));
        BlockTagGenerator blockTagProvider = new BlockTagGenerator(pack, lookup, "mapperbase", event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(pack, lookup, blockTagProvider.contentsGetter(), "mapperbase", event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(pack, lookup, "Mapper Base Recipes"));
        generator.addProvider(event.includeServer(), (DataProvider)new GlobalLootModifiersGenerator(pack, lookup, "mapperbase", "Mapper Base Global Loot Modifiers"));
    }
}

