/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.api.data.tags;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;
import tv.mapper.mapperbase.api.block.tools.ToolManager;
import tv.mapper.mapperbase.api.data.tags.BaseTags;

public class BaseBlockTagsProvider
extends BlockTagsProvider {
    public BaseBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, modId, existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
    }

    protected void registerToolTags(DeferredRegister<Block> blocks) {
        for (DeferredHolder object : blocks.getEntries()) {
            Block block = (Block)object.get();
            if (!(block instanceof ToolManager)) continue;
            switch (((ToolManager)block).getTool()) {
                case PICKAXE: {
                    this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)block);
                    break;
                }
                case AXE: {
                    this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)block);
                    break;
                }
                case SHOVEL: {
                    this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add((Object)block);
                    break;
                }
                case HOE: {
                    this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object)block);
                    break;
                }
            }
            switch (((ToolManager)block).getTier()) {
                case WOOD: {
                    this.tag(Tags.Blocks.NEEDS_WOOD_TOOL).add((Object)block);
                    break;
                }
                case GOLD: {
                    this.tag(Tags.Blocks.NEEDS_GOLD_TOOL).add((Object)block);
                    break;
                }
                case STONE: {
                    this.tag(BlockTags.NEEDS_STONE_TOOL).add((Object)block);
                    break;
                }
                case IRON: {
                    this.tag(BlockTags.NEEDS_IRON_TOOL).add((Object)block);
                    break;
                }
                case STEEL: {
                    this.tag(BaseTags.Blocks.NEEDS_STEEL_TOOL).add((Object)block);
                    break;
                }
                case DIAMOND: {
                    this.tag(BlockTags.NEEDS_DIAMOND_TOOL).add((Object)block);
                    break;
                }
                case NETHERITE: {
                    this.tag(Tags.Blocks.NEEDS_NETHERITE_TOOL).add((Object)block);
                    break;
                }
            }
        }
    }
}

