/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.api.data.loottable;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import tv.mapper.mapperbase.api.data.loottable.BaseLootTableProvider;

public class BaseLootTables
extends BaseLootTableProvider {
    private String modid;

    public BaseLootTables(PackOutput output, List<BaseLootTableProvider.SubProviderEntry> subProviders, CompletableFuture<HolderLookup.Provider> registries, String name, String modid) {
        super(output, Set.of(), subProviders, registries, name);
        this.modid = modid;
    }

    @Override
    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        Set modLootTablesId = BuiltInLootTables.all().stream().filter(id -> id.registry().getNamespace().equals(this.modid)).collect(Collectors.toSet());
        for (ResourceKey id2 : Sets.difference(modLootTablesId, (Set)writableregistry.keySet())) {
            validationcontext.reportProblem("Missing built-in table: " + String.valueOf(id2));
        }
        writableregistry.forEach(lootTable -> lootTable.validate(validationcontext));
    }
}

