/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.api.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.DataMapHooks;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;

public abstract class BaseRecipeProvider
implements DataProvider {
    private String name;
    protected final PackOutput.PathProvider recipePathProvider;
    protected final PackOutput.PathProvider advancementPathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private static final Map<BlockFamily.Variant, BiFunction<ItemLike, ItemLike, RecipeBuilder>> SHAPE_BUILDERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, (p_176733_, p_176734_) -> BaseRecipeProvider.buttonBuilder(p_176733_, Ingredient.of((ItemLike[])new ItemLike[]{p_176734_}))).put((Object)BlockFamily.Variant.CHISELED, (p_248037_, p_248038_) -> BaseRecipeProvider.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, p_248037_, Ingredient.of((ItemLike[])new ItemLike[]{p_248038_}))).put((Object)BlockFamily.Variant.CUT, (p_248026_, p_248027_) -> BaseRecipeProvider.cutBuilder(RecipeCategory.BUILDING_BLOCKS, p_248026_, Ingredient.of((ItemLike[])new ItemLike[]{p_248027_}))).put((Object)BlockFamily.Variant.DOOR, (p_176714_, p_176715_) -> BaseRecipeProvider.doorBuilder(p_176714_, Ingredient.of((ItemLike[])new ItemLike[]{p_176715_}))).put((Object)BlockFamily.Variant.CUSTOM_FENCE, (p_176708_, p_176709_) -> BaseRecipeProvider.fenceBuilder(p_176708_, Ingredient.of((ItemLike[])new ItemLike[]{p_176709_}))).put((Object)BlockFamily.Variant.FENCE, (p_248031_, p_248032_) -> BaseRecipeProvider.fenceBuilder(p_248031_, Ingredient.of((ItemLike[])new ItemLike[]{p_248032_}))).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, (p_176698_, p_176699_) -> BaseRecipeProvider.fenceGateBuilder(p_176698_, Ingredient.of((ItemLike[])new ItemLike[]{p_176699_}))).put((Object)BlockFamily.Variant.FENCE_GATE, (p_248035_, p_248036_) -> BaseRecipeProvider.fenceGateBuilder(p_248035_, Ingredient.of((ItemLike[])new ItemLike[]{p_248036_}))).put((Object)BlockFamily.Variant.SIGN, (p_176688_, p_176689_) -> BaseRecipeProvider.signBuilder(p_176688_, Ingredient.of((ItemLike[])new ItemLike[]{p_176689_}))).put((Object)BlockFamily.Variant.SLAB, (p_248017_, p_248018_) -> BaseRecipeProvider.slabBuilder(RecipeCategory.BUILDING_BLOCKS, p_248017_, Ingredient.of((ItemLike[])new ItemLike[]{p_248018_}))).put((Object)BlockFamily.Variant.STAIRS, (p_176674_, p_176675_) -> BaseRecipeProvider.stairBuilder(p_176674_, Ingredient.of((ItemLike[])new ItemLike[]{p_176675_}))).put((Object)BlockFamily.Variant.PRESSURE_PLATE, (p_248039_, p_248040_) -> BaseRecipeProvider.pressurePlateBuilder(RecipeCategory.REDSTONE, p_248039_, Ingredient.of((ItemLike[])new ItemLike[]{p_248040_}))).put((Object)BlockFamily.Variant.POLISHED, (p_248019_, p_248020_) -> BaseRecipeProvider.polishedBuilder(RecipeCategory.BUILDING_BLOCKS, p_248019_, Ingredient.of((ItemLike[])new ItemLike[]{p_248020_}))).put((Object)BlockFamily.Variant.TRAPDOOR, (p_176638_, p_176639_) -> BaseRecipeProvider.trapdoorBuilder(p_176638_, Ingredient.of((ItemLike[])new ItemLike[]{p_176639_}))).put((Object)BlockFamily.Variant.WALL, (p_248024_, p_248025_) -> BaseRecipeProvider.wallBuilder(RecipeCategory.DECORATIONS, p_248024_, Ingredient.of((ItemLike[])new ItemLike[]{p_248025_}))).build();

    public BaseRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String name) {
        this.recipePathProvider = output.createRegistryElementsPathProvider(Registries.RECIPE);
        this.advancementPathProvider = output.createRegistryElementsPathProvider(Registries.ADVANCEMENT);
        this.registries = registries;
        this.name = name;
    }

    public final CompletableFuture<?> run(CachedOutput output) {
        return this.registries.thenCompose(p_323133_ -> this.run(output, (HolderLookup.Provider)p_323133_));
    }

    protected CompletableFuture<?> run(final CachedOutput output, final HolderLookup.Provider registries) {
        final HashSet set = Sets.newHashSet();
        final ArrayList list = new ArrayList();
        this.buildRecipes(new RecipeOutput(){

            public void accept(ResourceLocation p_312039_, Recipe<?> p_312254_, @Nullable AdvancementHolder p_311794_, ICondition ... conditions) {
                if (!set.add(p_312039_)) {
                    throw new IllegalStateException("Duplicate recipe " + String.valueOf(p_312039_));
                }
                list.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, (Codec)Recipe.CONDITIONAL_CODEC, Optional.of(new WithConditions(p_312254_, conditions)), (Path)BaseRecipeProvider.this.recipePathProvider.json(p_312039_)));
                if (p_311794_ != null) {
                    list.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, (Codec)Advancement.CONDITIONAL_CODEC, Optional.of(new WithConditions((Object)p_311794_.value(), conditions)), (Path)BaseRecipeProvider.this.advancementPathProvider.json(p_311794_.id())));
                }
            }

            public Advancement.Builder advancement() {
                return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
            }
        }, registries);
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected CompletableFuture<?> buildAdvancement(CachedOutput output, HolderLookup.Provider registries, AdvancementHolder advancement) {
        return this.buildAdvancement(output, registries, advancement, new ICondition[0]);
    }

    protected CompletableFuture<?> buildAdvancement(CachedOutput output, HolderLookup.Provider registries, AdvancementHolder advancement, ICondition ... conditions) {
        return DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, (Codec)Advancement.CONDITIONAL_CODEC, Optional.of(new WithConditions((Object)advancement.value(), conditions)), (Path)this.advancementPathProvider.json(advancement.id()));
    }

    protected void buildRecipes(RecipeOutput p_recipeOutput, HolderLookup.Provider holderLookup) {
        this.buildRecipes(p_recipeOutput);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
    }

    protected void generateForEnabledBlockFamilies(RecipeOutput enabledFeatures, FeatureFlagSet p_251836_) {
        BlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateRecipe).forEach(p_313461_ -> BaseRecipeProvider.generateRecipes(enabledFeatures, p_313461_, p_251836_));
    }

    protected static void oneToOneConversionRecipe(RecipeOutput recipeOutput, ItemLike result, ItemLike ingredient, @Nullable String group) {
        BaseRecipeProvider.oneToOneConversionRecipe(recipeOutput, result, ingredient, group, 1);
    }

    protected static void oneToOneConversionRecipe(RecipeOutput recipeOutput, ItemLike result, ItemLike ingredient, @Nullable String group, int resultCount) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)resultCount).requires(ingredient).group(group).unlockedBy(BaseRecipeProvider.getHasName(ingredient), BaseRecipeProvider.has(ingredient)).save(recipeOutput, BaseRecipeProvider.getConversionRecipeName(result, ingredient));
    }

    protected static void oreSmelting(RecipeOutput recipeOutput, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        BaseRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, ingredients, category, result, experience, cookingTime, group, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput recipeOutput, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        BaseRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, ingredients, category, result, experience, cookingTime, group, "_from_blasting");
    }

    protected static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput recipeOutput, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> recipeFactory, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group, String suffix) {
        for (ItemLike itemlike : ingredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)category, (ItemLike)result, (float)experience, (int)cookingTime, serializer, recipeFactory).group(group).unlockedBy(BaseRecipeProvider.getHasName(itemlike), BaseRecipeProvider.has(itemlike)).save(recipeOutput, BaseRecipeProvider.getItemName(result) + suffix + "_" + BaseRecipeProvider.getItemName(itemlike));
        }
    }

    protected static void netheriteSmithing(RecipeOutput recipeOutput, Item ingredientItem, RecipeCategory category, Item resultItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredientItem}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), (RecipeCategory)category, (Item)resultItem).unlocks("has_netherite_ingot", BaseRecipeProvider.has((ItemLike)Items.NETHERITE_INGOT)).save(recipeOutput, BaseRecipeProvider.getItemName((ItemLike)resultItem) + "_smithing");
    }

    protected static void trimSmithing(RecipeOutput recipeOutput, Item ingredientItem, ResourceLocation location) {
        SmithingTrimRecipeBuilder.smithingTrim((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredientItem}), (Ingredient)Ingredient.of((TagKey)ItemTags.TRIMMABLE_ARMOR), (Ingredient)Ingredient.of((TagKey)ItemTags.TRIM_MATERIALS), (RecipeCategory)RecipeCategory.MISC).unlocks("has_smithing_trim_template", BaseRecipeProvider.has((ItemLike)ingredientItem)).save(recipeOutput, location);
    }

    protected static void twoByTwoPacker(RecipeOutput recipeOutput, RecipeCategory category, ItemLike packed, ItemLike unpacked) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)packed, (int)1).define(Character.valueOf('#'), unpacked).pattern("##").pattern("##").unlockedBy(BaseRecipeProvider.getHasName(unpacked), BaseRecipeProvider.has(unpacked)).save(recipeOutput);
    }

    protected static void threeByThreePacker(RecipeOutput recipeOutput, RecipeCategory category, ItemLike packed, ItemLike unpacked, String criterionName) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)packed).requires(unpacked, 9).unlockedBy(criterionName, BaseRecipeProvider.has(unpacked)).save(recipeOutput);
    }

    protected static void threeByThreePacker(RecipeOutput recipeOutput, RecipeCategory category, ItemLike packed, ItemLike unpacked) {
        BaseRecipeProvider.threeByThreePacker(recipeOutput, category, packed, unpacked, BaseRecipeProvider.getHasName(unpacked));
    }

    protected static void planksFromLog(RecipeOutput recipeOutput, ItemLike planks, TagKey<Item> logs, int resultCount) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (int)resultCount).requires(logs).group("planks").unlockedBy("has_log", BaseRecipeProvider.has(logs)).save(recipeOutput);
    }

    protected static void planksFromLogs(RecipeOutput recipeOutput, ItemLike planks, TagKey<Item> logs, int result) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (int)result).requires(logs).group("planks").unlockedBy("has_logs", BaseRecipeProvider.has(logs)).save(recipeOutput);
    }

    protected static void woodFromLogs(RecipeOutput recipeOutput, ItemLike wood, ItemLike log) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood, (int)3).define(Character.valueOf('#'), log).pattern("##").pattern("##").group("bark").unlockedBy("has_log", BaseRecipeProvider.has(log)).save(recipeOutput);
    }

    protected static void woodenBoat(RecipeOutput recipeOutput, ItemLike boat, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)boat).define(Character.valueOf('#'), material).pattern("# #").pattern("###").group("boat").unlockedBy("in_water", BaseRecipeProvider.insideOf(Blocks.WATER)).save(recipeOutput);
    }

    protected static void chestBoat(RecipeOutput recipeOutput, ItemLike boat, ItemLike material) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)boat).requires((ItemLike)Blocks.CHEST).requires(material).group("chest_boat").unlockedBy("has_boat", BaseRecipeProvider.has((TagKey<Item>)ItemTags.BOATS)).save(recipeOutput);
    }

    protected static RecipeBuilder buttonBuilder(ItemLike button, Ingredient material) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)button).requires(material);
    }

    protected static RecipeBuilder doorBuilder(ItemLike door, Ingredient material) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)door, (int)3).define(Character.valueOf('#'), material).pattern("##").pattern("##").pattern("##");
    }

    protected static RecipeBuilder fenceBuilder(ItemLike fence, Ingredient material) {
        int i = fence == Blocks.NETHER_BRICK_FENCE ? 6 : 3;
        Item item = fence == Blocks.NETHER_BRICK_FENCE ? Items.NETHER_BRICK : Items.STICK;
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence, (int)i).define(Character.valueOf('W'), material).define(Character.valueOf('#'), (ItemLike)item).pattern("W#W").pattern("W#W");
    }

    protected static RecipeBuilder fenceGateBuilder(ItemLike fenceGate, Ingredient material) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)fenceGate).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('W'), material).pattern("#W#").pattern("#W#");
    }

    protected static void pressurePlate(RecipeOutput recipeOutput, ItemLike pressurePlate, ItemLike material) {
        BaseRecipeProvider.pressurePlateBuilder(RecipeCategory.REDSTONE, pressurePlate, Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(BaseRecipeProvider.getHasName(material), BaseRecipeProvider.has(material)).save(recipeOutput);
    }

    protected static RecipeBuilder pressurePlateBuilder(RecipeCategory category, ItemLike pressurePlate, Ingredient material) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)pressurePlate).define(Character.valueOf('#'), material).pattern("##");
    }

    protected static void slab(RecipeOutput recipeOutput, RecipeCategory category, ItemLike slab, ItemLike material) {
        BaseRecipeProvider.slabBuilder(category, slab, Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(BaseRecipeProvider.getHasName(material), BaseRecipeProvider.has(material)).save(recipeOutput);
    }

    protected static RecipeBuilder slabBuilder(RecipeCategory category, ItemLike slab, Ingredient material) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)slab, (int)6).define(Character.valueOf('#'), material).pattern("###");
    }

    protected static RecipeBuilder stairBuilder(ItemLike stairs, Ingredient material) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)4).define(Character.valueOf('#'), material).pattern("#  ").pattern("## ").pattern("###");
    }

    protected static RecipeBuilder trapdoorBuilder(ItemLike trapdoor, Ingredient material) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)trapdoor, (int)2).define(Character.valueOf('#'), material).pattern("###").pattern("###");
    }

    protected static RecipeBuilder signBuilder(ItemLike sign, Ingredient material) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)sign, (int)3).group("sign").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (ItemLike)Items.STICK).pattern("###").pattern("###").pattern(" X ");
    }

    protected static void hangingSign(RecipeOutput recipeOutput, ItemLike sign, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)sign, (int)6).group("hanging_sign").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (ItemLike)Items.CHAIN).pattern("X X").pattern("###").pattern("###").unlockedBy("has_stripped_logs", BaseRecipeProvider.has(material)).save(recipeOutput);
    }

    protected static void colorBlockWithDye(RecipeOutput recipeOutput, List<Item> dyes, List<Item> dyeableItems, String group) {
        for (int i = 0; i < dyes.size(); ++i) {
            Item item = dyes.get(i);
            Item item1 = dyeableItems.get(i);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item1).requires((ItemLike)item).requires(Ingredient.of(dyeableItems.stream().filter(p_288265_ -> !p_288265_.equals(item1)).map(ItemStack::new))).group(group).unlockedBy("has_needed_dye", BaseRecipeProvider.has((ItemLike)item)).save(recipeOutput, "dye_" + BaseRecipeProvider.getItemName((ItemLike)item1));
        }
    }

    protected static void carpet(RecipeOutput recipeOutput, ItemLike carpet, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)carpet, (int)3).define(Character.valueOf('#'), material).pattern("##").group("carpet").unlockedBy(BaseRecipeProvider.getHasName(material), BaseRecipeProvider.has(material)).save(recipeOutput);
    }

    protected static void bedFromPlanksAndWool(RecipeOutput recipeOutput, ItemLike bed, ItemLike wool) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)bed).define(Character.valueOf('#'), wool).define(Character.valueOf('X'), ItemTags.PLANKS).pattern("###").pattern("XXX").group("bed").unlockedBy(BaseRecipeProvider.getHasName(wool), BaseRecipeProvider.has(wool)).save(recipeOutput);
    }

    protected static void banner(RecipeOutput recipeOutput, ItemLike banner, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)banner).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("###").pattern("###").pattern(" | ").group("banner").unlockedBy(BaseRecipeProvider.getHasName(material), BaseRecipeProvider.has(material)).save(recipeOutput);
    }

    protected static void stainedGlassFromGlassAndDye(RecipeOutput recipeOutput, ItemLike stainedGlass, ItemLike dye) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stainedGlass, (int)8).define(Character.valueOf('#'), (ItemLike)Blocks.GLASS).define(Character.valueOf('X'), dye).pattern("###").pattern("#X#").pattern("###").group("stained_glass").unlockedBy("has_glass", BaseRecipeProvider.has((ItemLike)Blocks.GLASS)).save(recipeOutput);
    }

    protected static void stainedGlassPaneFromStainedGlass(RecipeOutput recipeOutput, ItemLike stainedGlassPane, ItemLike stainedGlass) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)stainedGlassPane, (int)16).define(Character.valueOf('#'), stainedGlass).pattern("###").pattern("###").group("stained_glass_pane").unlockedBy("has_glass", BaseRecipeProvider.has(stainedGlass)).save(recipeOutput);
    }

    protected static void stainedGlassPaneFromGlassPaneAndDye(RecipeOutput recipeOutput, ItemLike stainedGlassPane, ItemLike dye) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)stainedGlassPane, (int)8).define(Character.valueOf('#'), (ItemLike)Blocks.GLASS_PANE).define(Character.valueOf('$'), dye).pattern("###").pattern("#$#").pattern("###").group("stained_glass_pane").unlockedBy("has_glass_pane", BaseRecipeProvider.has((ItemLike)Blocks.GLASS_PANE)).unlockedBy(BaseRecipeProvider.getHasName(dye), BaseRecipeProvider.has(dye)).save(recipeOutput, BaseRecipeProvider.getConversionRecipeName(stainedGlassPane, (ItemLike)Blocks.GLASS_PANE));
    }

    protected static void coloredTerracottaFromTerracottaAndDye(RecipeOutput recipeOutput, ItemLike terracotta, ItemLike dye) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)terracotta, (int)8).define(Character.valueOf('#'), (ItemLike)Blocks.TERRACOTTA).define(Character.valueOf('X'), dye).pattern("###").pattern("#X#").pattern("###").group("stained_terracotta").unlockedBy("has_terracotta", BaseRecipeProvider.has((ItemLike)Blocks.TERRACOTTA)).save(recipeOutput);
    }

    protected static void concretePowder(RecipeOutput recipeOutput, ItemLike concretePowder, ItemLike dye) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)concretePowder, (int)8).requires(dye).requires((ItemLike)Blocks.SAND, 4).requires((ItemLike)Blocks.GRAVEL, 4).group("concrete_powder").unlockedBy("has_sand", BaseRecipeProvider.has((ItemLike)Blocks.SAND)).unlockedBy("has_gravel", BaseRecipeProvider.has((ItemLike)Blocks.GRAVEL)).save(recipeOutput);
    }

    protected static void candle(RecipeOutput recipeOutput, ItemLike candle, ItemLike dye) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)candle).requires((ItemLike)Blocks.CANDLE).requires(dye).group("dyed_candle").unlockedBy(BaseRecipeProvider.getHasName(dye), BaseRecipeProvider.has(dye)).save(recipeOutput);
    }

    protected static void wall(RecipeOutput recipeOutput, RecipeCategory category, ItemLike wall, ItemLike material) {
        BaseRecipeProvider.wallBuilder(category, wall, Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(BaseRecipeProvider.getHasName(material), BaseRecipeProvider.has(material)).save(recipeOutput);
    }

    protected static RecipeBuilder wallBuilder(RecipeCategory category, ItemLike wall, Ingredient material) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)wall, (int)6).define(Character.valueOf('#'), material).pattern("###").pattern("###");
    }

    protected static void polished(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, ItemLike material) {
        BaseRecipeProvider.polishedBuilder(category, result, Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(BaseRecipeProvider.getHasName(material), BaseRecipeProvider.has(material)).save(recipeOutput);
    }

    protected static RecipeBuilder polishedBuilder(RecipeCategory category, ItemLike result, Ingredient material) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)result, (int)4).define(Character.valueOf('S'), material).pattern("SS").pattern("SS");
    }

    protected static void cut(RecipeOutput recipeOutput, RecipeCategory category, ItemLike cutResult, ItemLike material) {
        BaseRecipeProvider.cutBuilder(category, cutResult, Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(BaseRecipeProvider.getHasName(material), BaseRecipeProvider.has(material)).save(recipeOutput);
    }

    protected static ShapedRecipeBuilder cutBuilder(RecipeCategory category, ItemLike cutResult, Ingredient material) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)cutResult, (int)4).define(Character.valueOf('#'), material).pattern("##").pattern("##");
    }

    protected static void chiseled(RecipeOutput recipeOutput, RecipeCategory category, ItemLike chiseledResult, ItemLike material) {
        BaseRecipeProvider.chiseledBuilder(category, chiseledResult, Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(BaseRecipeProvider.getHasName(material), BaseRecipeProvider.has(material)).save(recipeOutput);
    }

    protected static void mosaicBuilder(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)result).define(Character.valueOf('#'), material).pattern("#").pattern("#").unlockedBy(BaseRecipeProvider.getHasName(material), BaseRecipeProvider.has(material)).save(recipeOutput);
    }

    protected static ShapedRecipeBuilder chiseledBuilder(RecipeCategory category, ItemLike chiseledResult, Ingredient material) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)chiseledResult).define(Character.valueOf('#'), material).pattern("#").pattern("#");
    }

    protected static void stonecutterResultFromBase(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, ItemLike material) {
        BaseRecipeProvider.stonecutterResultFromBase(recipeOutput, category, result, material, 1);
    }

    protected static void stonecutterResultFromBase(RecipeOutput recipeOutput, RecipeCategory category, ItemLike result, ItemLike material, int resultCount) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material}), (RecipeCategory)category, (ItemLike)result, (int)resultCount).unlockedBy(BaseRecipeProvider.getHasName(material), BaseRecipeProvider.has(material)).save(recipeOutput, BaseRecipeProvider.getConversionRecipeName(result, material) + "_stonecutting");
    }

    protected static void smeltingResultFromBase(RecipeOutput recipeOutput, ItemLike result, ItemLike ingredient) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (float)0.1f, (int)200).unlockedBy(BaseRecipeProvider.getHasName(ingredient), BaseRecipeProvider.has(ingredient)).save(recipeOutput);
    }

    protected static void nineBlockStorageRecipes(RecipeOutput recipeOutput, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed) {
        BaseRecipeProvider.nineBlockStorageRecipes(recipeOutput, unpackedCategory, unpacked, packedCategory, packed, BaseRecipeProvider.getSimpleRecipeName(packed), null, BaseRecipeProvider.getSimpleRecipeName(unpacked), null);
    }

    protected static void nineBlockStorageRecipesWithCustomPacking(RecipeOutput recipeOutput, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed, String packedName, String packedGroup) {
        BaseRecipeProvider.nineBlockStorageRecipes(recipeOutput, unpackedCategory, unpacked, packedCategory, packed, packedName, packedGroup, BaseRecipeProvider.getSimpleRecipeName(unpacked), null);
    }

    protected static void nineBlockStorageRecipesRecipesWithCustomUnpacking(RecipeOutput recipeOutput, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed, String unpackedName, String unpackedGroup) {
        BaseRecipeProvider.nineBlockStorageRecipes(recipeOutput, unpackedCategory, unpacked, packedCategory, packed, BaseRecipeProvider.getSimpleRecipeName(packed), null, unpackedName, unpackedGroup);
    }

    protected static void nineBlockStorageRecipes(RecipeOutput recipeOutput, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed, String packedName, @Nullable String packedGroup, String unpackedName, @Nullable String unpackedGroup) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)unpackedCategory, (ItemLike)unpacked, (int)9).requires(packed).group(unpackedGroup).unlockedBy(BaseRecipeProvider.getHasName(packed), BaseRecipeProvider.has(packed)).save(recipeOutput, ResourceLocation.parse((String)unpackedName));
        ShapedRecipeBuilder.shaped((RecipeCategory)packedCategory, (ItemLike)packed).define(Character.valueOf('#'), unpacked).pattern("###").pattern("###").pattern("###").group(packedGroup).unlockedBy(BaseRecipeProvider.getHasName(unpacked), BaseRecipeProvider.has(unpacked)).save(recipeOutput, ResourceLocation.parse((String)packedName));
    }

    protected static void copySmithingTemplate(RecipeOutput recipeOutput, ItemLike template, TagKey<Item> baseMaterial) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)template, (int)2).define(Character.valueOf('#'), (ItemLike)Items.DIAMOND).define(Character.valueOf('C'), baseMaterial).define(Character.valueOf('S'), template).pattern("#S#").pattern("#C#").pattern("###").unlockedBy(BaseRecipeProvider.getHasName(template), BaseRecipeProvider.has(template)).save(recipeOutput);
    }

    protected static void copySmithingTemplate(RecipeOutput recipeOutput, ItemLike template, ItemLike baseItem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)template, (int)2).define(Character.valueOf('#'), (ItemLike)Items.DIAMOND).define(Character.valueOf('C'), baseItem).define(Character.valueOf('S'), template).pattern("#S#").pattern("#C#").pattern("###").unlockedBy(BaseRecipeProvider.getHasName(template), BaseRecipeProvider.has(template)).save(recipeOutput);
    }

    protected static void copySmithingTemplate(RecipeOutput recipeOutput, ItemLike template, Ingredient baseItem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)template, (int)2).define(Character.valueOf('#'), (ItemLike)Items.DIAMOND).define(Character.valueOf('C'), baseItem).define(Character.valueOf('S'), template).pattern("#S#").pattern("#C#").pattern("###").unlockedBy(BaseRecipeProvider.getHasName(template), BaseRecipeProvider.has(template)).save(recipeOutput);
    }

    protected static <T extends AbstractCookingRecipe> void cookRecipes(RecipeOutput recipeOutput, String cookingMethod, RecipeSerializer<T> cookingSerializer, AbstractCookingRecipe.Factory<T> recipeFactory, int cookingTime) {
        BaseRecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.BEEF, (ItemLike)Items.COOKED_BEEF, 0.35f);
        BaseRecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.CHICKEN, (ItemLike)Items.COOKED_CHICKEN, 0.35f);
        BaseRecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.COD, (ItemLike)Items.COOKED_COD, 0.35f);
        BaseRecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.KELP, (ItemLike)Items.DRIED_KELP, 0.1f);
        BaseRecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.SALMON, (ItemLike)Items.COOKED_SALMON, 0.35f);
        BaseRecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.MUTTON, (ItemLike)Items.COOKED_MUTTON, 0.35f);
        BaseRecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.PORKCHOP, (ItemLike)Items.COOKED_PORKCHOP, 0.35f);
        BaseRecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.POTATO, (ItemLike)Items.BAKED_POTATO, 0.35f);
        BaseRecipeProvider.simpleCookingRecipe(recipeOutput, cookingMethod, cookingSerializer, recipeFactory, cookingTime, (ItemLike)Items.RABBIT, (ItemLike)Items.COOKED_RABBIT, 0.35f);
    }

    protected static <T extends AbstractCookingRecipe> void simpleCookingRecipe(RecipeOutput recipeOutput, String cookingMethod, RecipeSerializer<T> cookingSerializer, AbstractCookingRecipe.Factory<T> recipeFactory, int cookingTime, ItemLike material, ItemLike result, float experience) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)cookingTime, cookingSerializer, recipeFactory).unlockedBy(BaseRecipeProvider.getHasName(material), BaseRecipeProvider.has(material)).save(recipeOutput, BaseRecipeProvider.getItemName(result) + "_from_" + cookingMethod);
    }

    protected static void waxRecipes(RecipeOutput recipeOutput, FeatureFlagSet requiredFeatures) {
        DataMapHooks.INVERSE_WAXABLES_DATAMAP.forEach((p_337490_, p_337491_) -> {
            if (p_337491_.requiredFeatures().isSubsetOf(requiredFeatures)) {
                ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)p_337491_).requires((ItemLike)p_337490_).requires((ItemLike)Items.HONEYCOMB).group(BaseRecipeProvider.getItemName((ItemLike)p_337491_)).unlockedBy(BaseRecipeProvider.getHasName((ItemLike)p_337490_), BaseRecipeProvider.has((ItemLike)p_337490_)).save(recipeOutput, BaseRecipeProvider.getConversionRecipeName((ItemLike)p_337491_, (ItemLike)Items.HONEYCOMB));
            }
        });
    }

    protected static void grate(RecipeOutput recipeOutput, Block grateBlock, Block material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)grateBlock, (int)4).define(Character.valueOf('M'), (ItemLike)material).pattern(" M ").pattern("M M").pattern(" M ").unlockedBy(BaseRecipeProvider.getHasName((ItemLike)material), BaseRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    protected static void copperBulb(RecipeOutput recipeOutput, Block bulbBlock, Block material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)bulbBlock, (int)4).define(Character.valueOf('C'), (ItemLike)material).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_ROD).pattern(" C ").pattern("CBC").pattern(" R ").unlockedBy(BaseRecipeProvider.getHasName((ItemLike)material), BaseRecipeProvider.has((ItemLike)material)).save(recipeOutput);
    }

    protected static void generateRecipes(RecipeOutput recipeOutput, BlockFamily blockFamily, FeatureFlagSet requiredFeatures) {
        blockFamily.getVariants().forEach((p_313457_, p_313458_) -> {
            if (p_313458_.requiredFeatures().isSubsetOf(requiredFeatures)) {
                BiFunction<ItemLike, ItemLike, RecipeBuilder> bifunction = SHAPE_BUILDERS.get(p_313457_);
                Block itemlike = BaseRecipeProvider.getBaseBlock(blockFamily, p_313457_);
                if (bifunction != null) {
                    RecipeBuilder recipebuilder = bifunction.apply((ItemLike)p_313458_, (ItemLike)itemlike);
                    blockFamily.getRecipeGroupPrefix().ifPresent(p_293701_ -> recipebuilder.group(p_293701_ + (String)(p_313457_ == BlockFamily.Variant.CUT ? "" : "_" + p_313457_.getRecipeGroup())));
                    recipebuilder.unlockedBy(blockFamily.getRecipeUnlockedBy().orElseGet(() -> BaseRecipeProvider.lambda$generateRecipes$21((ItemLike)itemlike)), BaseRecipeProvider.has((ItemLike)itemlike));
                    recipebuilder.save(recipeOutput);
                }
                if (p_313457_ == BlockFamily.Variant.CRACKED) {
                    BaseRecipeProvider.smeltingResultFromBase(recipeOutput, (ItemLike)p_313458_, (ItemLike)itemlike);
                }
            }
        });
    }

    protected static Block getBaseBlock(BlockFamily family, BlockFamily.Variant variant) {
        if (variant == BlockFamily.Variant.CHISELED) {
            if (!family.getVariants().containsKey(BlockFamily.Variant.SLAB)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return family.get(BlockFamily.Variant.SLAB);
        }
        return family.getBaseBlock();
    }

    protected static Criterion<EnterBlockTrigger.TriggerInstance> insideOf(Block block) {
        return CriteriaTriggers.ENTER_BLOCK.createCriterion((CriterionTriggerInstance)new EnterBlockTrigger.TriggerInstance(Optional.empty(), Optional.of(block.builtInRegistryHolder()), Optional.empty()));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> has(MinMaxBounds.Ints count, ItemLike item) {
        return BaseRecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of(new ItemLike[]{item}).withCount(count));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike itemLike) {
        return BaseRecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of(new ItemLike[]{itemLike}));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> tag) {
        return BaseRecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of(tag));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate.Builder ... items) {
        return BaseRecipeProvider.inventoryTrigger((ItemPredicate[])Arrays.stream(items).map(ItemPredicate.Builder::build).toArray(ItemPredicate[]::new));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate ... predicates) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(predicates)));
    }

    protected static String getHasName(ItemLike itemLike) {
        return "has_" + BaseRecipeProvider.getItemName(itemLike);
    }

    protected static String getItemName(ItemLike itemLike) {
        return BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem()).getPath();
    }

    protected static String getSimpleRecipeName(ItemLike itemLike) {
        return BaseRecipeProvider.getItemName(itemLike);
    }

    protected static String getConversionRecipeName(ItemLike result, ItemLike ingredient) {
        return BaseRecipeProvider.getItemName(result) + "_from_" + BaseRecipeProvider.getItemName(ingredient);
    }

    protected static String getSmeltingRecipeName(ItemLike itemLike) {
        return BaseRecipeProvider.getItemName(itemLike) + "_from_smelting";
    }

    protected static String getBlastingRecipeName(ItemLike itemLike) {
        return BaseRecipeProvider.getItemName(itemLike) + "_from_blasting";
    }

    public String getName() {
        return this.name;
    }

    private static /* synthetic */ String lambda$generateRecipes$21(ItemLike itemlike) {
        return BaseRecipeProvider.getHasName(itemlike);
    }
}

