/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.api.data;

import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import tv.mapper.mapperbase.api.block.SlopeBlock;
import tv.mapper.mapperbase.api.block.UpDownBlock;

public class BaseBlockStateProvider
extends BlockStateProvider {
    private String name;

    public BaseBlockStateProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper, String name) {
        super(output, modid, exFileHelper);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void registerStatesAndModels() {
    }

    protected void texturedStairsBlock(StairBlock block, String name, ResourceLocation full, ResourceLocation side, ResourceLocation half) {
        ModelBuilder stairs = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("textured_stairs"))).texture("full", full)).texture("side", side)).texture("half", half);
        ModelBuilder stairsInner = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_inner", this.modLoc("textured_stairs_inner"))).texture("full", full)).texture("side", side);
        ModelBuilder stairsOuter = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_outer", this.modLoc("textured_stairs_outer"))).texture("full", full)).texture("side", side)).texture("half", half);
        this.texturedStairsBlock(block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    private void texturedStairsBlock(StairBlock block, ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
            Half half = (Half)state.getValue((Property)StairBlock.HALF);
            StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
            int yRot = (int)facing.getClockWise().toYRot();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot %= 360).build();
        }, new Property[]{StairBlock.WATERLOGGED});
    }

    protected void upDownBlock(Block block, ModelFile model) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)UpDownBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(model).rotationX(180).addModel()).partialState().with((Property)UpDownBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).addModel();
    }

    protected void allRotationBlock(Block block, ModelFile model) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).modelForState().modelFile(model).rotationX(270).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).modelForState().modelFile(model).rotationX(90).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).modelForState().modelFile(model).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile(model).rotationY(180).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).modelForState().modelFile(model).rotationY(90).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).modelForState().modelFile(model).rotationY(270).uvLock(true).addModel();
    }

    protected void orientableBlock(Block block, ModelFile model, int angleOffset) {
        this.orientableBlock(block, (BlockState $) -> model, angleOffset);
    }

    protected void orientableBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + angleOffset) % 360).build(), new Property[]{BlockStateProperties.WATERLOGGED});
    }

    protected void rooftilesStairsBlock(StairBlock block, ResourceLocation texture) {
        String baseName = BuiltInRegistries.BLOCK.getKey((Object)block).toString();
        ModelBuilder stairs = this.models().stairs(baseName, texture, texture, texture);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", texture, texture, texture);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", texture, texture, texture);
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> BaseBlockStateProvider.lambda$rooftilesStairsBlock$3((ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter, arg_0), new Property[]{StairBlock.WATERLOGGED});
    }

    protected void slopeBlock(Block block, String name, String modid) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        Object modelName = "";
        for (int i = 1; i < 9; ++i) {
            modelName = i == 8 ? modid + ":block/" + name : modid + ":block/" + name + "_slope_" + i * 2;
            builder.partialState().with((Property)SlopeBlock.LAYERS, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile((String)modelName)).addModel();
        }
    }

    protected void slopeBlock(Block block, String name, String modid, Block fullBlock) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        Object modelName = "";
        for (int i = 1; i < 9; ++i) {
            modelName = i == 8 ? String.valueOf(fullBlock.getName()) + ":block/" + String.valueOf(fullBlock.getName()) : modid + ":block/" + name + "_slope_" + i * 2;
            builder.partialState().with((Property)SlopeBlock.LAYERS, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile((String)modelName)).addModel();
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$rooftilesStairsBlock$3(ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
        Half half = (Half)state.getValue((Property)StairBlock.HALF);
        StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
        int yRot = (int)facing.getClockWise().toYRot();
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
            yRot += 270;
        }
        if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
            yRot += 90;
        }
        return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot %= 360).uvLock(false).build();
    }
}

