/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase;

import com.mojang.logging.LogUtils;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.slf4j.Logger;
import tv.mapper.mapperbase.block.MB_Blocks;
import tv.mapper.mapperbase.config.MB_Config;
import tv.mapper.mapperbase.data.MB_DataGenerators;
import tv.mapper.mapperbase.data.loot.MB_Loots;
import tv.mapper.mapperbase.item.MB_CreativeTab;
import tv.mapper.mapperbase.item.MB_Items;
import tv.mapper.mapperbase.item.MB_Tiers;

@Mod(value="mapperbase")
public class MapperBase {
    public static final String MODID = "mapperbase";
    public static final Logger LOGGER = LogUtils.getLogger();

    public MapperBase(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        MB_Blocks.BLOCKS.register(modEventBus);
        MB_Blocks.BLOCK_ITEMS.register(modEventBus);
        MB_Tiers.ARMOR_MATERIALS.register(modEventBus);
        MB_Items.ITEMS.register(modEventBus);
        MB_Loots.LOOT_MODIFIERS.register(modEventBus);
        MB_CreativeTab.CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(MB_DataGenerators::generate);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MB_Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (MB_Config.enableTagViewer) {
            LOGGER.info("Tag Viewer enabled.");
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)MB_Items.STEEL_SHOVEL.get());
            event.accept((ItemLike)MB_Items.STEEL_PICKAXE.get());
            event.accept((ItemLike)MB_Items.STEEL_AXE.get());
            event.accept((ItemLike)MB_Items.STEEL_HOE.get());
        }
        if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            event.accept((ItemLike)MB_Items.STEEL_SWORD.get());
            event.accept((ItemLike)MB_Items.STEEL_HELMET.get());
            event.accept((ItemLike)MB_Items.STEEL_CHESTPLATE.get());
            event.accept((ItemLike)MB_Items.STEEL_LEGGINGS.get());
            event.accept((ItemLike)MB_Items.STEEL_BOOTS.get());
        }
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept((ItemLike)MB_Items.PIG_IRON_CHUNK.get());
            event.accept((ItemLike)MB_Items.RAW_STEEL.get());
            event.accept((ItemLike)MB_Items.STEEL_INGOT.get());
            event.accept((ItemLike)MB_Items.STEEL_NUGGET.get());
        }
    }
}

