/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.util;

import com.mojang.serialization.DynamicOps;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006J\u001a\u0010\b\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/github/cotrin8672/cem/util/EnchantedItemFactory;", "", "<init>", "()V", "pickaxeCache", "", "Lnet/minecraft/world/item/enchantment/ItemEnchantments;", "Lnet/minecraft/world/item/ItemStack;", "getPickaxeItemStack", "enchantmentSet", "tag", "Lnet/minecraft/nbt/CompoundTag;", "context", "Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;", "createenchantablemachinery"})
public final class EnchantedItemFactory {
    @NotNull
    public static final EnchantedItemFactory INSTANCE = new EnchantedItemFactory();
    @NotNull
    private static final Map<ItemEnchantments, ItemStack> pickaxeCache = new LinkedHashMap();

    private EnchantedItemFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ItemStack getPickaxeItemStack(@NotNull ItemEnchantments enchantmentSet) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)enchantmentSet, (String)"enchantmentSet");
        if (pickaxeCache.containsKey(enchantmentSet)) {
            ItemStack itemStack2 = pickaxeCache.get(enchantmentSet);
            Intrinsics.checkNotNull((Object)itemStack2);
            itemStack = itemStack2;
        } else {
            void var2_5;
            ItemStack itemStack3;
            ItemStack $this$getPickaxeItemStack_u24lambda_u240 = itemStack3 = new ItemStack((ItemLike)Items.NETHERITE_PICKAXE);
            boolean bl = false;
            if (!enchantmentSet.isEmpty()) {
                $this$getPickaxeItemStack_u24lambda_u240.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
                $this$getPickaxeItemStack_u24lambda_u240.set(DataComponents.ENCHANTMENTS, (Object)enchantmentSet);
            }
            ItemStack stack = itemStack3;
            pickaxeCache.put(enchantmentSet, stack);
            itemStack = var2_5;
        }
        return itemStack;
    }

    @NotNull
    public final ItemStack getPickaxeItemStack(@Nullable CompoundTag tag, @Nullable MovementContext context) {
        if (tag == null) {
            ItemEnchantments itemEnchantments = ItemEnchantments.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemEnchantments, (String)"EMPTY");
            return this.getPickaxeItemStack(itemEnchantments);
        }
        if (context == null) {
            ItemEnchantments itemEnchantments = ItemEnchantments.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemEnchantments, (String)"EMPTY");
            return this.getPickaxeItemStack(itemEnchantments);
        }
        if (context.temporaryData instanceof ItemStack) {
            Object object = context.temporaryData;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.item.ItemStack");
            return (ItemStack)object;
        }
        Ref.ObjectRef enchantments = new Ref.ObjectRef();
        ItemEnchantments itemEnchantments = ItemEnchantments.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemEnchantments, (String)"EMPTY");
        enchantments.element = itemEnchantments;
        RegistryOps registryOps = context.world.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ItemEnchantments.CODEC.parse((DynamicOps)registryOps, (Object)tag.get("Enchantments")).resultOrPartial().ifPresent(arg_0 -> EnchantedItemFactory.getPickaxeItemStack$lambda$2(arg_0 -> EnchantedItemFactory.getPickaxeItemStack$lambda$1(enchantments, arg_0), arg_0));
        ItemStack stack = this.getPickaxeItemStack((ItemEnchantments)enchantments.element);
        context.temporaryData = stack;
        return stack;
    }

    private static final Unit getPickaxeItemStack$lambda$1(Ref.ObjectRef $enchantments, ItemEnchantments it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $enchantments.element = it;
        return Unit.INSTANCE;
    }

    private static final void getPickaxeItemStack$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

