/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.experience;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.fluids.tank.ConfigurableFluidTank;
import plus.dragons.createdragonsplus.common.fluids.tank.FluidTankBehaviour;
import plus.dragons.createdragonsplus.common.processing.blaze.BlazeBlockEntity;
import plus.dragons.createdragonsplus.util.FieldsNullabilityUnknownByDefault;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceFuel;
import plus.dragons.createenchantmentindustry.common.registry.CEIFluids;

@FieldsNullabilityUnknownByDefault
public abstract class BlazeExperienceBlockEntity
extends BlazeBlockEntity
implements IHaveGoggleInformation {
    public static final String LIGHTNING_BOLT_EXPERIENCE_CHARGE_KEY = "ExperienceCharge";
    public static final TagKey<Block> LIGHTNING_ROD_BLOCKS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"lightning_rods"));
    public static final TagKey<PoiType> LIGHTNING_ROD_POINT_OF_INTEREST_TYPES = TagKey.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"lightning_rods"));
    private boolean isCreative;
    protected FluidTankBehaviour tanks;

    public BlazeExperienceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected abstract ConfigurableFluidTank createNormalTank(Consumer<FluidStack> var1);

    protected abstract ConfigurableFluidTank createSpecialTank(Consumer<FluidStack> var1);

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tanks = new FluidTankBehaviour((SmartBlockEntity)this, List.of(this::createNormalTank, this::createSpecialTank), false);
        behaviours.add((BlockEntityBehaviour)this.tanks);
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevel() {
        if (this.getSpecialExperience() > 0) {
            return BlazeBurnerBlock.HeatLevel.SEETHING;
        }
        double experience = this.getNormalExperience();
        if (experience > 0.0) {
            boolean lowPercent = experience / (double)this.getNormalTank().getCapacity() < 0.0125;
            return lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
        }
        return BlazeBurnerBlock.HeatLevel.SMOULDERING;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putBoolean("isCreative", this.isCreative);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.isCreative = compound.getBoolean("isCreative");
        if (this.isCreative) {
            this.setCreativeTanks(this.getHeatLevelFromBlock());
        }
    }

    public SmartFluidTank getNormalTank() {
        return this.tanks.getHandlers()[0];
    }

    public SmartFluidTank getSpecialTank() {
        return this.tanks.getHandlers()[1];
    }

    public int getNormalExperience() {
        return this.getNormalTank().getFluid().getAmount();
    }

    public int getSpecialExperience() {
        return this.getSpecialTank().getFluid().getAmount();
    }

    public int getTotalExperience() {
        return this.getNormalExperience() + this.getSpecialExperience();
    }

    public boolean consumeExperience(int amount, boolean special, boolean simulate) {
        FluidStack fluid;
        Object tank = special ? this.getSpecialTank() : this.tanks.getCapability();
        FluidStack drained = tank.drain(fluid = new FluidStack(CEIFluids.EXPERIENCE, amount), IFluidHandler.FluidAction.SIMULATE);
        if (drained.getAmount() != amount) {
            return false;
        }
        if (!simulate) {
            tank.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
        return true;
    }

    public boolean applyExperienceFuel(ExperienceFuel fuel, boolean forceOverflow, boolean simulate) {
        SmartFluidTank tank;
        assert (this.level != null);
        if (this.isCreative) {
            return false;
        }
        boolean special = fuel.special();
        SmartFluidTank smartFluidTank = tank = special ? this.getSpecialTank() : this.getNormalTank();
        if (!(tank instanceof ConfigurableFluidTank)) {
            return false;
        }
        ConfigurableFluidTank configurableTank = (ConfigurableFluidTank)tank;
        FluidStack fluid = configurableTank.getFluid();
        if (!fluid.isEmpty() && !fluid.is(CEIFluids.EXPERIENCE)) {
            return false;
        }
        int experience = fuel.experience();
        FluidStack experienceFluid = new FluidStack(CEIFluids.EXPERIENCE, experience);
        int fill = configurableTank.fill(experienceFluid, IFluidHandler.FluidAction.SIMULATE, true);
        if (fill == 0) {
            return false;
        }
        if (fill != experience && !forceOverflow) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.level.isClientSide) {
            this.spawnParticleBurst(special);
        }
        configurableTank.fill(experienceFluid, IFluidHandler.FluidAction.EXECUTE, true);
        BlazeBurnerBlock.HeatLevel heat = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (heat != this.getHeatLevelFromBlock()) {
            this.level.playSound(null, this.worldPosition, SoundEvents.BLAZE_AMBIENT, SoundSource.BLOCKS, 0.125f + this.level.random.nextFloat() * 0.125f, 1.15f - this.level.random.nextFloat() * 0.25f);
        }
        this.notifyUpdate();
        return true;
    }

    public void applyCreativeFuel() {
        assert (this.level != null);
        this.isCreative = true;
        BlazeBurnerBlock.HeatLevel next = this.getHeatLevelFromBlock().nextActiveLevel();
        if (this.level.isClientSide) {
            this.spawnParticleBurst(next.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING));
            return;
        }
        this.playSound();
        if (next == BlazeBurnerBlock.HeatLevel.FADING) {
            next = next.nextActiveLevel();
        }
        this.setCreativeTanks(next);
        this.setBlockHeat(next);
        this.notifyUpdate();
    }

    protected void setCreativeTanks(BlazeBurnerBlock.HeatLevel heatLevel) {
        switch (heatLevel) {
            case KINDLED: {
                int capacity = this.getNormalTank().getCapacity();
                this.tanks.setTank(0, callback -> new CreativeFluidTankBlockEntity.CreativeSmartFluidTank(capacity, callback));
                this.getNormalTank().setFluid(new FluidStack(CEIFluids.EXPERIENCE, capacity));
                break;
            }
            case SEETHING: {
                int capacity = this.getSpecialTank().getCapacity();
                this.tanks.setTank(1, callback -> new CreativeFluidTankBlockEntity.CreativeSmartFluidTank(capacity, callback));
                this.getSpecialTank().setFluid(new FluidStack(CEIFluids.EXPERIENCE, capacity));
                break;
            }
            default: {
                this.tanks.setTank(0, this::createNormalTank);
                this.tanks.setTank(1, this::createSpecialTank);
            }
        }
    }

    @Nullable
    protected BlockPos getStrikePos() {
        assert (this.level != null);
        DimensionType dimension = this.level.dimensionType();
        if (!dimension.hasSkyLight()) {
            return null;
        }
        if (dimension.hasCeiling()) {
            return null;
        }
        return this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, this.worldPosition).below();
    }

    protected boolean strikeLightning(ServerLevel level, BlockPos strikePos) {
        LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)level);
        if (lightning == null) {
            return false;
        }
        lightning.getPersistentData().putBoolean(LIGHTNING_BOLT_EXPERIENCE_CHARGE_KEY, true);
        Optional<BlockPos> rodPos = level.getPoiManager().findAll(poi -> poi.is(LIGHTNING_ROD_POINT_OF_INTEREST_TYPES), pos -> pos.getY() == level.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()) - 1, strikePos, 128, PoiManager.Occupancy.ANY).sorted((_p1, _p2) -> level.random.nextInt(-1, 2)).findFirst();
        lightning.moveTo(Vec3.atBottomCenterOf((Vec3i)((Vec3i)rodPos.orElse(strikePos))));
        level.addFreshEntity((Entity)lightning);
        return rodPos.isEmpty();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.builder().add(CEIFluids.EXPERIENCE.getType().getDescription()).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        boolean speical = false;
        for (SmartFluidTank tank : this.tanks.getHandlers()) {
            CreateLang.builder().add(CreateLang.number((double)tank.getFluid().getAmount()).add(mb).style(speical ? ChatFormatting.BLUE : ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)tank.getCapacity()).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            speical = true;
        }
        return true;
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }
}

