/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.common.block;

import com.github.Pandarix.beautify.core.init.BlockInit;
import com.github.Pandarix.beautify.core.init.SoundInit;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BookStack
extends HorizontalDirectionalBlock {
    public static final MapCodec<BookStack> BOOK_STACK_MAP_CODEC = BookStack.simpleCodec(BookStack::new);
    private static final int MODELCOUNT = 7;
    public static final IntegerProperty BOOKSTACK_MODEL = IntegerProperty.create((String)"bookstack_model", (int)0, (int)6);
    private static final Map<Integer, VoxelShape> SHAPES_FOR_MODEL = ImmutableMap.of((Object)0, (Object)Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), (VoxelShape[])new VoxelShape[0]), (Object)1, (Object)Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), (VoxelShape[])new VoxelShape[0]), (Object)2, (Object)Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0), (VoxelShape[])new VoxelShape[0]), (Object)3, (Object)Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.5, (double)16.0), (VoxelShape[])new VoxelShape[0]), (Object)4, (Object)Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), (VoxelShape[])new VoxelShape[0]), (Object)5, (Object)Shapes.or((VoxelShape)Block.box((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)7.25, (double)15.5), (VoxelShape[])new VoxelShape[0]), (Object)6, (Object)Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), (VoxelShape[])new VoxelShape[0]));

    public BookStack(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BOOKSTACK_MODEL, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return BOOK_STACK_MAP_CODEC;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPES_FOR_MODEL.get(blockState.getValue((Property)BOOKSTACK_MODEL));
    }

    public BlockState updateShape(BlockState p_60541_, Direction p_60542_, BlockState p_60543_, LevelAccessor p_60544_, BlockPos p_60545_, BlockPos p_60546_) {
        if (!p_60541_.canSurvive((LevelReader)p_60544_, p_60545_)) {
            p_60544_.scheduleTick(p_60545_, (Block)this, 1);
        }
        return super.updateShape(p_60541_, p_60542_, p_60543_, p_60544_, p_60545_, p_60546_);
    }

    public boolean canSurvive(BlockState p_49395_, LevelReader p_49396_, BlockPos p_49397_) {
        return BookStack.canSupportRigidBlock((BlockGetter)p_49396_, (BlockPos)p_49397_.below());
    }

    public void tick(BlockState p_48896_, ServerLevel p_48897_, BlockPos p_48898_, Random p_48899_) {
        if (!p_48896_.canSurvive((LevelReader)p_48897_, p_48898_)) {
            p_48897_.destroyBlock(p_48898_, true);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        if (pLevel.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.isShiftKeyDown()) {
            int currentModel = (Integer)pState.getValue((Property)BOOKSTACK_MODEL);
            pLevel.playSound(null, pPos, SoundInit.BOOKSTACK_NEXT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (currentModel + 1 > 6) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BOOKSTACK_MODEL, (Comparable)Integer.valueOf(0)), 3);
                return InteractionResult.SUCCESS;
            }
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BOOKSTACK_MODEL, (Comparable)Integer.valueOf(currentModel + 1)), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        if (state.is((Block)BlockInit.BOOKSTACK.get())) {
            return 1.0f;
        }
        return super.getEnchantPowerBonus(state, level, pos);
    }

    public void fallOn(Level level, BlockState blockState, BlockPos pos, Entity entity, float f) {
        level.playSound(null, pos, SoundInit.BOOKSTACK_FALL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        super.fallOn(level, blockState, pos, entity, f);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Random rand = new Random();
        int randomNum = rand.nextInt(7);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BOOKSTACK_MODEL, (Comparable)Integer.valueOf(randomNum));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{BOOKSTACK_MODEL, FACING});
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (!Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.shift").withStyle(ChatFormatting.YELLOW));
        } else {
            components.add((Component)Component.translatable((String)"bookstack.description1").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"bookstack.description2").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, components, flag);
    }
}

