/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.just_enough_beacons.jei.beacon_payment;

import com.cerbon.cerbons_api.api.static_utilities.MiscUtils;
import com.cerbon.cerbons_api.api.static_utilities.RegistryUtils;
import com.cerbon.just_enough_beacons.jei.beacon_payment.BeaconPaymentRecipe;
import com.cerbon.just_enough_beacons.util.JEBConstants;
import com.cerbon.just_enough_beacons.util.JEBRecipeTypes;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class BeaconPaymentCategory
implements IRecipeCategory<BeaconPaymentRecipe> {
    private final IGuiHelper guiHelper;

    public BeaconPaymentCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    @NotNull
    public RecipeType<BeaconPaymentRecipe> getRecipeType() {
        return JEBRecipeTypes.BEACON_PAYMENT;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"category.beacon_payments");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(JEBConstants.BACKGROUND, 0, 0, 128, 128);
    }

    @NotNull
    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.BEACON));
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull BeaconPaymentRecipe recipe, @NotNull IFocusGroup focuses) {
        int xPos = 2;
        int yPos = 53;
        int count = recipe.getBeaconPaymentSublist().size();
        int y = 0;
        while ((double)y < Math.ceil((double)count / 7.0)) {
            int index;
            for (int x = 0; x < 7 && (index = 7 * y + x) < count; ++x) {
                ItemStack itemStack = recipe.getBeaconPaymentSublist().get(index);
                IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, xPos + 18 * x, yPos + 18 * y).addItemStack(itemStack);
                builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 55, 5).addItemStack(new ItemStack((ItemLike)Blocks.BEACON));
                if (!MiscUtils.isModLoaded((String)"better_beacons")) continue;
                try {
                    Class<?> bbConfigClass = Class.forName("com.cerbon.better_beacons.config.BBConfig");
                    Class<?> rangeAndAmplifierClass = Class.forName("com.cerbon.better_beacons.config.custom.RangeAndAmplifier");
                    Class<?> paymentItemsRangeManagerClass = Class.forName("com.cerbon.better_beacons.datapack.PaymentItemsRangeManager");
                    Field beaconRangeAndAmplifierField = bbConfigClass.getField("beaconRangeAndAmplifier");
                    Field isPaymentItemRangeEnabledField = rangeAndAmplifierClass.getField("isPaymentItemRangeEnabled");
                    Method getItemRangeMapMethod = paymentItemsRangeManagerClass.getMethod("getItemRangeMap", new Class[0]);
                    Object bbConfigInstance = bbConfigClass.newInstance();
                    Object rangeAndAmplifierInstance = beaconRangeAndAmplifierField.get(bbConfigInstance);
                    boolean isPaymentItemRangeEnabled = (Boolean)isPaymentItemRangeEnabledField.get(rangeAndAmplifierInstance);
                    if (recipe.getBeaconPaymentSublist().isEmpty() || !isPaymentItemRangeEnabled) continue;
                    HashMap itemRangeMap = (HashMap)getItemRangeMapMethod.invoke(null, new Object[0]);
                    int range = itemRangeMap.getOrDefault(RegistryUtils.getItemKeyAsString((Item)itemStack.getItem()), 0);
                    slot.addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(Component.translatable((String)"jei.just_enough_beacons.payment_item.tooltip", (Object[])new Object[]{range}).withStyle(ChatFormatting.YELLOW)));
                    continue;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                    JEBConstants.LOGGER.error("Couldn't set beacon payment items range values.", (Throwable)e);
                }
            }
            ++y;
        }
    }
}

