/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.just_enough_beacons.jei.beacon_base_block;

import com.cerbon.cerbons_api.api.static_utilities.MiscUtils;
import com.cerbon.cerbons_api.api.static_utilities.RegistryUtils;
import com.cerbon.just_enough_beacons.jei.beacon_base_block.BeaconBaseBlockRecipe;
import com.cerbon.just_enough_beacons.util.JEBConstants;
import com.cerbon.just_enough_beacons.util.JEBRecipeTypes;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class BeaconBaseBlockCategory
implements IRecipeCategory<BeaconBaseBlockRecipe> {
    private final IGuiHelper guiHelper;

    public BeaconBaseBlockCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    @NotNull
    public RecipeType<BeaconBaseBlockRecipe> getRecipeType() {
        return JEBRecipeTypes.BEACON_BASE_BLOCK;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"category.beacon_base_blocks");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(JEBConstants.BACKGROUND, 0, 0, 128, 128);
    }

    @NotNull
    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.BEACON));
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, BeaconBaseBlockRecipe recipe, @NotNull IFocusGroup focuses) {
        int xPos = 2;
        int yPos = 53;
        int count = recipe.getBeaconBaseBlocksSublist().size();
        int y = 0;
        while ((double)y < Math.ceil((double)count / 7.0)) {
            int index;
            for (int x = 0; x < 7 && (index = 7 * y + x) < count; ++x) {
                ItemStack itemStack = recipe.getBeaconBaseBlocksSublist().get(index);
                IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, xPos + 18 * x, yPos + 18 * y).addItemStack(itemStack);
                builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 55, 5).addItemStack(new ItemStack((ItemLike)Blocks.BEACON));
                if (!MiscUtils.isModLoaded((String)"better_beacons")) continue;
                try {
                    Class<?> bbConfigClass = Class.forName("com.cerbon.better_beacons.config.BBConfig");
                    Class<?> rangeAndAmplifierClass = Class.forName("com.cerbon.better_beacons.config.custom.RangeAndAmplifier");
                    Class<?> baseBlocksAmplifierManagerClass = Class.forName("com.cerbon.better_beacons.datapack.BaseBlocksAmplifierManager");
                    Field beaconRangeAndAmplifierField = bbConfigClass.getField("beaconRangeAndAmplifier");
                    Field isBaseBlockAmplifierEnabledField = rangeAndAmplifierClass.getField("isBaseBlockAmplifierEnabled");
                    Method getBlockAmplifierMapMethod = baseBlocksAmplifierManagerClass.getMethod("getBlockAmplifierMap", new Class[0]);
                    Object bbConfigInstance = bbConfigClass.newInstance();
                    Object rangeAndAmplifierInstance = beaconRangeAndAmplifierField.get(bbConfigInstance);
                    boolean isBaseBlockAmplifierEnabled = (Boolean)isBaseBlockAmplifierEnabledField.get(rangeAndAmplifierInstance);
                    if (recipe.getBeaconBaseBlocksSublist().isEmpty() || !isBaseBlockAmplifierEnabled) continue;
                    HashMap blockAmplifierMap = (HashMap)getBlockAmplifierMapMethod.invoke(null, new Object[0]);
                    String itemId = RegistryUtils.getItemKeyAsString((Item)itemStack.getItem());
                    Block block = RegistryUtils.getBlockByKey((String)itemId);
                    int amplifier = blockAmplifierMap.getOrDefault(block, 0);
                    slot.addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(Component.translatable((String)"jei.just_enough_beacons.base_blocks.tooltip", (Object[])new Object[]{amplifier}).withStyle(ChatFormatting.YELLOW)));
                    continue;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                    JEBConstants.LOGGER.error("Couldn't set beacon base blocks amplifier values.", (Throwable)e);
                }
            }
            ++y;
        }
    }
}

