/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import com.simibubi.create.foundation.utility.CreateLang;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.crn.util.ESpeedUnit;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;

public class ModUtils {
    private static final Cache<int[]> dyeColorsCache = new Cache(() -> Arrays.stream(DyeColor.values()).mapToInt(x -> x == DyeColor.ORANGE ? -26368 : 0xFF000000 | x.getTextColor() & 0xFFFFFF).toArray(), ECachingPriority.LOW);

    public static float clockHandDegrees(long time, int divisor) {
        return 360.0f / (float)divisor * (float)(time % (long)divisor);
    }

    public static double calcSpeed(double metersPerTick, ESpeedUnit unit) {
        return metersPerTick * 20.0 * unit.getFactor();
    }

    public static MutableComponent calcSpeedString(double metersPerTick, ESpeedUnit unit) {
        return TextUtils.text((String)((int)Math.abs(Math.round(ModUtils.calcSpeed(metersPerTick, unit))) + " " + unit.getUnit()));
    }

    public static int calculateMedian(Queue<Integer> history, int smoothingThreshold, Predicate<Integer> filter) {
        if (history.isEmpty()) {
            return 0;
        }
        LinkedList<Integer> values = new LinkedList<Integer>();
        Iterator iterator = history.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (!filter.test(i)) continue;
            values.add(i);
        }
        Collections.sort(values);
        int median = 0;
        if (values.size() % 2 == 0) {
            median = (int)(((double)((Integer)values.get(values.size() / 2)).intValue() + (double)((Integer)values.get(values.size() / 2 + 1)).intValue()) / 2.0);
        }
        int med = median = ((Integer)values.get(values.size() / 2)).intValue();
        return (int)history.stream().mapToInt(x -> x).filter(x -> Math.abs(med - x) <= smoothingThreshold).average().orElse(0.0);
    }

    public static String timeRemainingString(long ticks) {
        StringBuilder sb = new StringBuilder();
        String unpredictable = " ~ ";
        String whitespace = " ";
        if (ticks == -1L || ticks >= 119700L) {
            sb.append(" ");
            sb.append(" ~ ");
        } else if (ticks < 200L) {
            sb.append(CreateLang.translateDirect((String)"display_source.station_summary.now", (Object[])new Object[0]).getString());
        } else {
            long min = ticks / 1200L;
            long sec = ticks / 20L % 60L;
            if ((sec = (long)(Mth.ceil((float)((float)sec / 15.0f)) * 15)) == 60L) {
                ++min;
                sec = 0L;
            }
            sb.append(min > 0L ? TextUtils.text((String)String.valueOf(min)).getString() : "");
            sb.append(min > 0L ? CreateLang.translateDirect((String)"display_source.station_summary.minutes", (Object[])new Object[0]).getString() : CreateLang.translateDirect((String)"display_source.station_summary.seconds", (Object[])new Object[]{sec}).getString());
        }
        return sb.toString();
    }

    public static long generateId(Predicate<Long> exists) {
        long id;
        while (exists.test(id = DragonLib.RANDOM.nextLong())) {
        }
        return id;
    }

    public static String formatTime(long time, boolean asETA) throws RuntimeSideException {
        if (Platform.getEnvironment() != Env.CLIENT) {
            throw new RuntimeSideException(true);
        }
        if (asETA) {
            return ModUtils.timeRemainingString(time - DragonLib.getCurrentWorldTime());
        }
        return TimeUtils.parseTime((long)((time + DragonLib.daytimeShift()) % DragonLib.ticksPerDay()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
    }

    public static int[] getDyeColors() {
        return (int[])dyeColorsCache.get();
    }

    public static long convertToTimeTicks(int hours, int minutes) {
        return (long)((double)hours * 1000.0 + 16.666666666666668 * (double)minutes);
    }

    private static Pattern buildPattern(String src) {
        String escaped = "\\Q" + src.replace("*", "\\E(.*)\\Q") + "\\E";
        return Pattern.compile(escaped);
    }

    public static boolean hasWildcards(String text) {
        return text.contains("*");
    }

    public static Collection<String> wildcardMatches(String src, Collection<String> pool) {
        try {
            Pattern p = ModUtils.buildPattern(src);
            LinkedList<String> res = new LinkedList<String>();
            for (String text : pool) {
                Matcher m = p.matcher(text);
                if (!m.matches()) continue;
                res.add(text);
            }
            return res;
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.warn("Error while checking regex: " + String.valueOf(e));
            return List.of();
        }
    }

    public static Map<String, List<String>> mapWildcards(String src, List<String> targets, Collection<String> pool) {
        Pattern p = ModUtils.buildPattern(src);
        LinkedHashMap<String, List<String>> res = new LinkedHashMap<String, List<String>>();
        for (String text : pool) {
            Matcher m = p.matcher(text);
            if (!m.matches()) continue;
            int g = m.groupCount();
            ArrayList<String> groups = new ArrayList<String>(g);
            for (int i = 1; i <= g; ++i) {
                groups.add(m.group(i));
            }
            ArrayList<String> out = new ArrayList<String>();
            for (String target : targets) {
                String[] part = target.split("\\*", -1);
                int S = part.length - 1;
                StringBuilder sb = new StringBuilder(part[0]);
                if (S == 1) {
                    sb.append(String.join((CharSequence)"", groups)).append(part[1]);
                } else if (S > 1) {
                    for (int i = 0; i < S; ++i) {
                        String fill;
                        if (i < S - 1) {
                            fill = i < g ? (String)groups.get(i) : "";
                        } else {
                            int start = Math.min(i, g);
                            fill = String.join((CharSequence)"", groups.subList(start, g));
                        }
                        sb.append(fill).append(part[i + 1]);
                    }
                }
                out.add(sb.toString().replace("*", ""));
            }
            res.put(text, out);
        }
        return res;
    }
}

