/*
 * Decompiled with CFR 0.152.
 */
package net.ultimatech.bountifulblocks.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.ultimatech.bountifulblocks.block.BBBlocks;
import org.jetbrains.annotations.Nullable;

public class MudPotBlock
extends DecoratedPotBlock {
    public MudPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return BBBlocks.MUD_POT.asItem().getDefaultInstance();
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity mudPotBlockEntity = (DecoratedPotBlockEntity)blockEntity;
            if (level.isClientSide) {
                return ItemInteractionResult.CONSUME;
            }
            ItemStack itemstack1 = mudPotBlockEntity.getTheItem();
            if (!itemStack.isEmpty() && (itemstack1.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)itemstack1, (ItemStack)itemStack) && itemstack1.getCount() < itemstack1.getMaxStackSize())) {
                float f;
                mudPotBlockEntity.wobble(DecoratedPotBlockEntity.WobbleStyle.POSITIVE);
                player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                ItemStack itemstack = itemStack.consumeAndReturn(1, (LivingEntity)player);
                if (mudPotBlockEntity.isEmpty()) {
                    mudPotBlockEntity.setTheItem(itemstack);
                    f = (float)itemstack.getCount() / (float)itemstack.getMaxStackSize();
                } else {
                    itemstack1.grow(1);
                    f = (float)itemstack1.getCount() / (float)itemstack1.getMaxStackSize();
                }
                level.playSound(null, blockPos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 0.7f + 0.5f * f);
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.DUST_PLUME, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.2, (double)blockPos.getZ() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
                mudPotBlockEntity.setChanged();
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DecoratedPotBlockEntity(blockPos, blockState);
    }

    protected boolean isOcclusionShapeFullBlock(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return false;
    }

    protected boolean useShapeForLightOcclusion(BlockState pState) {
        return false;
    }
}

