/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.util.pond.OwoEntityRenderDispatcherExtension;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class InventoryEntityComponent<E extends Entity>
extends EntityComponent<E> {
    private float startingRotation = -45.0f;
    private float lastBbWidth = 0.0f;
    private float lastBbHeight = 0.0f;
    private ScaleFitType type = ScaleFitType.NONE;
    public float xOffset = 0.0f;
    public float yOffset = 0.0f;
    private TriConsumer<OwoUIDrawContext, Component, Runnable> renderWrapping = (ctx, component, runnable) -> runnable.run();

    public InventoryEntityComponent(Sizing sizing, E entity) {
        super(sizing, entity);
        this.lastBbWidth = entity.getBbWidth();
        this.lastBbHeight = entity.getBbHeight();
    }

    public InventoryEntityComponent(Sizing sizing, EntityType<E> type, @Nullable CompoundTag nbt) {
        super(sizing, type, nbt);
    }

    public static <E extends Entity> InventoryEntityComponent<E> of(Sizing verticalSizing, Sizing horizontalSizing, E entity) {
        InventoryEntityComponent<E> component = new InventoryEntityComponent<E>(verticalSizing, entity);
        component.horizontalSizing(horizontalSizing);
        return component;
    }

    private float getEntityScale() {
        float f;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            f = living.getScale();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public InventoryEntityComponent<E> renderWrapping(TriConsumer<OwoUIDrawContext, Component, Runnable> renderWrapping) {
        this.renderWrapping = renderWrapping;
        return this;
    }

    public InventoryEntityComponent<E> scaleToFit(boolean scaleToFit) {
        if (scaleToFit) {
            float componentHeight = ((Sizing)this.verticalSizing().get()).value;
            float componentWidth = (float)((Sizing)this.horizontalSizing().get()).value - 40.0f;
            float entityHeight = this.entity.getBbHeight() * (Math.min(componentWidth, componentHeight) / Math.max(componentWidth, componentHeight));
            float entityWidth = this.entity.getBbWidth() * (Math.max(componentWidth, componentHeight) / Math.min(componentWidth, componentHeight));
            float length = Math.max(entityHeight, entityWidth);
            float baseScale = 0.35f / length;
            this.scale(baseScale);
            this.type = ScaleFitType.BOTH;
        } else {
            this.scale(1.0f);
            this.type = ScaleFitType.NONE;
        }
        return this;
    }

    public InventoryEntityComponent<E> startingRotation(float value) {
        this.startingRotation = value;
        return this;
    }

    public InventoryEntityComponent<E> scaleToFitVertically(boolean scaleToFit) {
        this.scale(scaleToFit ? 0.5f / this.entity.getBbHeight() : 1.0f);
        this.type = scaleToFit ? ScaleFitType.VERTICAL : ScaleFitType.NONE;
        return this;
    }

    public InventoryEntityComponent<E> scaleToFitHorizontally(boolean scaleToFit) {
        this.scale(scaleToFit ? 0.5f / this.entity.getBbWidth() : 1.0f);
        this.type = scaleToFit ? ScaleFitType.HORIZONTAL : ScaleFitType.NONE;
        return this;
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        Entity entity = this.entity;
        if (!(entity instanceof LivingEntity)) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (this.lastBbWidth != this.entity.getBbWidth() || this.lastBbHeight != this.entity.getBbHeight()) {
            switch (this.type.ordinal()) {
                case 0: {
                    this.scaleToFitVertically(true);
                    break;
                }
                case 1: {
                    this.scaleToFitHorizontally(true);
                    break;
                }
                case 2: {
                    this.scaleToFit(true);
                    break;
                }
            }
            this.lastBbWidth = this.entity.getBbWidth();
            this.lastBbHeight = this.entity.getBbHeight();
        }
        PoseStack matrices = context.pose();
        matrices.pushPose();
        int maxLength = Math.max(this.width, this.height);
        matrices.translate((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, 60.0f);
        matrices.scale(75.0f * this.scale * (float)maxLength / 64.0f, -75.0f * this.scale * (float)maxLength / 64.0f, 75.0f * this.scale);
        matrices.translate(0.0f, this.entity.getBbHeight() / -2.0f, 0.0f);
        matrices.translate(this.xOffset, this.yOffset, 0.0f);
        this.transform.accept(matrices);
        float prevYBodyRot0 = living.yBodyRotO;
        float prevYBodyRot = living.yBodyRot;
        float prevYRot = living.getYRot();
        float prevYRot0 = living.yRotO;
        float prevXRot = living.getXRot();
        float prevXRot0 = living.xRotO;
        float prevYHeadRot0 = living.yHeadRotO;
        float prevYHeadRot = living.yHeadRot;
        OwoEntityRenderDispatcherExtension dispatcher = (OwoEntityRenderDispatcherExtension)this.dispatcher;
        if (this.lookAtCursor) {
            float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
            float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.x) - (float)this.width / 2.0f) / 40.0f));
            living.yHeadRotO = -yRotation;
            this.entity.yRotO = -yRotation;
            this.entity.xRotO = xRotation * 0.65f;
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrices.mulPose(Axis.XP.rotationDegrees(xRotation * 0.35f));
            matrices.mulPose(Axis.YP.rotationDegrees(yRotation * 0.555f));
        } else {
            float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
            this.entity.xRotO = xRotation * 0.35f;
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrices.mulPose(Axis.XP.rotationDegrees(xRotation * 0.15f));
            matrices.mulPose(Axis.XP.rotationDegrees(15.0f));
            matrices.mulPose(Axis.YP.rotationDegrees(this.startingRotation + this.mouseRotation));
        }
        dispatcher.owo$setCounterRotate(true);
        dispatcher.owo$setShowNametag(this.showNametag);
        Lighting.setupForEntityInInventory();
        this.dispatcher.setRenderShadow(false);
        living.yBodyRotO = 0.0f;
        living.yBodyRot = 0.0f;
        living.setYRot(0.0f);
        living.yHeadRot = living.yBodyRot;
        living.yHeadRotO = living.yBodyRotO;
        RenderSystem.disableDepthTest();
        this.renderWrapping.accept((Object)context, (Object)this, () -> this.dispatcher.render(this.entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrices, (MultiBufferSource)this.entityBuffers, 0xF000F0));
        this.dispatcher.setRenderShadow(true);
        living.yBodyRotO = prevYBodyRot0;
        living.yBodyRot = prevYBodyRot;
        living.setYRot(prevYRot);
        living.yRotO = prevYRot0;
        living.setXRot(prevXRot);
        living.xRotO = prevXRot0;
        living.yHeadRotO = prevYHeadRot0;
        living.yHeadRot = prevYHeadRot;
        this.dispatcher.setRenderShadow(true);
        this.entityBuffers.endBatch();
        Lighting.setupFor3DItems();
        matrices.popPose();
        dispatcher.owo$setCounterRotate(false);
        dispatcher.owo$setShowNametag(true);
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        this.scale += (float)(amount * (double)this.scale * (double)0.1f);
        return true;
    }

    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.xOffset -= 0.05f;
        } else if (keyCode == 262) {
            this.xOffset += 0.05f;
        }
        if (keyCode == 265) {
            this.yOffset += 0.05f;
        } else if (keyCode == 264) {
            this.yOffset -= 0.05f;
        }
        return super.onKeyPress(keyCode, scanCode, modifiers);
    }

    public static enum ScaleFitType {
        VERTICAL,
        HORIZONTAL,
        BOTH,
        NONE;

    }
}

